/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.command;

import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ArgumentParser {
    private String[] args;
    private Command command;
    private CommandSender sender;

    public ArgumentParser(String[] stringArray) {
        this.args = (String[])stringArray.clone();
    }

    public ArgumentParser(String[] stringArray, Command command, CommandSender commandSender) {
        this(stringArray);
        this.command = command;
        this.sender = commandSender;
    }

    public int size() {
        return this.args.length;
    }

    public String get(int n) {
        return this.args[n - 1];
    }

    public String getFrom(int n) {
        return this.getFrom(n, " ");
    }

    public String getFrom(int n, String string) {
        if (n > this.size()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int i = n; i < this.args.length; ++i) {
            if (!bl) {
                stringBuilder.append(string);
            } else {
                bl = false;
            }
            stringBuilder.append(this.args[i]);
        }
        return stringBuilder.toString();
    }

    public double getDouble(int n) {
        try {
            return Double.parseDouble(this.get(n).replace(",", "."));
        }
        catch (Exception exception) {
            throw new NotANumberException(this.get(n));
        }
    }

    public long getLong(int n) {
        try {
            return Long.parseLong(this.get(n));
        }
        catch (Exception exception) {
            throw new NotANumberException(this.get(n));
        }
    }

    public int getInt(int n) {
        try {
            return Integer.parseInt(this.get(n));
        }
        catch (Exception exception) {
            throw new NotANumberException(this.get(n));
        }
    }

    public boolean getBoolean(int n) {
        try {
            return Boolean.parseBoolean(this.get(n));
        }
        catch (Exception exception) {
            throw new NotABooleanException(this.get(n));
        }
    }

    public Player getPlayer(int n) {
        String string = this.get(n);
        Player player = Bukkit.getPlayer((String)string);
        if (player == null) {
            throw new PlayerNotFoundException(string);
        }
        return player;
    }

    public boolean hasNoArguments() {
        return this.size() == 0;
    }

    public boolean hasExactly(int n) {
        return this.size() == n;
    }

    public boolean hasAtLeast(int n) {
        return this.size() >= n;
    }

    public boolean hasLessThan(int n) {
        return this.size() < n;
    }

    public String[] getArgs() {
        return this.args;
    }

    public Command getCommand() {
        return this.command;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public class NotABooleanException
    extends ParameterException {
        public NotABooleanException(String string) {
            super(string);
        }
    }

    public class PlayerNotFoundException
    extends ParameterException {
        public PlayerNotFoundException(String string) {
            super(string);
        }
    }

    public class NotANumberException
    extends ParameterException {
        public NotANumberException(String string) {
            super(string);
        }
    }

    public class ParameterException
    extends RuntimeException {
        public ParameterException(String string) {
            super(string, null, false, false);
        }
    }
}

