/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.mylogo.chestlock.command.ArgumentParser;
import me.mylogo.chestlock.command.Commands;
import me.mylogo.chestlock.command.Perm;
import me.mylogo.chestlock.command.Sender;
import me.mylogo.chestlock.command.SenderType;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public abstract class Command
implements CommandExecutor,
TabCompleter {
    public static final String BLACK = ChatColor.BLACK.toString();
    public static final String DARK_BLUE = ChatColor.DARK_BLUE.toString();
    public static final String DARK_GREEN = ChatColor.DARK_GREEN.toString();
    public static final String DARK_AQUA = ChatColor.DARK_AQUA.toString();
    public static final String DARK_RED = ChatColor.DARK_RED.toString();
    public static final String DARK_PURPLE = ChatColor.DARK_PURPLE.toString();
    public static final String GOLD = ChatColor.GOLD.toString();
    public static final String GRAY = ChatColor.GRAY.toString();
    public static final String DARK_GRAY = ChatColor.DARK_GRAY.toString();
    public static final String BLUE = ChatColor.BLUE.toString();
    public static final String GREEN = ChatColor.GREEN.toString();
    public static final String AQUA = ChatColor.AQUA.toString();
    public static final String RED = ChatColor.RED.toString();
    public static final String LIGHT_PURPLE = ChatColor.LIGHT_PURPLE.toString();
    public static final String YELLOW = ChatColor.YELLOW.toString();
    public static final String WHITE = ChatColor.WHITE.toString();
    public static final String MAGIC = ChatColor.MAGIC.toString();
    public static final String BOLD = ChatColor.BOLD.toString();
    public static final String STRIKETHROUGH = ChatColor.STRIKETHROUGH.toString();
    public static final String UNDERLINE = ChatColor.UNDERLINE.toString();
    public static final String ITALIC = ChatColor.ITALIC.toString();
    public static final String RESET = ChatColor.RESET.toString();
    private static final String PERMISSION_SPLITTER = ".";
    Commands commands;
    private SenderType target;
    private Command parent;
    private String name;
    private boolean hidden;
    private List<String> aliases;
    private List<Command> subCommands;
    private String permission;

    public Command(String string, String ... stringArray) {
        this.name = string.toLowerCase();
        this.aliases = new ArrayList<String>(Arrays.stream(stringArray).map(String::toLowerCase).collect(Collectors.toList()));
        this.subCommands = new ArrayList<Command>();
        if (this.getClass().isAnnotationPresent(Perm.class)) {
            Perm perm = this.getClass().getAnnotation(Perm.class);
            this.permission = perm.value();
        }
        this.target = this.getClass().isAnnotationPresent(Sender.class) ? this.getClass().getAnnotation(Sender.class).sender() : SenderType.ANY;
    }

    public List<String> getNameAndAliases() {
        ArrayList<String> arrayList = new ArrayList<String>(this.aliases);
        arrayList.add(this.getName());
        return arrayList;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String string) {
        this.permission = string;
    }

    public boolean isCommand(String string) {
        return this.name.equalsIgnoreCase(string) || this.aliases.stream().anyMatch(string2 -> string2.equalsIgnoreCase(string));
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void addSubCommand(Command command) {
        command.parent = this;
        command.commands = this.commands;
        this.subCommands.add(command);
    }

    public String getEffectivePermission() {
        return this.permission != null ? (this.parent != null ? (this.parent.getEffectivePermission() != null ? this.parent.getEffectivePermission() + PERMISSION_SPLITTER : "") + this.permission : this.permission) : (this.parent != null ? this.parent.getEffectivePermission() : null);
    }

    protected void sendUsage(Player player, String string) {
        player.sendMessage(YELLOW + BOLD + "Usage: " + GREEN + "/" + string);
    }

    protected abstract void execute(CommandSender var1, ArgumentParser var2);

    public boolean onCommand(CommandSender commandSender, org.bukkit.command.Command command, String string, String[] stringArray) {
        ArgumentParser argumentParser = new ArgumentParser(stringArray, command, commandSender);
        if (command == null || this.isCommand(command.getName())) {
            if (argumentParser.hasAtLeast(1)) {
                String string2 = argumentParser.get(1);
                for (Command command2 : this.subCommands) {
                    if (!command2.isCommand(string2)) continue;
                    String[] stringArray2 = new String[stringArray.length - 1];
                    System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
                    return command2.onCommand(commandSender, null, string, stringArray2);
                }
                this.tryToExecute(commandSender, argumentParser);
                return true;
            }
            this.tryToExecute(commandSender, argumentParser);
            return true;
        }
        return false;
    }

    private Commands getCommands() {
        return this.getParent() != null ? this.getParent().getCommands() : this.commands;
    }

    private void tryToExecute(CommandSender commandSender, ArgumentParser argumentParser) {
        if (this.mayUseCommand(commandSender)) {
            try {
                this.execute(commandSender, argumentParser);
            }
            catch (ArgumentParser.PlayerNotFoundException playerNotFoundException) {
                commandSender.sendMessage(this.getCommands().playerNotFound.replace("%player%", playerNotFoundException.getMessage()));
            }
            catch (ArgumentParser.NotANumberException notANumberException) {
                commandSender.sendMessage(this.getCommands().noNumber.replace("%num%", notANumberException.getMessage()));
            }
            catch (ArgumentParser.NotABooleanException notABooleanException) {
                commandSender.sendMessage(this.getCommands().noBoolean.replace("%value%", notABooleanException.getMessage()));
            }
        }
    }

    private boolean mayUseCommand(CommandSender commandSender) {
        if (this.canUseCommand(commandSender)) {
            if (this.isPermittedToUseCommand(commandSender)) {
                return true;
            }
            commandSender.sendMessage(this.getNoPermissionsMessage());
            return false;
        }
        if (this.target == SenderType.PLAYER_ONLY) {
            commandSender.sendMessage(this.getPlayerOnlyMessage());
        } else {
            commandSender.sendMessage(this.getConsoleOnlyMessage());
        }
        return false;
    }

    public boolean isPermittedToUseCommand(CommandSender commandSender) {
        String string = this.getEffectivePermission();
        return string == null || commandSender.hasPermission(string);
    }

    public boolean canUseCommand(CommandSender commandSender) {
        return this.target == SenderType.ANY || (this.target == SenderType.PLAYER_ONLY ? commandSender instanceof Player : this.target == SenderType.CONSOLE_ONLY && commandSender instanceof CommandSender);
    }

    public List<String> onTabComplete(CommandSender commandSender, org.bukkit.command.Command command, String string, String[] stringArray) {
        ArgumentParser argumentParser = new ArgumentParser(stringArray, command, commandSender);
        if (command == null || this.isCommand(string)) {
            if (argumentParser.hasAtLeast(1)) {
                String string2 = argumentParser.get(1);
                for (Command command2 : this.subCommands) {
                    if (!command2.isCommand(string2)) continue;
                    String[] stringArray2 = new String[stringArray.length - 1];
                    System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
                    return command2.onTabComplete(commandSender, null, string, stringArray2);
                }
            }
            return this.completeTab(commandSender, command, argumentParser);
        }
        return this.completeTab(commandSender, command, argumentParser);
    }

    protected List<String> completeTab(CommandSender commandSender, org.bukkit.command.Command command2, ArgumentParser argumentParser) {
        String string;
        List<String> list = this.subCommands.stream().filter(command -> !command.hidden).filter(command -> command.isPermittedToUseCommand(commandSender)).filter(command -> command.canUseCommand(commandSender)).map(Command::getName).collect(Collectors.toList());
        if (argumentParser.hasAtLeast(1) && list.size() > 0 && !(string = argumentParser.get(argumentParser.size()).toLowerCase()).isEmpty()) {
            list = list.stream().filter(string2 -> string2.startsWith(string)).collect(Collectors.toList());
        }
        return list.size() > 0 ? list : null;
    }

    public List<String> getSubCommandNames() {
        return this.subCommands.stream().filter(command -> !command.hidden).map(Command::getName).collect(Collectors.toList());
    }

    public String getNoPermissionsMessage() {
        return this.getCommands().noPermissions;
    }

    public String getPlayerOnlyMessage() {
        return ChatColor.RED + "This command may only be executed by players.";
    }

    public String getConsoleOnlyMessage() {
        return ChatColor.RED + "This command may only be executed by the console.";
    }

    public Command getParent() {
        return this.parent;
    }

    public List<Command> getSubCommands() {
        return new ArrayList<Command>(this.subCommands);
    }

    protected String prefix() {
        return this.commands != null ? this.commands.getPrefix() : this.getParent().prefix();
    }

    protected String prefixedMessage(String string) {
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        return this.prefix() + (this.prefix().charAt(this.prefix().length() - 1) == ' ' ? string : " " + string);
    }

    protected void hide() {
        this.hidden = true;
    }
}

