/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.command;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import me.mylogo.chestlock.command.Command;
import me.mylogo.chestlock.command.CustomCommand;
import me.mylogo.chestlock.command.Inject;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Commands
implements Listener {
    private JavaPlugin plugin;
    private List<CustomCommand> customCommands;
    private List<Injection<?>> injections;
    private String prefix;
    String playerNotFound;
    String noNumber;
    String noBoolean;
    String noPermissions;

    public Commands(JavaPlugin javaPlugin) {
        this(javaPlugin, "[PREFIX] ");
    }

    public Commands(JavaPlugin javaPlugin, String string) {
        this.plugin = javaPlugin;
        this.customCommands = new ArrayList<CustomCommand>();
        this.injections = new ArrayList();
        this.prefix = string;
        this.playerNotFound = string + ChatColor.RED + "The player '%player%' is not online!";
        this.noNumber = string + ChatColor.RED + "Entered number '%num%' is invalid!";
        this.noBoolean = string + ChatColor.RED + "Entered truth value '%value%' is invalid!";
        this.noPermissions = string + ChatColor.RED + "You're not permitted to use this command!";
    }

    public <T> Commands addDependencyInjector(Class<T> clazz, Function<String, ? extends T> function, String string) {
        Objects.requireNonNull(clazz, "clazz may not be null");
        Objects.requireNonNull(function, "function may not be null");
        this.injections.add(new Injection<T>(clazz, function, string));
        return this;
    }

    public <T> Commands addStaticDependencyInjector(Class<T> clazz, T t, String string2) {
        return this.addDependencyInjector(clazz, string -> t, string2);
    }

    public <T> Commands addForcedDependencyInjector(Class<T> clazz, Function<String, ? extends T> function) {
        this.injections.add(new ForcedInjection<T>(clazz, function));
        return this;
    }

    public <T> Commands addStaticForcedDependencyInjector(Class<T> clazz, T t) {
        return this.addForcedDependencyInjector(clazz, string -> t);
    }

    private void injectDependencies(Object object) {
        Field[] fieldArray;
        Class<?> clazz = object.getClass();
        block0: for (Field field : fieldArray = clazz.getDeclaredFields()) {
            for (Injection<?> injection : this.injections) {
                if (!injection.shallInject(field)) continue;
                injection.inject(object, field);
                continue block0;
            }
        }
    }

    public Commands registerCommand(Command command) {
        this.injectDependencies(command);
        command.commands = this;
        String string = command.getName();
        PluginCommand pluginCommand = this.plugin.getCommand(string);
        if (pluginCommand != null) {
            pluginCommand.setExecutor((CommandExecutor)command);
            pluginCommand.setTabCompleter((TabCompleter)command);
        } else if (command instanceof CustomCommand) {
            if (this.customCommands.size() == 0) {
                Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            }
            this.customCommands.add((CustomCommand)command);
        } else {
            throw new RuntimeException("Could not find command named " + command.getName());
        }
        return this;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onAsyncChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        String string = asyncPlayerChatEvent.getMessage();
        for (CustomCommand customCommand : this.customCommands) {
            if (!customCommand.isCustomCommand(string)) continue;
            customCommand.handleCustomCommand(asyncPlayerChatEvent);
            asyncPlayerChatEvent.setCancelled(true);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String prefixedMessage(String string) {
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        return this.prefix + (this.prefix.charAt(this.prefix.length() - 1) == ' ' ? string : " " + string);
    }

    public Commands setErrorMessages(String string, String string2, String string3) {
        this.playerNotFound = string;
        this.noNumber = string2;
        this.noPermissions = string3;
        return this;
    }

    private class ForcedInjection<T>
    extends Injection<T> {
        public ForcedInjection(Class<T> clazz, Function<String, ? extends T> function) {
            super(clazz, function, null);
        }

        @Override
        boolean shallInject(Field field) {
            return field.getType() == this.clazz;
        }

        @Override
        void inject(Object object, Field field) {
            field.setAccessible(true);
            try {
                field.set(object, this.function.apply(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            field.setAccessible(false);
        }
    }

    private class Injection<T> {
        Class<T> clazz;
        Function<String, ? extends T> function;
        private String condition;

        public Injection(Class<T> clazz, Function<String, ? extends T> function, String string) {
            this.clazz = clazz;
            this.function = function;
            this.condition = string;
        }

        boolean shallInject(Field field) {
            if (field.isAnnotationPresent(Inject.class)) {
                String string = field.getAnnotation(Inject.class).value();
                return field.getType() == this.clazz && (this.condition == null || string.equals(this.condition));
            }
            return false;
        }

        void inject(Object object, Field field) {
            String string = field.getAnnotation(Inject.class).value();
            field.setAccessible(true);
            try {
                field.set(object, this.function.apply(string));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            field.setAccessible(false);
        }
    }
}

