/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import me.mylogo.chestlock.Lock;
import me.mylogo.chestlock.items.ItemBuilder;
import me.mylogo.chestlock.items.NBTItem;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Gui {
    protected static final String ITEM_ID = "gid";
    protected Lock plugin;
    protected Inventory inv;
    private Map<String, BiConsumer<InventoryClickEvent, NBTItem>> clickHandler;

    public Gui(Lock lock) {
        this.plugin = lock;
        this.clickHandler = new HashMap<String, BiConsumer<InventoryClickEvent, NBTItem>>();
        this.initInventory();
    }

    protected void initInventory() {
    }

    public void openFor(Player player) {
        Gui gui = this.plugin.getGuiManager().getGui(player.getUniqueId());
        if (gui != null && gui != this) {
            gui.goToGui(this, player);
        } else {
            this.plugin.getGuiManager().setGui(player.getUniqueId(), this);
            player.openInventory(this.inv);
        }
    }

    public void goToGui(Gui gui, Player player) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> ((Player)player).closeInventory(), 1L);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.plugin.getGuiManager().setGui(player.getUniqueId(), gui);
            gui.openFor(player);
        }, 2L);
    }

    public void onClick(InventoryClickEvent inventoryClickEvent) {
        this.handleRegularClick(inventoryClickEvent);
    }

    protected void addConsumer(String string, BiConsumer<InventoryClickEvent, NBTItem> biConsumer) {
        this.clickHandler.put(string, biConsumer);
    }

    public void insert(int n, String string, ItemStack itemStack) {
        this.inv.setItem(n, this.applyId(itemStack, string).build());
    }

    protected void addConsumer(String string, Runnable runnable) {
        this.addConsumer(string, (InventoryClickEvent inventoryClickEvent, NBTItem nBTItem) -> runnable.run());
    }

    protected NBTItem applyId(ItemBuilder itemBuilder, String string) {
        return this.applyId(itemBuilder.buildCloned(), string);
    }

    protected NBTItem applyId(ItemStack itemStack, String string) {
        return this.applyId(new NBTItem(itemStack), string);
    }

    public void closeInventory(HumanEntity humanEntity) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> ((HumanEntity)humanEntity).closeInventory(), 1L);
    }

    protected NBTItem applyId(NBTItem nBTItem, String string) {
        return (NBTItem)nBTItem.setString(ITEM_ID, string);
    }

    protected void handleRegularClick(InventoryClickEvent inventoryClickEvent) {
        String string;
        BiConsumer<InventoryClickEvent, NBTItem> biConsumer;
        NBTItem nBTItem;
        inventoryClickEvent.setCancelled(true);
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (itemStack != null && itemStack.getType() != Material.AIR && (nBTItem = new NBTItem(itemStack)).hasKey(ITEM_ID) && (biConsumer = this.clickHandler.get(string = nBTItem.getString(ITEM_ID))) != null) {
            biConsumer.accept(inventoryClickEvent, nBTItem);
        }
    }

    public void onClose(InventoryCloseEvent inventoryCloseEvent) {
        this.plugin.getGuiManager().removeGuiFrom(inventoryCloseEvent.getPlayer().getUniqueId());
    }

    public void onDrag(InventoryDragEvent inventoryDragEvent) {
        inventoryDragEvent.setCancelled(true);
    }

    protected void fill(int n, int n2, ItemStack itemStack) {
        for (int i = n; i < n2; ++i) {
            this.inv.setItem(i, itemStack);
        }
    }
}

