/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.guis;

import java.util.ArrayList;
import me.mylogo.chestlock.Lock;
import me.mylogo.chestlock.XMaterial;
import me.mylogo.chestlock.gui.Gui;
import me.mylogo.chestlock.guis.LockFriendsGui;
import me.mylogo.chestlock.guis.SettingsGui;
import me.mylogo.chestlock.guis.YesNoGui;
import me.mylogo.chestlock.items.ItemBuilder;
import me.mylogo.chestlock.lock.BlockPos;
import me.mylogo.chestlock.lock.LockedChest;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class LockGui
extends Gui {
    public static ItemStack BLANK = new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).build();
    private final Player player;
    private final LockedChest lockedChest;

    public LockGui(Lock lock, Player player, LockedChest lockedChest) {
        super(lock);
        this.player = player;
        this.lockedChest = lockedChest;
        this.addConsumer("friends", () -> this.goToGui(new LockFriendsGui(lock, player, lockedChest), player));
        this.addConsumer("unlock", () -> this.goToGui(new YesNoGui(lock, lock.getLockConfig().getReallyUnlockTitle(), yesNoGui -> {
            this.closeInventory((HumanEntity)player);
            new ArrayList<BlockPos>(lockedChest.getPositions()).forEach(blockPos -> lock.getLockManager().unregister(lockedChest, (BlockPos)blockPos));
        }, yesNoGui -> {
            this.closeInventory((HumanEntity)player);
            this.goToGui(this, player);
        }), player));
        this.addConsumer("settings", () -> this.goToGui(new SettingsGui(lock, player, lockedChest), player));
        this.fillItems();
    }

    private void fillItems() {
        this.insert(11, "friends", new ItemBuilder(this.plugin.getUserManager().getInfo(this.player).getSkull()).setName(this.plugin.getLockConfig().getLockGuiFriendsTitle()).build());
        this.insert(15, "unlock", this.plugin.getLockConfig().getUnlockItem());
        this.insert(8, "settings", this.plugin.getLockConfig().getChestSettingsItem());
    }

    @Override
    protected void initInventory() {
        this.inv = Bukkit.createInventory(null, (int)27, (String)this.plugin.getLockConfig().getLockTitle());
        this.fill(0, 9, BLANK);
        this.fill(9, 11, BLANK);
        this.fill(12, 15, BLANK);
        this.fill(16, 27, BLANK);
    }
}

