/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.guis;

import me.mylogo.chestlock.Lock;
import me.mylogo.chestlock.gui.Gui;
import me.mylogo.chestlock.guis.LockGui;
import me.mylogo.chestlock.lock.LockedChest;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class SettingsGui
extends Gui {
    private final Player player;
    private final LockedChest lockedChest;

    public SettingsGui(Lock lock, Player player, LockedChest lockedChest) {
        super(lock);
        this.player = player;
        this.lockedChest = lockedChest;
        this.inv = Bukkit.createInventory(null, (int)27, (String)lock.getLockConfig().getChestSettingsTitle());
        this.fillSettings();
        this.addConsumer("public", () -> {
            this.getContaingerSettings().togglePublicForEveryone();
            this.fillSettings();
        });
        this.addConsumer("extract", () -> {
            this.getContaingerSettings().toggleDoesAllowExtraction();
            this.fillSettings();
        });
        this.addConsumer("insert", () -> {
            this.getContaingerSettings().toggleDoesAllowInsertion();
            this.fillSettings();
        });
        this.addConsumer("back", () -> this.goToGui(new LockGui(lock, player, lockedChest), player));
    }

    private void fillSettings() {
        this.fill(0, 27, LockGui.BLANK);
        if (this.lockedChest.getLockType() == LockedChest.LockType.CONTAINER) {
            LockedChest.ContainerSettings containerSettings = (LockedChest.ContainerSettings)this.lockedChest.getSettings();
            this.insert(12, "public", containerSettings.isPublicForEveryone() ? this.plugin.getLockConfig().getPublicEnabledItem() : this.plugin.getLockConfig().getPublicDisabledItem());
            this.insert(13, "extract", containerSettings.doesAllowExtraction() ? this.plugin.getLockConfig().getItemExtractEnabled() : this.plugin.getLockConfig().getItemExtractDisabled());
            this.insert(14, "insert", containerSettings.doesAllowInsertion() ? this.plugin.getLockConfig().getItemInsertionEnabled() : this.plugin.getLockConfig().getItemInsertionDisabled());
        }
        this.insert(18, "back", this.plugin.getLockConfig().getBackItem());
    }

    private LockedChest.ContainerSettings getContaingerSettings() {
        return (LockedChest.ContainerSettings)this.lockedChest.getSettings();
    }
}

