/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.items;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import me.mylogo.chestlock.items.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ItemManager {
    public static final String XML = "xml";
    public static final String YAML = "yml";
    public static final String JSON = "json";
    private DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private DocumentBuilder documentBuilder;
    private Transformer transformer;
    private Map<String, Material> materials;
    private Map<String, Enchantment> enchantments;
    private List<MyItem> items;
    private JavaPlugin plugin;

    public ItemManager(JavaPlugin javaPlugin) {
        this.plugin = javaPlugin;
        this.items = new ArrayList<MyItem>();
        this.materials = new HashMap<String, Material>();
        for (Material material : Material.values()) {
            this.materials.put(this.convert(material.name()), material);
        }
        this.enchantments = new HashMap<String, Enchantment>();
        for (Material material : Enchantment.values()) {
            this.enchantments.put(this.convert(material.getName()), (Enchantment)material);
        }
        this.enchantments.put("sharpness", Enchantment.DAMAGE_ALL);
        this.enchantments.put("unbreaking", Enchantment.DURABILITY);
        this.enchantments.put("efficiency", Enchantment.DIG_SPEED);
        this.enchantments.put("flame", Enchantment.ARROW_FIRE);
        this.enchantments.put("infinity", Enchantment.ARROW_INFINITE);
        this.enchantments.put("power", Enchantment.ARROW_DAMAGE);
        this.enchantments.put("punch", Enchantment.ARROW_KNOCKBACK);
        this.enchantments.put("protection", Enchantment.PROTECTION_ENVIRONMENTAL);
        this.enchantments.put("fortune", Enchantment.LOOT_BONUS_BLOCKS);
        this.enchantments.put("lure", Enchantment.LOOT_BONUS_MOBS);
        try {
            this.transformer = this.transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        try {
            this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new RuntimeException("Could not instantiate documentBuilder!");
        }
    }

    public ItemStack getItem(String string) {
        MyItem myItem2 = this.items.stream().filter(myItem -> myItem.getId().equals(string)).findFirst().orElse(null);
        if (myItem2 != null) {
            return myItem2.getItem();
        }
        return null;
    }

    public void writeItemsIntoYAML(File file, List<MyItem> list) {
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        list.forEach(myItem -> yamlConfiguration.set(myItem.getId(), (Object)myItem.getId()));
        try {
            yamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void registerItems(File file) {
        try {
            List<MyItem> list = this.readItems(file);
            Iterator<MyItem> iterator = list.iterator();
            while (iterator.hasNext()) {
                MyItem myItem = iterator.next();
                if (!this.containsId(this.items, myItem.getId())) continue;
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "An item with the ID '" + myItem.getId() + "' already exists!");
                iterator.remove();
            }
            this.items.addAll(list);
        }
        catch (ItemParseException itemParseException) {
            System.err.println("Could not properly parse the file:" + file);
            itemParseException.printStackTrace();
        }
    }

    private boolean containsId(List<MyItem> list, String string) {
        return list.stream().map(MyItem::getId).filter(string2 -> string2.equals(string)).findFirst().orElse(null) != null;
    }

    public List<MyItem> readItems(File file) {
        ArrayList<MyItem> arrayList = new ArrayList<MyItem>();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    try {
                        List<MyItem> list = this.readItems(file2);
                        Iterator<MyItem> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            MyItem myItem = iterator.next();
                            if (!this.containsId(arrayList, myItem.getId())) continue;
                            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "An item with the ID '" + myItem.getId() + "' already exists!");
                            iterator.remove();
                        }
                        arrayList.addAll(list);
                    }
                    catch (ItemParseException itemParseException) {
                        Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "Something went wrong while parsing " + file + ":" + itemParseException.getMessage());
                    }
                }
            }
        } else {
            String string = ItemManager.getExtension(file.getName());
            if (XML.equalsIgnoreCase(string)) {
                arrayList.addAll(this.readFromXML(file));
            } else if (YAML.equalsIgnoreCase(string)) {
                arrayList.addAll(this.readFromYAML(file));
            } else if (!JSON.equalsIgnoreCase(string)) {
                throw new ItemParseException("The file " + file.toString() + " could not be read! Its file type is not supported.");
            }
        }
        return arrayList;
    }

    private List<? extends MyItem> readFromYAML(File file) {
        ArrayList<MyItem> arrayList = new ArrayList<MyItem>();
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        if (!yamlConfiguration.isSet("items")) {
            throw new ItemParseException("The file " + file.toString() + " does not contain any items!");
        }
        ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection("items");
        Set set = configurationSection.getKeys(false);
        for (String string : set) {
            Object object = configurationSection.get(string);
            if (object instanceof ItemStack) {
                arrayList.add(new MyItem(string, (ItemStack)object));
                continue;
            }
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "Inside of " + file.toString() + ", '" + string + "' isn't an item!");
        }
        return arrayList;
    }

    public List<MyItem> readFromXML(File file) {
        try {
            return this.readFromXML(this.documentBuilder.parse(file));
        }
        catch (IOException | SAXException exception) {
            exception.printStackTrace();
            throw new ItemParseException("Could not parse the file " + file);
        }
    }

    public List<MyItem> readFromXML(InputStream inputStream) {
        try {
            return this.readFromXML(this.documentBuilder.parse(inputStream));
        }
        catch (IOException | SAXException exception) {
            exception.printStackTrace();
            throw new ItemParseException("Could not parse the input!");
        }
    }

    private List<MyItem> readFromXML(Document document) {
        Element element = document.getDocumentElement();
        if (element == null) {
            throw new ItemParseException("The document does not have a root!");
        }
        NodeList nodeList = element.getElementsByTagName("item");
        ArrayList<MyItem> arrayList = new ArrayList<MyItem>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            try {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) {
                    throw new ItemParseException("The node is not an element!");
                }
                MyItem myItem = this.readMyItemFromXMLElement((Element)node);
                if (!this.containsId(arrayList, myItem.getId())) {
                    arrayList.add(myItem);
                    continue;
                }
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "An item with the ID '" + myItem.getId() + "' already exists!");
                continue;
            }
            catch (ItemParseException itemParseException) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "There's an error in " + document.getNamespaceURI() + " while reading item number " + (i + 1) + ":" + itemParseException.getMessage());
            }
        }
        return arrayList;
    }

    public MyItem readMyItemFromXMLElement(Element element) {
        if (!element.hasAttribute("ID")) {
            throw new ItemParseException("The element did not define an ID attribute! Fix it by having the first element being something like this: <item ID=\"My ID\">");
        }
        String string = element.getAttribute("ID");
        if (string.isEmpty()) {
            throw new ItemParseException("The element's ID is empty!");
        }
        return new MyItem(string, this.readItemFromXMLElement(element));
    }

    public ItemStack readItemFromXMLElement(Element element) {
        Object object;
        Object object2;
        Object object3;
        int n;
        ArrayList<String> arrayList;
        short s;
        Object object4;
        Material material;
        block39: {
            Object object5;
            Element element2 = this.getElement(element, "type", "material", "mat");
            String string = element2.getTextContent();
            this.ensureContent(string, "There was no value entered for the material!");
            material = this.getMaterial(string);
            if (material == null) {
                throw new ItemParseException("There was no material found with the name:" + string);
            }
            try {
                Element element3 = this.getElement(element, "data");
                object4 = element3.getTextContent();
                try {
                    s = this.ensureShort((String)object4, "");
                }
                catch (ItemParseException itemParseException) {
                    throw new ItemParseException("Your entered data '" + (String)object4 + "' was not a number!");
                }
            }
            catch (ItemParseException itemParseException) {
                s = 0;
            }
            try {
                object4 = this.getElement(element, "amount", "times", "count");
                arrayList = object4.getTextContent();
                try {
                    n = this.ensureInteger((String)((Object)arrayList), "");
                }
                catch (ItemParseException itemParseException) {
                    throw new ItemParseException("Your entered amount '" + arrayList + "' was not a number!");
                }
            }
            catch (ItemParseException itemParseException) {
                n = 1;
            }
            try {
                arrayList = this.getElement(element, "name", "title");
                object4 = arrayList.getTextContent();
            }
            catch (ItemParseException itemParseException) {
                object4 = null;
            }
            try {
                object3 = this.getElement(element, "lore");
                object5 = object3.getElementsByTagName("line");
                if (object5.getLength() > 0) {
                    arrayList = new ArrayList<String>();
                    for (int i = 0; i < object5.getLength(); ++i) {
                        arrayList.add(object5.item(i).getTextContent());
                    }
                } else {
                    arrayList = null;
                }
            }
            catch (ItemParseException itemParseException) {
                arrayList = null;
            }
            try {
                object5 = this.getElement(element, "enchantments", "enchants");
                object2 = object5.getChildNodes();
                if (object2.getLength() > 0) {
                    object3 = new HashMap();
                    object = object5.getFirstChild();
                    while (object.getNextSibling() != null) {
                        Element element4;
                        String string2 = object.getNodeName();
                        if ("enchantment".equalsIgnoreCase(string2)) {
                            if (object.getNodeType() == 1) {
                                element4 = (Element)object;
                                String string3 = element4.getTextContent();
                                Enchantment enchantment = this.enchantments.get(this.convert(string3));
                                if (enchantment != null) {
                                    if (element4.hasAttribute("level")) {
                                        int n2;
                                        try {
                                            n2 = this.ensureInteger(element4.getAttribute("level"), "");
                                        }
                                        catch (ItemParseException itemParseException) {
                                            n2 = 1;
                                        }
                                        object3.put(enchantment, n2);
                                    } else {
                                        Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "The enchantment '" + string3 + "' does not have a level defined!");
                                    }
                                } else {
                                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "Having the enchantment name '" + string3 + "' which does not exist!");
                                }
                            }
                        } else {
                            element4 = this.enchantments.get(this.convert(string2));
                            if (element4 != null) {
                                int n3;
                                try {
                                    n3 = this.ensureInteger(object.getTextContent(), "");
                                }
                                catch (ItemParseException itemParseException) {
                                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "Having the enchantment level '" + object.getTextContent() + " which isn't an actual number! Will set it to 1 :)");
                                    n3 = 1;
                                }
                                object3.put(element4, n3);
                            } else if (object.getNodeType() == 1) {
                                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "Having the enchantment name '" + string2 + "', but this doesn't exist!");
                            }
                        }
                        object = object.getNextSibling();
                    }
                    break block39;
                }
                object3 = null;
            }
            catch (ItemParseException itemParseException) {
                object3 = null;
            }
        }
        object2 = new ItemBuilder(material, n, s);
        if (object4 != null) {
            ((ItemBuilder)object2).setName((String)object4);
        }
        if (arrayList != null) {
            ((ItemBuilder)object2).setLore(arrayList);
        }
        object = ((ItemBuilder)object2).build();
        if (object3 != null) {
            object.addUnsafeEnchantments((Map)object3);
        }
        return object;
    }

    private short ensureShort(String string, String string2) {
        try {
            return Short.parseShort(string);
        }
        catch (Exception exception) {
            throw new ItemParseException(string2);
        }
    }

    private double ensureDouble(String string, String string2) {
        try {
            return Double.parseDouble(string.replace(',', '.'));
        }
        catch (Exception exception) {
            throw new ItemParseException(string2);
        }
    }

    private int ensureInteger(String string, String string2) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new ItemParseException(string2);
        }
    }

    private void ensureContent(String string, String string2) {
        if (string == null || string.isEmpty()) {
            throw new ItemParseException(string2);
        }
    }

    private Element getElement(Element element, String ... stringArray) {
        assert (stringArray.length > 0);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            NodeList nodeList = element.getElementsByTagName(string);
            if (nodeList.getLength() <= 0) continue;
            Node node = nodeList.item(0);
            if (node.getNodeType() != 1) {
                throw new ItemParseException(string + " is not an element!");
            }
            return (Element)node;
        }
        throw new ItemParseException("The element did not define a tag of the name " + stringArray[0]);
    }

    public Material getMaterial(String string) {
        Material material = this.materials.get(this.convert(string));
        if (material != null) {
            return material;
        }
        try {
            return Material.getMaterial((String)string.toUpperCase());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void registerItem(String string, ItemStack itemStack) {
        itemStack = itemStack.clone();
        itemStack.setAmount(1);
        this.items.add(new MyItem(string, itemStack));
    }

    private String convert(String string) {
        return string.replace("_", "").toLowerCase();
    }

    public static String niceName(String string) {
        char[] cArray;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (char c : cArray = string.toCharArray()) {
            if (c == '_') {
                bl = true;
                continue;
            }
            if (bl) {
                c = Character.toUpperCase(c);
                bl = false;
            } else {
                c = Character.toLowerCase(c);
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String getExtension(String string) {
        int n = -1;
        char[] cArray = string.toCharArray();
        for (int i = string.length() - 1; i > -1; --i) {
            if (cArray[i] != '.') continue;
            n = i;
            break;
        }
        if (n > 0) {
            return string.substring(n + 1, string.length());
        }
        return "";
    }

    public class MyItem {
        private String id;
        private ItemStack item;

        public MyItem(String string, ItemStack itemStack) {
            this.id = string;
            this.item = itemStack.clone();
        }

        private void setAmount(int n) {
            this.item.setAmount(n);
        }

        public String getId() {
            return this.id;
        }

        public ItemStack getItem() {
            return this.item.clone();
        }

        public String toString() {
            return "MyItem{ID='" + this.id + '\'' + ", item=" + this.item + '}';
        }
    }

    public static class ItemParseException
    extends Exception {
        public ItemParseException(String string) {
            super(string);
        }
    }
}

