/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.items;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Ref {
    public static final String VERSION = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
    public static final Class<?> CraftPlayer = Ref.getOBC("entity.CraftPlayer");
    public static final Class<?> IChatBaseComponent = Ref.getNMS("IChatBaseComponent");
    public static final Class<?> ChatSerializer = Ref.getNMS("IChatBaseComponent$ChatSerializer");
    public static final Class<?> PacketPlayOutChat = Ref.getNMS("PacketPlayOutChat");
    public static final Class<?> EntityPlayer = Ref.getNMS("EntityPlayer");
    public static final Class<?> PlayerConnection = Ref.getNMS("PlayerConnection");
    public static final Class<?> Packet = Ref.getNMS("Packet");
    public static final Method CRAFT_PLAYER_GET_HANDLE = Ref.getMethod(CraftPlayer, "getHandle", new Class[0]);
    public static final Method CHAT_SERIALIZER_A = Ref.getMethod(ChatSerializer, "a", String.class);
    public static final Method PLAYER_CONNECTION_SEND_PACKET = Ref.getMethod(PlayerConnection, "sendPacket", Packet);
    public static final Field ENTITY_PLAYER_PLAYER_CONNECTION = Ref.getField(EntityPlayer, "playerConnection");
    private static BiConsumer<Player, String> actionBarSender = null;

    private static void init12ActionBar() {
        Class<?> clazz = Ref.getNMS("ChatMessageType");
        ?[] objArray = clazz.getEnumConstants();
        Object var2_2 = null;
        for (Object obj : objArray) {
            if (!obj.toString().equals("GAME_INFO")) continue;
            var2_2 = obj;
            break;
        }
        Constructor<?> constructor = Ref.getConstructor(PacketPlayOutChat, IChatBaseComponent, clazz);
        Object var4_6 = var2_2;
        actionBarSender = (player, string) -> {
            try {
                Object object2 = CRAFT_PLAYER_GET_HANDLE.invoke(player, new Object[0]);
                Object object3 = ENTITY_PLAYER_PLAYER_CONNECTION.get(object2);
                Object object4 = CHAT_SERIALIZER_A.invoke(null, "{\"text\": \"" + string + "\"}");
                Object t = object.newInstance(object4, var4_5);
                PLAYER_CONNECTION_SEND_PACKET.invoke(object3, t);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        };
    }

    private static void initPre12ActionBar() {
        Constructor<?> constructor = Ref.getConstructor(PacketPlayOutChat, IChatBaseComponent, Byte.TYPE);
        actionBarSender = (player, string) -> {
            try {
                Object object = CRAFT_PLAYER_GET_HANDLE.invoke(player, new Object[0]);
                Object object2 = ENTITY_PLAYER_PLAYER_CONNECTION.get(object);
                Object object3 = CHAT_SERIALIZER_A.invoke(null, "{\"text\": \"" + string + "\"}");
                Object t = constructor.newInstance(object3, (byte)2);
                PLAYER_CONNECTION_SEND_PACKET.invoke(object2, t);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        };
    }

    public static void sendActionBar(Player player, String string) {
        actionBarSender.accept(player, string);
    }

    public static Class<?> getNMS(String string) {
        try {
            Class<?> clazz = Class.forName("net.minecraft.server." + VERSION + "." + string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    public static Class<?> getOBC(String string) {
        try {
            Class<?> clazz = Class.forName("org.bukkit.craftbukkit." + VERSION + "." + string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    public static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        while (clazz != null) {
            Method[] methodArray;
            for (Method method : methodArray = clazz.getDeclaredMethods()) {
                if (!method.getName().equals(string) || !Ref.compare(method.getParameterTypes(), classArray)) continue;
                method.setAccessible(true);
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... classArray) {
        while (clazz != null) {
            Constructor<?>[] constructorArray;
            for (Constructor<?> constructor : constructorArray = clazz.getDeclaredConstructors()) {
                if (!Ref.compare(constructor.getParameterTypes(), classArray)) continue;
                return constructor;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Method getMethod(Object object, String string, Class<?> ... classArray) {
        return Ref.getMethod(object.getClass(), string, classArray);
    }

    public static Field getField(Class<?> clazz, String string) {
        while (clazz != null) {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                if (!field.getName().equals(string)) continue;
                field.setAccessible(true);
                return field;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static boolean compare(Class<?>[] classArray, Class<?>[] classArray2) {
        if (classArray == null || classArray2 == null) {
            return false;
        }
        if (classArray.length != classArray2.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] == classArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static Class<?>[] params(Class<?> ... classArray) {
        return classArray;
    }

    static /* synthetic */ Class[] access$000(Class[] classArray) {
        return Ref.params(classArray);
    }

    static {
        if (VERSION.contains("12")) {
            Ref.init12ActionBar();
        } else {
            Ref.initPre12ActionBar();
        }
    }

    public static class Block {
        private static final Class<?> CLASS_CRAFT_CHEST = Ref.getOBC("block.CraftChest");
        private static final Class<?> CLASS_TILE_ENTITY_CHEST = Ref.getNMS("TileEntityChest");
        private static final Method CRAFT_CHEST_GET_TILE_ENTITY = Ref.getMethod(CLASS_CRAFT_CHEST, "getTileEntity", new Class[0]);
        private static final Method TILE_ENTITY_CHEST_SET_NAME = Ref.getMethod(CLASS_TILE_ENTITY_CHEST, "a", Ref.access$000(new Class[]{String.class})) != null ? Ref.getMethod(CLASS_TILE_ENTITY_CHEST, "a", Ref.access$000(new Class[]{String.class})) : Ref.getMethod(CLASS_TILE_ENTITY_CHEST, "setCustomName", Ref.access$000(new Class[]{String.class}));

        public static void setChestName(Location location, String string) {
            Block.setChestName(location.getBlock(), string);
        }

        public static void setChestName(org.bukkit.block.Block block, String string) {
            if (block.getType() == Material.CHEST) {
                BlockState blockState = block.getState();
                try {
                    Object object = CRAFT_CHEST_GET_TILE_ENTITY.invoke((Object)blockState, new Object[0]);
                    TILE_ENTITY_CHEST_SET_NAME.invoke(object, string);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static class NBT {
        public static final Class<?> CLASS_NBT_TAG_BASE = Ref.getNMS("NBTBase");
        public static final Class<?> CLASS_NBT_TAG_COMPOUND = Ref.getNMS("NBTTagCompound");
        public static final Class<?> CLASS_NBT_LIST = Ref.getNMS("NBTTagList");
        public static final Class<?> CLASS_INTEGER_ARRAY = new int[0].getClass();
        public static final Class<?> CLASS_BYTE_ARRAY = new int[0].getClass();
        public static final Class<?> CLASS_CRAFT_ITEM_STACK = Ref.getOBC("inventory.CraftItemStack");
        public static final Class<?> CLASS_NMS_ITEM_STACK = Ref.getNMS("ItemStack");
        private static final Method AS_NMY_COPY_METHOD = Ref.getMethod(CLASS_CRAFT_ITEM_STACK, "asNMSCopy", ItemStack.class);
        private static final Method AS_BUKKIT_COPY_METHOD = Ref.getMethod(CLASS_CRAFT_ITEM_STACK, "asBukkitCopy", CLASS_NMS_ITEM_STACK);
        private static final Method GET_TAG_METHOD = Ref.getMethod(CLASS_NMS_ITEM_STACK, "getTag", new Class[0]);
        Constructor<?> NBT_TAG_COMPOUND_CONSTRUCTOR = Ref.getConstructor(CLASS_NBT_TAG_COMPOUND, new Class[0]);
        private static final Method SET_TAG_METHOD = Ref.getMethod(CLASS_NMS_ITEM_STACK, "setTag", CLASS_NBT_TAG_COMPOUND);
        private static final Method HAS_KEY_METHOD = Ref.getMethod(CLASS_NBT_TAG_COMPOUND, "hasKey", String.class);
        private static final Method SET_STRING_METHOD = Ref.getMethod(CLASS_NBT_TAG_COMPOUND, "setString", Ref.access$000(new Class[]{String.class, String.class}));
        private static final Method SET_INT_METHOD = Ref.getMethod(CLASS_NBT_TAG_COMPOUND, "setInt", String.class, Integer.TYPE);
        private static final Method SET_BOOLEAN_METHOD = Ref.getMethod(CLASS_NBT_TAG_COMPOUND, "setBoolean", String.class, Boolean.TYPE);
        private static final Method SET_DOUBLE_METHOD = Ref.getMethod(CLASS_NBT_TAG_COMPOUND, "setDouble", String.class, Double.TYPE);
        private static final Method SET_LONG_METHOD = Ref.getMethod(CLASS_NBT_TAG_COMPOUND, "setLong", String.class, Long.TYPE);
        private static final Method GET_DOUBLE_METHOD = Ref.getMethod(CLASS_NBT_TAG_COMPOUND, "getDouble", String.class);
        private static final Method GET_INT_METHOD = Ref.getMethod(CLASS_NBT_TAG_COMPOUND, "getInt", String.class);
        private static final Method GET_LONG_METHOD = Ref.getMethod(CLASS_NBT_TAG_COMPOUND, "getLong", String.class);
        private static final Method GET_STRING_METHOD = Ref.getMethod(CLASS_NBT_TAG_COMPOUND, "getString", String.class);
        private static final Method GET_COMPOUND_METHOD = Ref.getMethod(CLASS_NBT_TAG_COMPOUND, "getCompound", String.class);

        public static Object toNMSItem(ItemStack itemStack) {
            if (itemStack == null) {
                return null;
            }
            try {
                return AS_NMY_COPY_METHOD.invoke(null, itemStack);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public static ItemStack toBukkitItem(Object object) {
            if (object == null) {
                return null;
            }
            try {
                return (ItemStack)AS_BUKKIT_COPY_METHOD.invoke(null, object);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public static Object getNBTTag(Object object) {
            try {
                Object object2 = GET_TAG_METHOD.invoke(object, new Object[0]);
                if (object2 == null) {
                    object2 = NBT.createNBTTag();
                }
                return object2;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public static Object createNBTTag() {
            try {
                return CLASS_NBT_TAG_COMPOUND.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
                return null;
            }
        }

        public static void applyNBT(Object object, Object object2) {
            try {
                SET_TAG_METHOD.invoke(object, object2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }

        public static boolean hasKey(Object object, String string) {
            try {
                return (Boolean)HAS_KEY_METHOD.invoke(object, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }

        public static void setString(Object object, String string, String string2) {
            try {
                SET_STRING_METHOD.invoke(object, string, string2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }

        public static void setInt(Object object, String string, int n) {
            try {
                SET_INT_METHOD.invoke(object, string, n);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }

        public static void setBoolean(Object object, String string, boolean bl) {
            try {
                SET_BOOLEAN_METHOD.invoke(object, string, bl);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }

        public static void setDouble(Object object, String string, double d) {
            try {
                SET_DOUBLE_METHOD.invoke(object, string, d);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }

        public static void setLong(Object object, String string, long l) {
            try {
                SET_LONG_METHOD.invoke(object, string, l);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }

        public static double getDouble(Object object, String string) {
            try {
                return (Double)GET_DOUBLE_METHOD.invoke(object, string);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
                throw new RuntimeException("Could not invoke getDouble");
            }
        }

        public static int getInt(Object object, String string) {
            try {
                return (Integer)GET_INT_METHOD.invoke(object, string);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
                throw new RuntimeException("Could not invoke getInt");
            }
        }

        public static long getLong(Object object, String string) {
            try {
                return (Long)GET_LONG_METHOD.invoke(object, string);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
                throw new RuntimeException("Could not invoke getLong");
            }
        }

        public static String getString(Object object, String string) {
            try {
                return (String)GET_STRING_METHOD.invoke(object, string);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
                throw new RuntimeException("Could not invoke getString");
            }
        }

        public static Object getCompound(Object object, String string) {
            try {
                return GET_COMPOUND_METHOD.invoke(object, string);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
                throw new RuntimeException("Could not invoke getCompound");
            }
        }
    }
}

