/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.listeners;

import java.util.Iterator;
import java.util.List;
import me.mylogo.chestlock.Lock;
import me.mylogo.chestlock.lock.BlockPos;
import me.mylogo.chestlock.lock.LockedChest;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class OtherListener
implements Listener {
    private Lock plugin;

    public OtherListener(Lock lock) {
        this.plugin = lock;
    }

    @EventHandler
    public void onHopper(InventoryMoveItemEvent inventoryMoveItemEvent) {
        Object object;
        Object object2;
        Inventory inventory;
        Inventory inventory2 = inventoryMoveItemEvent.getSource();
        InventoryHolder inventoryHolder = inventory2.getHolder();
        if (inventoryHolder instanceof BlockState || inventoryHolder instanceof DoubleChest) {
            if (inventoryHolder instanceof DoubleChest) {
                inventoryHolder = ((DoubleChest)inventoryHolder).getLeftSide();
            }
            inventory = (BlockState)inventoryHolder;
            object2 = this.plugin.getLockManager().getLockedChest(inventory.getBlock());
            if (object2 != null) {
                object = ((LockedChest)object2).getSettings();
                if (!(object instanceof LockedChest.ContainerSettings)) {
                    return;
                }
                if (!((LockedChest.ContainerSettings)object).doesAllowExtraction()) {
                    inventoryMoveItemEvent.setCancelled(true);
                    return;
                }
            }
        }
        if ((object2 = (inventory = inventoryMoveItemEvent.getDestination()).getHolder()) instanceof BlockState) {
            object = (BlockState)object2;
            LockedChest lockedChest = this.plugin.getLockManager().getLockedChest(object.getBlock());
            if (lockedChest != null) {
                LockedChest.Settings settings = lockedChest.getSettings();
                if (!(settings instanceof LockedChest.ContainerSettings)) {
                    return;
                }
                if (!((LockedChest.ContainerSettings)settings).doesAllowInsertion()) {
                    inventoryMoveItemEvent.setCancelled(true);
                    return;
                }
            }
        }
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent blockExplodeEvent) {
        this.handleBlockExplosions(blockExplodeEvent.blockList());
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent entityExplodeEvent) {
        this.handleBlockExplosions(entityExplodeEvent.blockList());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockExplodeMonitor(BlockExplodeEvent blockExplodeEvent) {
        this.handleBlockExplosionMonitor(blockExplodeEvent.blockList());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityExplodeMonitor(EntityExplodeEvent entityExplodeEvent) {
        this.handleBlockExplosionMonitor(entityExplodeEvent.blockList());
    }

    private void handleBlockExplosions(List<Block> list) {
        if (this.plugin.getLockConfig().willLocksBreakOnExplosion()) {
            return;
        }
        Iterator<Block> iterator = list.iterator();
        while (iterator.hasNext()) {
            Block block = iterator.next();
            if (!this.plugin.getLockConfig().isLockable(block.getType()) || this.plugin.getLockManager().getLockedChest(block) == null) continue;
            iterator.remove();
        }
    }

    private void handleBlockExplosionMonitor(List<Block> list) {
        for (Block block : list) {
            LockedChest lockedChest = this.plugin.getLockManager().getLockedChest(block);
            if (lockedChest == null) continue;
            this.plugin.getLockManager().unregister(lockedChest, new BlockPos(block));
        }
    }
}

