/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.lock;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.mylogo.chestlock.JsonSerialization;
import me.mylogo.chestlock.Lock;
import me.mylogo.chestlock.Module;
import me.mylogo.chestlock.lock.BlockPos;
import me.mylogo.chestlock.lock.LockChunk;
import me.mylogo.chestlock.lock.LockedChest;
import me.mylogo.chestlock.user.LockUserInfo;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class LockManager
extends Module {
    private Map<String, Map<Integer, Map<Integer, LockChunk>>> locked;
    private JsonSerialization<Object> jsonSerialization = new JsonSerialization<Object>(object -> new JsonObject(), jsonObject -> new Object(), this::getFile, this::save, this::load);

    public LockManager(Lock lock) {
        super(lock);
        this.locked = new HashMap<String, Map<Integer, Map<Integer, LockChunk>>>();
        this.jsonSerialization.read();
    }

    @Override
    public void onDisable() {
        this.jsonSerialization.save(Collections.emptyList());
    }

    private void load(JsonObject jsonObject) {
        JsonArray jsonArray = jsonObject.get("ALL").getAsJsonArray();
        for (JsonElement jsonElement : jsonArray) {
            JsonObject jsonObject2 = jsonElement.getAsJsonObject();
            String string = jsonObject2.get("world").getAsString();
            JsonArray jsonArray2 = jsonObject2.get("locked").getAsJsonArray();
            for (JsonElement jsonElement2 : jsonArray2) {
                this.register(string, new LockedChest(this.plugin, string, jsonElement2.getAsJsonObject()));
            }
        }
    }

    private void save(JsonObject jsonObject) {
        JsonArray jsonArray = new JsonArray();
        for (Map.Entry<String, Map<Integer, Map<Integer, LockChunk>>> entry : this.locked.entrySet()) {
            String string = entry.getKey();
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty("world", string);
            Map<Integer, Map<Integer, LockChunk>> map = entry.getValue();
            JsonArray jsonArray2 = new JsonArray();
            HashSet hashSet = new HashSet();
            map.values().stream().map(Map::values).flatMap(Collection::stream).map(LockChunk::getChests).forEach(hashSet::addAll);
            hashSet.stream().map(LockedChest::save).forEach(arg_0 -> ((JsonArray)jsonArray2).add(arg_0));
            jsonObject2.add("locked", (JsonElement)jsonArray2);
            jsonArray.add((JsonElement)jsonObject2);
        }
        jsonObject.add("ALL", (JsonElement)jsonArray);
    }

    private File getFile(boolean bl) {
        return this.getDataFolderFile("locked_chests." + (bl ? "tmp" : "json"));
    }

    public void register(String string2, LockedChest lockedChest) {
        if (lockedChest.getLockType() == null) {
            this.printError("No LockType defined for chest - not registering.");
            return;
        }
        Map map = this.locked.computeIfAbsent(string2, string -> new HashMap());
        for (BlockPos blockPos : lockedChest.getPositions()) {
            LockChunk lockChunk = map.computeIfAbsent(blockPos.getX() >> 4, n -> new HashMap()).computeIfAbsent(blockPos.getZ() >> 4, n -> new LockChunk(blockPos.getX() >> 4, (int)n));
            lockChunk.register(blockPos, lockedChest);
        }
    }

    public LockedChest getLockedChest(String string, int n, int n2, int n3) {
        return this.getLockedChest(string, new BlockPos(n, n2, n3));
    }

    public LockedChest getLockedChest(String string, BlockPos blockPos) {
        LockChunk lockChunk;
        Map<Integer, LockChunk> map;
        Map<Integer, Map<Integer, LockChunk>> map2 = this.locked.get(string);
        if (map2 != null && (map = map2.get(blockPos.getX() >> 4)) != null && (lockChunk = map.get(blockPos.getZ() >> 4)) != null) {
            return lockChunk.getChestAt(blockPos);
        }
        return null;
    }

    public LockedChest getLockedChest(Block block) {
        String string = block.getWorld().getName();
        return this.getLockedChest(string, new BlockPos(block.getX(), block.getY(), block.getZ()));
    }

    public void requestLock(Player player, Block block) {
        LockUserInfo lockUserInfo = this.plugin.getUserManager().getInfo(player);
        int n = this.plugin.getLockConfig().getMaxClaims(player);
        if (lockUserInfo.getLockedChests().size() >= n) {
            player.sendMessage(this.plugin.getLockConfig().getYouCannotClaimMore().replace("%max%", String.valueOf(this.plugin.getLockConfig().getMaxClaims(player))));
            return;
        }
        LockedChest lockedChest = this.getLockedChest(block);
        if (lockedChest == null) {
            Material material = block.getType();
            LockedChest lockedChest2 = new LockedChest(this.plugin, block.getWorld().getName(), lockUserInfo);
            BlockState blockState = block.getState();
            if (material == Material.CHEST || material == Material.TRAPPED_CHEST) {
                if (blockState instanceof Chest) {
                    Chest chest = (Chest)blockState;
                    Inventory inventory = chest.getInventory();
                    if (inventory instanceof DoubleChestInventory) {
                        DoubleChest doubleChest = ((DoubleChestInventory)inventory).getHolder();
                        lockedChest2.addPosition(new BlockPos(((Chest)doubleChest.getLeftSide()).getBlock()), new BlockPos(((Chest)doubleChest.getRightSide()).getBlock()));
                    } else {
                        lockedChest2.addPosition(new BlockPos(block));
                    }
                }
                lockedChest2.setLockType(LockedChest.LockType.CONTAINER);
            } else if (blockState instanceof InventoryHolder) {
                lockedChest2.addPosition(new BlockPos(block));
                lockedChest2.setLockType(LockedChest.LockType.CONTAINER);
            }
            if (!lockedChest2.getPositions().isEmpty()) {
                this.register(block.getWorld().getName(), lockedChest2);
                player.sendMessage(this.plugin.getLockConfig().getYouLockedContainer());
            } else {
                player.sendMessage("\u00a7cIt failed.");
                player.sendMessage(this.plugin.getLockConfig().getContainerNotLockable());
            }
        }
    }

    public void unregister(LockedChest lockedChest, BlockPos blockPos) {
        LockChunk lockChunk;
        Map<Integer, LockChunk> map;
        lockedChest.removePosition(blockPos);
        Map<Integer, Map<Integer, LockChunk>> map2 = this.locked.get(lockedChest.getWorld());
        if (map2 != null && (map = map2.get(blockPos.getX() >> 4)) != null && (lockChunk = map.get(blockPos.getZ() >> 4)) != null) {
            lockChunk.unregister(blockPos);
            if (lockedChest.getPositions().isEmpty()) {
                lockedChest.getOwner().removeLockedChest(lockedChest);
            }
        }
    }
}

