/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.lock;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.mylogo.chestlock.Lock;
import me.mylogo.chestlock.api.ILockedBlock;
import me.mylogo.chestlock.lock.BlockPos;
import me.mylogo.chestlock.user.LockUserInfo;

public class LockedChest
implements ILockedBlock {
    private Lock plugin;
    private String world;
    private LockUserInfo owner;
    private Set<BlockPos> positions;
    private List<LockUserInfo> trusted;
    private LockType lockType;
    private Settings settings;

    public LockedChest(Lock lock, String string, LockUserInfo lockUserInfo) {
        this.plugin = lock;
        this.owner = lockUserInfo;
        this.owner.addLockedChest(this);
        this.world = string;
        this.positions = new HashSet<BlockPos>();
        this.trusted = new ArrayList<LockUserInfo>(6);
    }

    public LockedChest(Lock lock, String string, JsonObject jsonObject) {
        JsonArray jsonArray;
        this.plugin = lock;
        this.owner = lock.getUserManager().getInfo(UUID.fromString(jsonObject.get("o").getAsString()));
        this.owner.addLockedChest(this);
        this.positions = new HashSet<BlockPos>();
        this.world = string;
        if (jsonObject.has("p")) {
            jsonArray = jsonObject.get("p").getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                this.positions.add(new BlockPos(jsonElement.getAsJsonObject()));
            }
        }
        this.trusted = new ArrayList<LockUserInfo>(6);
        if (jsonObject.has("t")) {
            jsonArray = jsonObject.get("t").getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                this.trusted.add(lock.getUserManager().getInfo(UUID.fromString(jsonElement.getAsString())));
            }
        }
        this.lockType = LockType.CONTAINER;
        if (jsonObject.has("s")) {
            this.settings = this.initSettingsFromJson(LockType.CONTAINER, jsonObject.get("s").getAsJsonObject());
        } else {
            this.setLockType(this.lockType);
        }
    }

    public JsonObject save() {
        JsonArray jsonArray;
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("o", this.owner.getUniqueId().toString());
        if (this.positions.size() > 0) {
            jsonArray = new JsonArray();
            this.positions.stream().map(BlockPos::save).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
            jsonObject.add("p", (JsonElement)jsonArray);
        }
        if (!this.trusted.isEmpty()) {
            jsonArray = new JsonArray();
            this.trusted.stream().map(LockUserInfo::getUniqueId).map(UUID::toString).map(JsonPrimitive::new).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
            jsonObject.add("t", (JsonElement)jsonArray);
        }
        if (this.settings != null && !this.settings.isDefault()) {
            jsonObject.add("s", (JsonElement)this.settings.save());
        }
        return jsonObject;
    }

    public boolean canUse(LockUserInfo lockUserInfo) {
        return this.settings.isPublicForEveryone() || lockUserInfo == this.owner || this.isTrusted(lockUserInfo);
    }

    @Override
    public boolean canUse(UUID uUID) {
        return this.settings.isPublicForEveryone() || this.owner.getUniqueId().equals(uUID) || this.isTrusted(uUID);
    }

    public boolean isTrusted(LockUserInfo lockUserInfo) {
        return this.trusted.contains(lockUserInfo);
    }

    @Override
    public boolean isTrusted(UUID uUID) {
        return this.trusted.stream().anyMatch(lockUserInfo -> lockUserInfo.getUniqueId().equals(uUID));
    }

    public Set<BlockPos> getPositions() {
        return this.positions;
    }

    public void addPosition(BlockPos blockPos) {
        this.positions.add(blockPos);
    }

    public void addPosition(BlockPos ... blockPosArray) {
        this.positions.addAll(Arrays.asList(blockPosArray));
    }

    @Override
    public boolean isOwner(UUID uUID) {
        return this.owner.getUniqueId().equals(uUID);
    }

    void removePosition(BlockPos blockPos) {
        this.positions.remove(blockPos);
    }

    public List<LockUserInfo> getTrusted() {
        return this.trusted;
    }

    public void addTrusted(LockUserInfo lockUserInfo) {
        this.trusted.add(lockUserInfo);
    }

    public String getWorld() {
        return this.world;
    }

    void setWorld(String string) {
        this.world = string;
    }

    public void setTrusted(List<LockUserInfo> list) {
        this.trusted = list;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setLockType(LockType lockType) {
        this.lockType = lockType;
        if (lockType == LockType.CONTAINER) {
            this.settings = new ContainerSettings();
        }
    }

    public LockType getLockType() {
        return this.lockType;
    }

    @Override
    public LockUserInfo getOwner() {
        return this.owner;
    }

    private Settings initSettingsFromJson(LockType lockType, JsonObject jsonObject) {
        if (lockType == LockType.CONTAINER) {
            return new ContainerSettings(jsonObject);
        }
        return new Settings(jsonObject);
    }

    public class ContainerSettings
    extends Settings {
        private boolean allowInsertion;
        private boolean allowExtract;

        public ContainerSettings() {
            this.allowInsertion = false;
            this.allowExtract = false;
        }

        public ContainerSettings(JsonObject jsonObject) {
            super(jsonObject);
            this.allowInsertion = jsonObject.has("i");
            this.allowExtract = jsonObject.has("e");
        }

        public void toggleDoesAllowInsertion() {
            this.allowInsertion = !this.allowInsertion;
        }

        public void toggleDoesAllowExtraction() {
            this.allowExtract = !this.allowExtract;
        }

        public boolean doesAllowInsertion() {
            return this.allowInsertion;
        }

        public boolean doesAllowExtraction() {
            return this.allowExtract;
        }

        @Override
        public boolean isDefault() {
            return super.isDefault() && !this.doesAllowExtraction() && !this.doesAllowInsertion();
        }

        @Override
        public JsonObject save() {
            JsonObject jsonObject = super.save();
            if (this.doesAllowInsertion()) {
                jsonObject.addProperty("i", (Number)1);
            }
            if (this.doesAllowExtraction()) {
                jsonObject.addProperty("e", (Number)1);
            }
            return jsonObject;
        }
    }

    public class Settings {
        private boolean publicForEveryone;

        public Settings() {
            this.publicForEveryone = false;
        }

        public Settings(JsonObject jsonObject) {
            this.publicForEveryone = jsonObject.has("p");
        }

        public boolean isPublicForEveryone() {
            return this.publicForEveryone;
        }

        public void togglePublicForEveryone() {
            this.publicForEveryone = !this.publicForEveryone;
        }

        public boolean isDefault() {
            return !this.publicForEveryone;
        }

        public JsonObject save() {
            JsonObject jsonObject = new JsonObject();
            if (this.publicForEveryone) {
                jsonObject.addProperty("p", (Number)1);
            }
            return jsonObject;
        }
    }

    public static enum LockType {
        CONTAINER;


        public static LockType getTypeFrom(int n) {
            return CONTAINER;
        }
    }
}

