/*
 * Decompiled with CFR 0.152.
 */
package me.mylogo.chestlock.user;

import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.mylogo.chestlock.XMaterial;
import me.mylogo.chestlock.api.ILockUserInfo;
import me.mylogo.chestlock.items.NBTItem;
import me.mylogo.chestlock.lock.LockedChest;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class LockUserInfo
implements ILockUserInfo {
    private UUID uuid;
    private String name;
    private String display;
    private ItemStack skull;
    private List<LockUserInfo> copiedList;
    private Set<LockedChest> lockedChests = new HashSet<LockedChest>();
    private boolean bypassing;

    public LockUserInfo(UUID uUID) {
        this.uuid = uUID;
    }

    public LockUserInfo(JsonObject jsonObject) {
        this.uuid = UUID.fromString(jsonObject.get("u").getAsString());
        this.name = jsonObject.has("n") ? jsonObject.get("n").getAsString() : "NoneYet";
        if (jsonObject.has("d")) {
            this.display = jsonObject.get("d").getAsString();
        }
    }

    private void initSkull() {
        this.skull = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta skullMeta = (SkullMeta)this.skull.getItemMeta();
        skullMeta.setOwner(this.name);
        skullMeta.setDisplayName("\u00a7a\u00a7l" + this.getDisplayName());
        this.skull.setItemMeta((ItemMeta)skullMeta);
        this.skull = ((NBTItem)new NBTItem(this.skull).setString("_uuid", this.getUniqueId().toString())).build();
    }

    public JsonObject save() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("u", this.uuid.toString());
        jsonObject.addProperty("n", this.name);
        jsonObject.addProperty("d", this.display);
        return jsonObject;
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ItemStack getSkull() {
        if (this.skull == null) {
            this.initSkull();
        }
        return this.skull.clone();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDisplayName() {
        if (this.display != null) {
            return this.display;
        }
        Player player = Bukkit.getPlayer((UUID)this.getUniqueId());
        if (player != null) {
            this.display = player.getDisplayName();
            return this.display;
        }
        return this.name;
    }

    public void setDisplayName(String string) {
        this.display = string;
    }

    public List<LockUserInfo> getCopiedList() {
        return this.copiedList;
    }

    public void setCopiedList(List<LockUserInfo> list) {
        this.copiedList = list;
    }

    public String toString() {
        return "LockUserInfo{uuid=" + this.uuid + ", name='" + this.name + '\'' + ", display='" + this.display + '\'' + ", skull=" + this.skull + '}';
    }

    public void addLockedChest(LockedChest lockedChest) {
        this.lockedChests.add(lockedChest);
    }

    public void removeLockedChest(LockedChest lockedChest) {
        this.lockedChests.remove(lockedChest);
    }

    public Set<LockedChest> getLockedChests() {
        return this.lockedChests;
    }

    public boolean toggleBypass() {
        this.bypassing = !this.bypassing;
        return this.bypassing;
    }

    public boolean isBypassing() {
        return this.bypassing;
    }
}

