/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.chestprotect.hikari.metrics.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.angeschossen.chestprotect.hikari.metrics.IMetricsTracker;
import me.angeschossen.chestprotect.hikari.metrics.MetricsTrackerFactory;
import me.angeschossen.chestprotect.hikari.metrics.PoolStats;
import me.angeschossen.chestprotect.hikari.metrics.prometheus.HikariCPCollector;
import me.angeschossen.chestprotect.hikari.metrics.prometheus.PrometheusHistogramMetricsTracker;
import me.angeschossen.chestprotect.hikari.metrics.prometheus.PrometheusMetricsTrackerFactory$RegistrationStatus;

public class PrometheusHistogramMetricsTrackerFactory
implements MetricsTrackerFactory {
    private static final Map registrationStatuses = new ConcurrentHashMap();
    private final HikariCPCollector collector = new HikariCPCollector();
    private final CollectorRegistry collectorRegistry;

    public PrometheusHistogramMetricsTrackerFactory() {
        this(CollectorRegistry.defaultRegistry);
    }

    public PrometheusHistogramMetricsTrackerFactory(CollectorRegistry collectorRegistry) {
        this.collectorRegistry = collectorRegistry;
    }

    @Override
    public IMetricsTracker create(String string, PoolStats poolStats) {
        this.registerCollector(this.collector, this.collectorRegistry);
        this.collector.add(string, poolStats);
        return new PrometheusHistogramMetricsTracker(string, this.collectorRegistry, this.collector);
    }

    private void registerCollector(Collector collector, CollectorRegistry collectorRegistry) {
        if (registrationStatuses.putIfAbsent(collectorRegistry, PrometheusMetricsTrackerFactory$RegistrationStatus.REGISTERED) == null) {
            collector.register(collectorRegistry);
        }
    }
}

