/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.chestprotect.hikari.pool;

import java.util.List;
import me.angeschossen.chestprotect.hikari.pool.HikariPool;
import me.angeschossen.chestprotect.hikari.pool.HikariPool$1;
import me.angeschossen.chestprotect.hikari.pool.PoolEntry;
import me.angeschossen.chestprotect.hikari.util.ClockSource;

final class HikariPool$HouseKeeper
implements Runnable {
    private volatile long previous;
    final /* synthetic */ HikariPool this$0;

    private HikariPool$HouseKeeper(HikariPool hikariPool) {
        this.this$0 = hikariPool;
        this.previous = ClockSource.plusMillis(ClockSource.currentTime(), -HikariPool.access$400(this.this$0));
    }

    @Override
    public void run() {
        try {
            this.this$0.connectionTimeout = this.this$0.config.getConnectionTimeout();
            this.this$0.validationTimeout = this.this$0.config.getValidationTimeout();
            HikariPool.access$500(this.this$0).updateLeakDetectionThreshold(this.this$0.config.getLeakDetectionThreshold());
            this.this$0.catalog = this.this$0.config.getCatalog() != null && !this.this$0.config.getCatalog().equals(this.this$0.catalog) ? this.this$0.config.getCatalog() : this.this$0.catalog;
            long l = this.this$0.config.getIdleTimeout();
            long l2 = ClockSource.currentTime();
            if (ClockSource.plusMillis(l2, 128L) < ClockSource.plusMillis(this.previous, HikariPool.access$400(this.this$0))) {
                HikariPool.access$300(this.this$0).warn("{} - Retrograde clock change detected (housekeeper delta={}), soft-evicting connections from pool.", (Object)this.this$0.poolName, (Object)ClockSource.elapsedDisplayString(this.previous, l2));
                this.previous = l2;
                this.this$0.softEvictConnections();
                return;
            }
            if (l2 > ClockSource.plusMillis(this.previous, 3L * HikariPool.access$400(this.this$0) / 2L)) {
                HikariPool.access$300(this.this$0).warn("{} - Thread starvation or clock leap detected (housekeeper delta={}).", (Object)this.this$0.poolName, (Object)ClockSource.elapsedDisplayString(this.previous, l2));
            }
            this.previous = l2;
            String string = "Pool ";
            if (l > 0L && this.this$0.config.getMinimumIdle() < this.this$0.config.getMaximumPoolSize()) {
                this.this$0.logPoolState("Before cleanup ");
                string = "After cleanup  ";
                List list = HikariPool.access$200(this.this$0).values(0);
                int n = list.size() - this.this$0.config.getMinimumIdle();
                for (PoolEntry poolEntry : list) {
                    if (n <= 0 || ClockSource.elapsedMillis(poolEntry.lastAccessed, l2) <= l || !HikariPool.access$200(this.this$0).reserve(poolEntry)) continue;
                    this.this$0.closeConnection(poolEntry, "(connection has passed idleTimeout)");
                    --n;
                }
            }
            this.this$0.logPoolState(string);
            HikariPool.access$600(this.this$0);
        }
        catch (Exception exception) {
            HikariPool.access$300(this.this$0).error("Unexpected exception in housekeeping task", exception);
        }
    }

    /* synthetic */ HikariPool$HouseKeeper(HikariPool hikariPool, HikariPool$1 hikariPool$1) {
        this(hikariPool);
    }
}

