/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.chestprotect.hikari.util;

import java.sql.SQLTransientException;
import java.util.concurrent.Semaphore;
import me.angeschossen.chestprotect.hikari.util.SuspendResumeLock$1;

public class SuspendResumeLock {
    public static final SuspendResumeLock FAUX_LOCK = new SuspendResumeLock$1(false);
    private static final int MAX_PERMITS = 10000;
    private final Semaphore acquisitionSemaphore;

    public SuspendResumeLock() {
        this(true);
    }

    private SuspendResumeLock(boolean bl) {
        this.acquisitionSemaphore = bl ? new Semaphore(10000, true) : null;
    }

    public void acquire() {
        if (this.acquisitionSemaphore.tryAcquire()) {
            return;
        }
        if (Boolean.getBoolean("me.angeschossen.chestprotect.hikari.throwIfSuspended")) {
            throw new SQLTransientException("The pool is currently suspended and configured to throw exceptions upon acquisition");
        }
        this.acquisitionSemaphore.acquireUninterruptibly();
    }

    public void release() {
        this.acquisitionSemaphore.release();
    }

    public void suspend() {
        this.acquisitionSemaphore.acquireUninterruptibly(10000);
    }

    public void resume() {
        this.acquisitionSemaphore.release(10000);
    }

    /* synthetic */ SuspendResumeLock(boolean bl, SuspendResumeLock$1 suspendResumeLock$1) {
        this(bl);
    }
}

