/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.chestprotect.slf4j;

import java.util.Map;
import me.angeschossen.chestprotect.slf4j.MDC$MDCCloseable;
import me.angeschossen.chestprotect.slf4j.helpers.NOPMDCAdapter;
import me.angeschossen.chestprotect.slf4j.helpers.Util;
import me.angeschossen.chestprotect.slf4j.impl.StaticMDCBinder;
import me.angeschossen.chestprotect.slf4j.spi.MDCAdapter;

public class MDC {
    static final String NULL_MDCA_URL = "http://www.slf4j.org/codes.html#null_MDCA";
    static final String NO_STATIC_MDC_BINDER_URL = "http://www.slf4j.org/codes.html#no_static_mdc_binder";
    static MDCAdapter mdcAdapter;

    private MDC() {
    }

    private static MDCAdapter bwCompatibleGetMDCAdapterFromBinder() {
        try {
            return StaticMDCBinder.getSingleton().getMDCA();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return StaticMDCBinder.SINGLETON.getMDCA();
        }
    }

    public static void put(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (mdcAdapter == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        mdcAdapter.put(string, string2);
    }

    public static MDC$MDCCloseable putCloseable(String string, String string2) {
        MDC.put(string, string2);
        return new MDC$MDCCloseable(string, null);
    }

    public static String get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (mdcAdapter == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        return mdcAdapter.get(string);
    }

    public static void remove(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (mdcAdapter == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        mdcAdapter.remove(string);
    }

    public static void clear() {
        if (mdcAdapter == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        mdcAdapter.clear();
    }

    public static Map getCopyOfContextMap() {
        if (mdcAdapter == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        return mdcAdapter.getCopyOfContextMap();
    }

    public static void setContextMap(Map map) {
        if (mdcAdapter == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        mdcAdapter.setContextMap(map);
    }

    public static MDCAdapter getMDCAdapter() {
        return mdcAdapter;
    }

    static {
        try {
            mdcAdapter = MDC.bwCompatibleGetMDCAdapterFromBinder();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            mdcAdapter = new NOPMDCAdapter();
            String string = noClassDefFoundError.getMessage();
            if (string != null && string.contains("StaticMDCBinder")) {
                Util.report("Failed to load class \"org.slf4j.impl.StaticMDCBinder\".");
                Util.report("Defaulting to no-operation MDCAdapter implementation.");
                Util.report("See http://www.slf4j.org/codes.html#no_static_mdc_binder for further details.");
            }
            throw noClassDefFoundError;
        }
        catch (Exception exception) {
            Util.report("MDC binding unsuccessful.", exception);
        }
    }
}

