/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.arenas;

import NL.martijnpu.ChunkDefence.Main;
import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.TimeHandler;
import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.arenas.ArenaEditor;
import NL.martijnpu.ChunkDefence.arenas.VoidGenerator;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.FileHandler;
import NL.martijnpu.ChunkDefence.data.MessageData;
import NL.martijnpu.ChunkDefence.players.PlayerDataManager;
import NL.martijnpu.ChunkDefence.statistics.ScoreManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ArenaManager {
    private static ArenaManager instance;
    private static World world;
    private final List<Arena> freeArenas;
    private final List<Arena> arenas;
    private final List<String> allSchematics = new ArrayList<String>();

    private ArenaManager() {
        this.freeArenas = new ArrayList<Arena>();
        this.arenas = new ArrayList<Arena>();
        ArenaManager.loadWorld();
        this.load();
        this.loadSchematicFiles();
    }

    public static ArenaManager getInstance() {
        if (instance == null) {
            instance = new ArenaManager();
        }
        return instance;
    }

    public static void resetInstance() {
        if (instance != null) {
            instance.shutDown();
        }
        instance = null;
    }

    public static World getArenaWorld() {
        return world;
    }

    public static void loadWorld() {
        if (Bukkit.getWorld((String)ConfigData.getInstance().getArena_world()) != null) {
            return;
        }
        try {
            Messages.sendConsole("\n");
            Messages.sendConsole("=-=-=-=-=-=-=-=-=-=-== Plugin continues after the world loading =-=-=-=-=-=--=-=-=-=-=");
            Messages.sendConsole("Registering 1 world named " + ConfigData.getInstance().getArena_world());
            WorldCreator worldCreator = new WorldCreator(ConfigData.getInstance().getArena_world());
            worldCreator.generateStructures(false);
            worldCreator.generator((ChunkGenerator)new VoidGenerator());
            worldCreator.environment(World.Environment.NORMAL);
            world = Main.getInstance().getServer().createWorld(worldCreator);
            if (world == null) {
                return;
            }
            world.setGameRule(GameRule.DO_ENTITY_DROPS, (Object)false);
            world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
            world.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
            world.setGameRule(GameRule.DO_FIRE_TICK, (Object)false);
            world.setGameRule(GameRule.DO_MOB_LOOT, (Object)false);
            world.setGameRule(GameRule.DO_MOB_SPAWNING, (Object)false);
            world.setGameRule(GameRule.ANNOUNCE_ADVANCEMENTS, (Object)false);
            world.setGameRule(GameRule.SPAWN_RADIUS, (Object)0);
            world.setGameRule(GameRule.DISABLE_RAIDS, (Object)true);
            world.setGameRule(GameRule.DO_IMMEDIATE_RESPAWN, (Object)true);
            world.setGameRule(GameRule.DO_INSOMNIA, (Object)false);
            world.setGameRule(GameRule.DO_PATROL_SPAWNING, (Object)false);
            world.setGameRule(GameRule.DO_TRADER_SPAWNING, (Object)false);
            world.setGameRule(GameRule.KEEP_INVENTORY, (Object)true);
            world.setGameRule(GameRule.MOB_GRIEFING, (Object)false);
            world.setGameRule(GameRule.NATURAL_REGENERATION, (Object)true);
            world.setGameRule(GameRule.RANDOM_TICK_SPEED, (Object)0);
            world.setGameRule(GameRule.REDUCED_DEBUG_INFO, (Object)false);
            world.setGameRule(GameRule.SPECTATORS_GENERATE_CHUNKS, (Object)false);
            world.setTime(18000L);
            Messages.sendConsole("");
            Messages.sendConsole("=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= World loading done =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void printInitData() {
        if (this.arenas.size() == 0) {
            Messages.sendConsoleWarning("Loading an empty arena file. This is an error or nobody has an arena yet :(.");
        } else {
            Messages.sendConsole("Loading " + this.arenas.size() + " player arena's.");
        }
        if (this.freeArenas.size() == 0) {
            Messages.sendConsoleWarning("Loading none schematics. This is an error or first startup.");
        } else {
            Messages.sendConsole("Loading " + this.freeArenas.size() + " schematic files.");
        }
    }

    public void shutDown() {
        this.arenas.forEach(Arena::shutDown);
    }

    public void updateSec() {
        for (Arena arena : this.arenas) {
            arena.pingSec();
        }
    }

    public boolean isInvalidSchematic(String string) {
        return string == null || !this.getAllSchematics().contains(string);
    }

    public List<String> getAllSchematics() {
        return this.allSchematics;
    }

    @Nullable
    public ItemStack getSchematicSelector(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ItemStack itemStack = new ItemStack(Material.PAINTING);
        String string = n == -1 ? "Select arena" : this.allSchematics.get(n);
        ItemMeta itemMeta = itemStack.getItemMeta();
        arrayList.add(Messages.format("&f&m:::::::::::::::::::::::::::::::::::::::::::::::"));
        for (String string2 : this.allSchematics) {
            if (string.equals(string2)) {
                arrayList.add(Messages.format("&5&l->  " + string2));
                continue;
            }
            arrayList.add(Messages.format("&b" + string2));
        }
        itemMeta.setDisplayName(string);
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public Arena getArenaCreateIfNotExist(Player player, String string) {
        Arena arena = this.getArena(player);
        if (arena != null) {
            return arena;
        }
        long l = TimeHandler.getTime() - PlayerDataManager.getInstance().getUserData((UUID)player.getUniqueId()).lastArenaCreate;
        if (l < (long)ConfigData.getInstance().getArena_cooldown()) {
            Messages.sendMessage(player, MessageData.getMessage("shop.buying.cooldown").replace("%AMOUNT%", (long)ConfigData.getInstance().getArena_cooldown() - l + 1L + ""));
            return null;
        }
        PlayerDataManager.getInstance().getUserData((UUID)player.getUniqueId()).lastArenaCreate = TimeHandler.getTime();
        Arena arena2 = this.getFreeArena(ConfigData.getInstance().getArena_default_schematic());
        if (arena2 == null) {
            Messages.sendMessage(player, "arena.schematic.not-found");
            return null;
        }
        this.freeArenas.remove(arena2);
        arena = new Arena(arena2.getArenaData(), string);
        arena.playerAdd(player);
        this.arenas.add(arena);
        this.createNewArena(ConfigData.getInstance().getArena_default_schematic());
        return arena;
    }

    @Nullable
    public Arena getArena(Player player) {
        if (player == null) {
            return null;
        }
        return this.arenas.stream().filter(arena -> arena.getArenaData().getMembers().contains(player.getUniqueId())).findFirst().orElse(null);
    }

    @Nullable
    public Arena getArena(Location location) {
        if (location == null || location.getWorld() != world) {
            return null;
        }
        return this.arenas.stream().filter(arena -> arena.isInsideArena(location)).findFirst().orElse(null);
    }

    public boolean canChangeArena(String string) {
        return this.getFreeArena(string) != null;
    }

    public void changeArena(Arena arena, String string) {
        Arena arena2 = this.getFreeArena(string);
        if (arena2 == null) {
            return;
        }
        arena.changeArena(arena2);
        this.createNewArena(string);
        this.removeArena(arena2, true);
    }

    public void removeArena(Arena arena, boolean bl) {
        ScoreManager.getInstance().removeArena(arena);
        arena.prepareForDeletion();
        ArenaEditor.getInstance().deleteArena(arena.getArenaData());
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.getInstance(), () -> {
            arena.delete();
            if (bl) {
                this.freeArenas.remove(arena);
            } else {
                this.arenas.remove(arena);
            }
        }, 1200L);
    }

    private void load() {
        String string = "arena";
        this.arenas.clear();
        this.freeArenas.clear();
        ConfigurationSection configurationSection = FileHandler.getInstance().getArenaConfig().getConfigurationSection(string);
        if (configurationSection != null) {
            for (String string2 : configurationSection.getKeys(false)) {
                try {
                    Arena arena = new Arena(string2);
                    if (arena.getArenaData().needsDeletion()) {
                        this.arenas.add(arena);
                        this.removeArena(arena, false);
                        continue;
                    }
                    if (arena.getArenaData().getMembers().size() > 0) {
                        this.arenas.add(arena);
                        ScoreManager.getInstance().updateArenaScore(arena);
                        continue;
                    }
                    this.freeArenas.add(arena);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Messages.sendConsoleWarning("Unable to read arena-data of index: '" + string2 + "'. Skipping...");
                }
            }
        }
    }

    private void createNewArena(String string) {
        Integer[] integerArray = this.getNextLocation();
        if (integerArray == null) {
            return;
        }
        Location location = ConfigData.getInstance().getArena_delta(string);
        double d = (double)ConfigData.getInstance().getArena_height() - (location != null ? location.getY() : 0.0);
        Vector vector = new Vector((double)integerArray[0].intValue(), d, (double)integerArray[1].intValue());
        Messages.sendConsole("Created " + string + " at " + FileHandler.getStringFromXYZ(vector));
        Arena arena = new Arena(vector);
        if (ArenaEditor.getInstance().pasteArena(arena.getArenaData(), string)) {
            this.freeArenas.add(arena);
        } else {
            Messages.sendConsoleWarning("&cSomething went wrong while creating an arena!");
        }
    }

    @Nullable
    private Integer[] getNextLocation() {
        int n = 1;
        int n2 = 0;
        int n3 = 1;
        Integer[] integerArray = new Integer[]{0, 0};
        int n4 = 0;
        for (int i = 0; i < this.arenas.size() + this.freeArenas.size() + 2; ++i) {
            Integer[] integerArray2 = integerArray;
            Integer.valueOf(integerArray2[0] + n * ConfigData.getInstance().getArena_space());
            integerArray2 = integerArray;
            Integer.valueOf(integerArray2[1] + n2 * ConfigData.getInstance().getArena_space());
            if (this.locationAvailable(integerArray)) {
                return integerArray;
            }
            if (++n4 != n3) continue;
            n4 = 0;
            int n5 = n;
            n = -n2;
            n2 = n5;
            if (n2 != 0) continue;
            ++n3;
        }
        Messages.sendConsoleWarning("Unable to find free spot");
        return null;
    }

    private boolean locationAvailable(Integer[] integerArray) {
        Vector vector;
        if (integerArray[0] == 0 && integerArray[1] == 0) {
            return false;
        }
        for (Arena arena : this.arenas) {
            vector = arena.getArenaData().getArenaLoc();
            if (vector == null || vector.getBlockX() != integerArray[0].intValue() || vector.getBlockZ() != integerArray[1].intValue()) continue;
            return false;
        }
        for (Arena arena : this.freeArenas) {
            vector = arena.getArenaData().getArenaLoc();
            if (vector == null || vector.getBlockX() != integerArray[0].intValue() || vector.getBlockZ() != integerArray[1].intValue()) continue;
            return false;
        }
        return true;
    }

    private void loadSchematicFiles() {
        this.allSchematics.addAll(FileHandler.getInstance().getAllSchematics());
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.getInstance(), () -> {
            for (String string : this.allSchematics) {
                if (this.getFreeArena(string) != null) continue;
                this.createNewArena(string);
            }
        }, 200L);
    }

    @Nullable
    private Arena getFreeArena(@Nullable String string) {
        return this.freeArenas.stream().filter(arena -> arena.getArenaData().getSchematicName().equalsIgnoreCase(string) && !arena.getArenaData().needsDeletion()).findFirst().orElse(null);
    }
}

