/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.cmds;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.cmds.SubCommand;
import NL.martijnpu.ChunkDefence.data.MessageData;
import NL.martijnpu.ChunkDefence.players.Economy;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

class AdminEcoRemoveCmd
extends SubCommand {
    AdminEcoRemoveCmd() {
    }

    @Override
    String getCommand() {
        return "chunkdefenceadmin";
    }

    @Override
    String getDescription() {
        return "Add money to a player";
    }

    @Override
    String getPermission() {
        return "chunkdefence.admin.economy";
    }

    @Override
    String[] getArgs() {
        return new String[]{"economy", "remove"};
    }

    @Override
    int getPlayerArguments() {
        return 2;
    }

    @Override
    String getUsage() {
        return super.getUsage() + " <player> <amount>";
    }

    @Override
    List<List<String>> getTabComplete() {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        arrayList.add(Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName).collect(Collectors.toList()));
        arrayList.add(IntStream.rangeClosed(0, 9).mapToObj(n -> n + "").collect(Collectors.toList()));
        return arrayList;
    }

    @Override
    void onCommand(Player player, String[] stringArray) {
        try {
            Player player2 = Bukkit.getPlayer((String)stringArray[0]);
            if (player2 == null) {
                Messages.sendMessage(player, "exception.offline");
                return;
            }
            Economy.withdrawPlayer(player2, Double.parseDouble(stringArray[1]));
            Messages.sendMessage(player, MessageData.getMessage("economy.total").replace("%NAME%", player2.getName()).replace("%AMOUNT%", Economy.getBalance(player2) + ""));
            Messages.sendMessage(player2, MessageData.getMessage("economy.remove").replace("%AMOUNT%", stringArray[1]));
        }
        catch (NumberFormatException numberFormatException) {
            Messages.sendMessage(player, MessageData.getMessage("exception.number").replace("%NUMBER%", stringArray[1]));
        }
    }
}

