/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.cmds;

import NL.martijnpu.ChunkDefence.cmds.SubCommand;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.DefinedMobData;
import NL.martijnpu.ChunkDefence.waves.SpawnWaves;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

class AdminWaveListCmd
extends SubCommand {
    private static final int bookSize = 100;

    AdminWaveListCmd() {
    }

    @Override
    String getCommand() {
        return "chunkdefenceadmin";
    }

    @Override
    String getDescription() {
        return "Shows a list of waves.";
    }

    @Override
    String[] getArgs() {
        return new String[]{"wave", "list"};
    }

    @Override
    String getUsage() {
        return super.getUsage() + " [number]";
    }

    @Override
    String getPermission() {
        return "chunkdefence.admin.wave";
    }

    @Override
    boolean playerOnly() {
        return true;
    }

    @Override
    void onCommand(Player player, String[] stringArray) {
        Object object;
        if (stringArray.length == 0) {
            stringArray = new String[]{"0"};
        }
        try {
            Integer.parseInt(stringArray[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringArray = new String[]{"0"};
        }
        int n = Integer.parseInt(stringArray[0]) * 100;
        ItemStack itemStack = new ItemStack(Material.WRITTEN_BOOK, 1);
        BookMeta bookMeta = (BookMeta)itemStack.getItemMeta();
        assert (bookMeta != null);
        bookMeta.setGeneration(BookMeta.Generation.ORIGINAL);
        bookMeta.setAuthor("ChunkDefence");
        bookMeta.setTitle("Waves");
        BookMeta.Spigot spigot = bookMeta.spigot();
        BaseComponent[] baseComponentArray = new BaseComponent[]{new TextComponent()};
        spigot.addPage((BaseComponent[][])new BaseComponent[][]{(BaseComponent[])baseComponentArray.clone()});
        int n2 = 0;
        int n3 = 1;
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        while (spigot.getPages().size() < 100) {
            block14: {
                try {
                    object = ConfigData.getInstance().isWaveDefined(n3) ? ConfigData.getInstance().getWave(n3) : SpawnWaves.getGeneratedWave(n3);
                    if (n4 <= n3) break block14;
                    n4 = n3;
                }
                catch (Exception exception) {
                    baseComponentArray[0].addExtra("Wave " + n3 + "\n");
                    baseComponentArray[0].setBold(Boolean.valueOf(true));
                    baseComponentArray[0].setColor(ChatColor.DARK_RED);
                    baseComponentArray[0].addExtra("Unable to generate.\n" + exception.getMessage());
                    break;
                }
            }
            if (object.size() + n2 + 2 > 14) {
                if (n5 >= n) {
                    spigot.addPage((BaseComponent[][])new BaseComponent[][]{(BaseComponent[])baseComponentArray.clone()});
                } else {
                    ++n5;
                }
                baseComponentArray = new BaseComponent[]{new TextComponent()};
                n2 = 0;
            }
            n2 += object.size() + 2;
            baseComponentArray[0].addExtra("Wave " + n3 + "\n");
            baseComponentArray[0].setBold(Boolean.valueOf(true));
            baseComponentArray[0].setColor(ChatColor.GOLD);
            for (Map.Entry entry : object.entrySet()) {
                TextComponent textComponent = new TextComponent("  - " + (Integer)entry.getKey() % 100 + " " + ((DefinedMobData)entry.getValue()).getEntityType().name().toLowerCase().replace("_", " ") + "\n");
                textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(this.getMobData((DefinedMobData)entry.getValue(), (Integer)entry.getKey() % 100, ""))}));
                textComponent.setBold(Boolean.valueOf(false));
                textComponent.setColor(ChatColor.BLACK);
                baseComponentArray[0].addExtra((BaseComponent)textComponent);
            }
            baseComponentArray[0].addExtra("\n");
            ++n3;
        }
        baseComponentArray = new BaseComponent[]{new TextComponent()};
        object = new TextComponent("  List of waves\n\n");
        object.setBold(Boolean.valueOf(true));
        baseComponentArray[0].addExtra((BaseComponent)object.duplicate());
        if (n4 == Integer.MAX_VALUE) {
            object.setText("Unable to generate waves.\nInvalid config OR wave can't be generated (Too big)\n");
            object.setBold(Boolean.valueOf(false));
            object.setColor(ChatColor.RED);
            baseComponentArray[0].addExtra((BaseComponent)object.duplicate());
            object.setText("How to check the config:\n - Do '/cda reload'\n - Check the console for errors");
            object.setBold(Boolean.valueOf(false));
            object.setColor(ChatColor.BLACK);
        } else {
            object.setText("Waves " + n4 + " - " + n3);
            object.setBold(Boolean.valueOf(false));
            baseComponentArray[0].addExtra((BaseComponent)object.duplicate());
            if (n > 0) {
                object.setText("\nPrevious waves");
                object.setColor(ChatColor.GOLD);
                object.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("\u00a7fClick")}));
                object.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/cda wave list " + (Integer.parseInt(stringArray[0]) - 1)));
                baseComponentArray[0].addExtra((BaseComponent)object.duplicate());
            }
            object.setText("\nMore waves");
            object.setColor(ChatColor.GOLD);
            object.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("\u00a7fClick")}));
            object.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/cda wave list " + (Integer.parseInt(stringArray[0]) + 1)));
        }
        baseComponentArray[0].addExtra((BaseComponent)object.duplicate());
        spigot.setPage(1, baseComponentArray);
        itemStack.setItemMeta((ItemMeta)bookMeta);
        player.openBook(itemStack);
    }

    private String getMobData(DefinedMobData definedMobData, int n, String string) {
        return string + "\u00a76Type: \u00a7f" + definedMobData.getEntityType().toString().toLowerCase() + "\n" + string + "\u00a76Coins: \u00a7f" + definedMobData.getCoins() + "\n" + string + "\u00a76Amount: \u00a7f" + definedMobData.getAmount() * n + "\n" + string + "\u00a76Points: \u00a7f" + definedMobData.getWeight() + (definedMobData.getEntityHealth() == -1 ? "" : "\n" + string + "\u00a76Health: \u00a7f" + definedMobData.getEntityHealth()) + (definedMobData.getCustomName() == null ? "" : "\n" + string + "\u00a76Custom name: \u00a7f" + ChatColor.translateAlternateColorCodes((char)'&', (String)definedMobData.getCustomName())) + (definedMobData.getEntityType() != EntityType.SLIME ? "" : "\n" + string + "\u00a76Size: \u00a7f" + definedMobData.getSize()) + (definedMobData.getEntityType() != EntityType.CREEPER ? "" : "\n" + string + "\u00a76ExplosionRadius: \u00a7f" + definedMobData.getExplosionRadius()) + (definedMobData.getColor() == null ? "" : "\n" + string + "\u00a76Color: \u00a7f" + definedMobData.getColor().toLowerCase()) + (!definedMobData.getSilent() ? "" : "\n" + string + "\u00a76Silent: \u00a7ftrue") + (!definedMobData.getGlowing() ? "" : "\n" + string + "\u00a76Glowing: \u00a7ftrue") + (!definedMobData.getGliding() ? "" : "\n" + string + "\u00a76Gliding: \u00a7ftrue") + (definedMobData.getEntityMainHand() == null ? "" : "\n" + string + "\u00a76Hand: \u00a7f" + definedMobData.getEntityMainHand().getType().toString().toLowerCase()) + (definedMobData.getEntityHelmet() == null ? "" : "\n" + string + "\u00a76Helmet: \u00a7f" + definedMobData.getEntityHelmet().getType().toString().toLowerCase()) + (definedMobData.getEntityChestPlate() == null ? "" : "\n" + string + "\u00a76Chestplate: \u00a7f" + definedMobData.getEntityChestPlate().getType().toString().toLowerCase()) + (definedMobData.getEntityLeggings() == null ? "" : "\n" + string + "\u00a76Leggings: \u00a7f" + definedMobData.getEntityLeggings().getType().toString().toLowerCase()) + (definedMobData.getEntityBoots() == null ? "" : "\n" + string + "\u00a76Boots: \u00a7f" + definedMobData.getEntityBoots().getType().toString().toLowerCase()) + (definedMobData.getPassenger() == null ? "" : "\n" + string + "\u00a76Passenger:\n" + this.getMobData(definedMobData.getPassenger(), n, "\u00a7f-"));
    }
}

