/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.cmds;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.cmds.SubCommand;
import NL.martijnpu.ChunkDefence.data.MessageData;
import NL.martijnpu.ChunkDefence.gui.GuiManager;
import NL.martijnpu.ChunkDefence.gui.GuiType;
import NL.martijnpu.ChunkDefence.waves.SpawnWaves;
import org.bukkit.entity.Player;

class AdminWaveSpawnCmd
extends SubCommand {
    AdminWaveSpawnCmd() {
    }

    @Override
    String getCommand() {
        return "chunkdefenceadmin";
    }

    @Override
    String getDescription() {
        return "Summon a specific wave";
    }

    @Override
    String[] getArgs() {
        return new String[]{"wave", "spawn"};
    }

    @Override
    String getPermission() {
        return "chunkdefence.admin.wave";
    }

    @Override
    boolean playerOnly() {
        return true;
    }

    @Override
    int getPlayerArguments() {
        return 1;
    }

    @Override
    String getUsage() {
        return super.getUsage() + " <wave number>";
    }

    @Override
    void onCommand(Player player, String[] stringArray) {
        try {
            Arena arena = ArenaManager.getInstance().getArena(player);
            if (arena == null) {
                GuiManager.getInstance().openInventory(player, GuiType.GAMEMODES, null);
                return;
            }
            arena.teleportHome(player, false);
            SpawnWaves.spawn(Integer.parseInt(stringArray[0]), arena);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Messages.sendMessage(player, MessageData.getMessage("wave.nonexist").replace("%AMOUNT%", stringArray[0]));
        }
    }
}

