/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.data;

import NL.martijnpu.ChunkDefence.Main;
import NL.martijnpu.ChunkDefence.Messages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.util.Vector;

public class FileHandler {
    private static FileHandler instance;
    private final File schematicFile = new File(Main.getInstance().getDataFolder(), "/structure");
    private final File messagesFile = new File(Main.getInstance().getDataFolder(), "/messages.yml");
    private final File economyFile = new File(Main.getInstance().getDataFolder(), "/economy.yml");
    private final File scoresFile = new File(Main.getInstance().getDataFolder(), "/highscores.yml");
    private final File shopsFile = new File(Main.getInstance().getDataFolder(), "/shops.yml");
    private final File trapsFile = new File(Main.getInstance().getDataFolder(), "/traps.yml");
    private final File arenaFile = new File(Main.getInstance().getDataFolder(), "/arenas.yml");
    private final File mobsFile = new File(Main.getInstance().getDataFolder(), "/mobs.yml");
    private FileConfiguration messagesConfig = null;
    private FileConfiguration economyConfig = null;
    private FileConfiguration scoresConfig = null;
    private FileConfiguration shopsConfig = null;
    private FileConfiguration trapsConfig = null;
    private FileConfiguration arenaConfig = null;
    private FileConfiguration mobsConfig = null;

    private FileHandler() {
    }

    public static FileHandler getInstance() {
        if (instance == null) {
            instance = new FileHandler();
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    public static boolean setNotExists(FileConfiguration fileConfiguration, String string, Object object) {
        if (fileConfiguration.isSet(string)) {
            return false;
        }
        Messages.sendConsoleWarning("Missing data at '" + string + "'. Setting the default now...");
        fileConfiguration.set(string, object);
        return true;
    }

    @Nullable
    public static Location getLocationFromString(String string) {
        float f;
        float f2;
        double d;
        double d2;
        double d3;
        World world;
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        string = string + " ";
        String[] stringArray = string.split(" ");
        switch (stringArray.length) {
            case 4: 
            case 6: {
                world = Bukkit.getServer().getWorld(stringArray[0]);
                d3 = Double.parseDouble(stringArray[1]);
                d2 = Double.parseDouble(stringArray[2]);
                d = Double.parseDouble(stringArray[3]);
                f2 = stringArray.length >= 5 ? Float.parseFloat(stringArray[4]) : 0.0f;
                f = stringArray.length >= 6 ? Float.parseFloat(stringArray[5]) : 180.0f;
                break;
            }
            case 3: 
            case 5: {
                world = null;
                d3 = Double.parseDouble(stringArray[0]);
                d2 = Double.parseDouble(stringArray[1]);
                d = Double.parseDouble(stringArray[2]);
                f2 = stringArray.length >= 4 ? Float.parseFloat(stringArray[3]) : 0.0f;
                f = stringArray.length >= 5 ? Float.parseFloat(stringArray[4]) : 180.0f;
                break;
            }
            default: {
                return null;
            }
        }
        return new Location(world, d3, d2, d, f2, f);
    }

    public static String getStringFromLocation(Location location) {
        String string = FileHandler.getStringFromLocationExcludeWorld(location);
        if (string.isEmpty()) {
            return string;
        }
        return (location.getWorld() == null ? "null" : location.getWorld().getName()) + ' ' + string;
    }

    public static String getStringFromLocationExcludeWorld(Location location) {
        if (location == null) {
            return "";
        }
        if (location.getYaw() == 0.0f && location.getPitch() == 0.0f) {
            return FileHandler.getStringFromXYZ(location.toVector());
        }
        return FileHandler.getStringFromXYZ(location.toVector()) + ' ' + (location.getYaw() % 1.0f == 0.0f ? (float)((int)location.getYaw()) : location.getYaw()) + ' ' + (location.getPitch() % 1.0f == 0.0f ? (float)((int)location.getPitch()) : location.getPitch());
    }

    @Nullable
    public static Vector getXYZFromString(String string) {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        String[] stringArray = (string = string + " ").split(" ");
        return stringArray.length != 3 ? new Vector(0, 0, 0) : new Vector(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]));
    }

    public static Location roundToHalf(Location location) {
        location.setX(FileHandler.roundToHalf(location.getX()));
        location.setY(FileHandler.roundToHalf(location.getY()));
        location.setZ(FileHandler.roundToHalf(location.getZ()));
        location.setYaw((float)((int)location.getYaw()));
        location.setPitch((float)((int)location.getPitch()));
        return location;
    }

    public static String getStringFromXYZ(Vector vector) {
        return vector == null ? "" : "" + (vector.getX() % 1.0 == 0.0 ? (double)((int)vector.getX()) : vector.getX()) + " " + (vector.getY() % 1.0 == 0.0 ? (double)((int)vector.getY()) : vector.getY()) + " " + (vector.getZ() % 1.0 == 0.0 ? (double)((int)vector.getZ()) : vector.getZ());
    }

    private static double roundToHalf(double d) {
        return (double)Math.round(d * 2.0) / 2.0;
    }

    public FileConfiguration getMessagesConfig() {
        if (this.messagesConfig == null) {
            this.messagesConfig = this.loadConfig(this.messagesFile);
        }
        return this.messagesConfig;
    }

    public FileConfiguration getEconomyConfig() {
        if (this.economyConfig == null) {
            this.economyConfig = this.loadConfig(this.economyFile);
        }
        return this.economyConfig;
    }

    public FileConfiguration getScoresConfig() {
        if (this.scoresConfig == null) {
            this.scoresConfig = this.loadConfig(this.scoresFile);
        }
        return this.scoresConfig;
    }

    public FileConfiguration getShopsConfig() {
        if (this.shopsConfig == null) {
            this.shopsConfig = this.loadConfig(this.shopsFile);
        }
        return this.shopsConfig;
    }

    public FileConfiguration getTrapsConfig() {
        if (this.trapsConfig == null) {
            this.trapsConfig = this.loadConfig(this.trapsFile);
        }
        return this.trapsConfig;
    }

    public FileConfiguration getArenaConfig() {
        if (this.arenaConfig == null) {
            this.arenaConfig = this.loadConfig(this.arenaFile);
        }
        return this.arenaConfig;
    }

    public FileConfiguration getMobsConfig() {
        if (this.mobsConfig == null) {
            this.mobsConfig = this.loadConfig(this.mobsFile);
        }
        return this.mobsConfig;
    }

    public void saveShopsConfig() {
        this.saveConfig(this.shopsConfig, this.shopsFile);
    }

    public void saveScoresConfig() {
        this.saveConfig(this.scoresConfig, this.scoresFile);
    }

    public void saveUsersConfig() {
        this.saveConfig(this.economyConfig, this.economyFile);
    }

    public void saveMobsConfig() {
        this.saveConfig(this.mobsConfig, this.mobsFile);
    }

    public void saveArenaConfig() {
        this.saveConfig(this.arenaConfig, this.arenaFile);
    }

    public void saveTrapsConfig() {
        this.saveConfig(this.trapsConfig, this.trapsFile);
    }

    public List<String> getAllSchematics() {
        List<String> list = new ArrayList<String>();
        if (this.schematicFile.isDirectory() && this.schematicFile.list() != null) {
            list = Arrays.stream(this.schematicFile.list()).map(string -> string.replaceAll(".[a-zA-Z]*$", "")).collect(Collectors.toList());
        }
        return list;
    }

    private FileConfiguration loadConfig(File file) {
        YamlConfiguration yamlConfiguration;
        if (!file.exists()) {
            Main.getInstance().saveResource(file.getName(), false);
        }
        if ((yamlConfiguration = YamlConfiguration.loadConfiguration((File)file)).getKeys(false).size() == 0) {
            yamlConfiguration = this.backupConfig(file);
        }
        return yamlConfiguration;
    }

    private FileConfiguration backupConfig(File file) {
        String string = "backups/" + file.getName().replace(".yml", "") + "_backup";
        File file2 = new File(Main.getInstance().getDataFolder(), "backups");
        if (!file2.exists() && !file2.mkdirs()) {
            Messages.sendConsole("Failed to create backup directory");
        }
        int n = 1;
        while (file2.exists()) {
            file2 = new File(Main.getInstance().getDataFolder(), string + "_" + n++ + ".yml");
        }
        Messages.sendConsole("Renaming to " + file2.getName());
        if (!file.renameTo(file2)) {
            Messages.sendConsole("Failed creating backup");
        }
        file.delete();
        Main.getInstance().saveResource(file.getName(), true);
        return YamlConfiguration.loadConfiguration((File)file);
    }

    private void saveConfig(FileConfiguration fileConfiguration, File file) {
        if (fileConfiguration == null) {
            return;
        }
        try {
            fileConfiguration.save(file);
        }
        catch (IOException iOException) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Could not save config to " + file, iOException);
        }
    }
}

