/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.events;

import NL.martijnpu.ChunkDefence.Main;
import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.data.MessageData;
import NL.martijnpu.ChunkDefence.players.Economy;
import NL.martijnpu.ChunkDefence.statistics.HighScore;
import NL.martijnpu.ChunkDefence.statistics.ScoreManager;
import NL.martijnpu.ChunkDefence.waves.WaveController;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlaceholderAPI
extends PlaceholderExpansion {
    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getAuthor() {
        return Main.getInstance().getDescription().getAuthors().toString();
    }

    @NotNull
    public String getIdentifier() {
        return "chunkdefence";
    }

    @NotNull
    public String getVersion() {
        return Main.getInstance().getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, @NotNull String string) {
        if (player == null) {
            return "";
        }
        String[] stringArray = string.split("_");
        switch (stringArray[0]) {
            case "wave": {
                Arena arena = ArenaManager.getInstance().getArena(player);
                if (arena == null) {
                    return Messages.format("placeholders.wave.none");
                }
                return arena.getArenaData().getWave() + "";
            }
            case "info": {
                Arena arena = ArenaManager.getInstance().getArena(player);
                if (arena == null) {
                    return Messages.format("placeholders.none-arena");
                }
                WaveController waveController = arena.getWaveController();
                if (waveController == null) {
                    return Messages.format("placeholders.wave.none");
                }
                return waveController.getInfo();
            }
            case "balance": {
                return (double)Math.round(Economy.getBalance(player) * 100.0) / 100.0 + "";
            }
            case "gamemode": {
                Arena arena = ArenaManager.getInstance().getArena(player);
                if (arena == null) {
                    return Messages.format("placeholders.none-gamemode");
                }
                return arena.getArenaData().getGamemode();
            }
            case "wavetop": {
                int n;
                if (stringArray.length == 2) {
                    stringArray = new String[]{stringArray[0], "default", stringArray[1]};
                }
                if (!ScoreManager.getInstance().isValidGamemode(stringArray[1])) {
                    return Messages.format("&4Unknown gamemode &f" + stringArray[1]);
                }
                for (n = 1; n < 11; ++n) {
                    if (!stringArray[2].equals("" + n)) continue;
                    HighScore highScore = ScoreManager.getInstance().getTopGamemode(stringArray[1], n);
                    if (highScore == null) {
                        return Messages.format(MessageData.getMessage("placeholders.top.empty").replace("%INDEX%", n + ""));
                    }
                    return Messages.format(MessageData.getMessage("placeholders.top.wave").replace("%INDEX%", n + "").replace("%GAMEMODE%", stringArray[1]).replace("%WAVE%", highScore.getWave() + "").replace("%MEMBERS%", highScore.getMembers()));
                }
            }
            case "killtop": {
                int n;
                for (n = 1; n < 11; ++n) {
                    if (!stringArray[1].equals(n + "")) continue;
                    OfflinePlayer offlinePlayer = ScoreManager.getInstance().getTopKiller(n);
                    if (offlinePlayer == null) {
                        return Messages.format(MessageData.getMessage("placeholders.top.empty").replace("%INDEX%", n + ""));
                    }
                    return Messages.format(MessageData.getMessage("placeholders.top.kill").replace("%INDEX%", n + "").replace("%NAME%", offlinePlayer.getName() == null ? "Unnamed" : offlinePlayer.getName()).replace("%AMOUNT%", offlinePlayer.getStatistic(Statistic.MOB_KILLS) + ""));
                }
                break;
            }
        }
        return null;
    }
}

