/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.gui;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.ArenaManager;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.MessageData;
import NL.martijnpu.ChunkDefence.gui.GuiInventory;
import NL.martijnpu.ChunkDefence.gui.GuiManager;
import NL.martijnpu.ChunkDefence.gui.GuiSign;
import NL.martijnpu.ChunkDefence.gui.GuiSlot;
import NL.martijnpu.ChunkDefence.gui.GuiType;
import NL.martijnpu.ChunkDefence.shops.Shop;
import NL.martijnpu.ChunkDefence.shops.ShopArena;
import NL.martijnpu.ChunkDefence.shops.ShopItem;
import NL.martijnpu.ChunkDefence.shops.ShopManager;
import NL.martijnpu.ChunkDefence.shops.ShopTrap;
import NL.martijnpu.ChunkDefence.statistics.HighScore;
import NL.martijnpu.ChunkDefence.statistics.ScoreManager;
import NL.martijnpu.ChunkDefence.traps.DamageType;
import NL.martijnpu.ChunkDefence.traps.ParticleOnAttack;
import NL.martijnpu.ChunkDefence.traps.ParticleType;
import NL.martijnpu.ChunkDefence.traps.TrapBase;
import NL.martijnpu.ChunkDefence.traps.TrapManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionType;

public class GuiMethods {
    private static String getDisplayName(InventoryView inventoryView, int n) {
        ItemStack itemStack;
        ItemStack itemStack2 = itemStack = n == -1 ? inventoryView.getCursor() : inventoryView.getItem(n);
        if (itemStack != null && itemStack.getItemMeta() != null) {
            return itemStack.getItemMeta().getDisplayName();
        }
        return "";
    }

    private static Material getType(InventoryView inventoryView, int n) {
        ItemStack itemStack;
        ItemStack itemStack2 = itemStack = n == -1 ? inventoryView.getCursor() : inventoryView.getItem(n);
        if (itemStack != null) {
            return itemStack.getType();
        }
        return Material.GLASS_PANE;
    }

    private static void toggleFireStatus(Player player, GuiInventory guiInventory) {
        int n = 8;
        player.playSound(player.getEyeLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
        if (GuiMethods.getType(guiInventory.getInventoryView(), n).equals((Object)Material.FIRE_CORAL_FAN)) {
            guiInventory.changeItem(n, guiInventory.getGuiSlot(n).setMaterial(Material.DEAD_FIRE_CORAL_FAN).setName("&6Set fire: &ffalse"));
        } else if (GuiMethods.getType(guiInventory.getInventoryView(), n).equals((Object)Material.DEAD_FIRE_CORAL_FAN)) {
            guiInventory.changeItem(n, guiInventory.getGuiSlot(n).setMaterial(Material.FIRE_CORAL_FAN).setName("&6Set fire: &ftrue"));
        } else {
            throw new UnsupportedOperationException("Something went wrong while selecting setFire.");
        }
    }

    static Map<Integer, GuiSlot> getTrapPage(Player player, AtomicInteger atomicInteger) {
        HashMap<Integer, GuiSlot> hashMap = new HashMap<Integer, GuiSlot>();
        GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
        if (guiInventory == null) {
            return hashMap;
        }
        for (int i = 18 * atomicInteger.get(); i < 18 * (atomicInteger.get() + 1); ++i) {
            if (i >= TrapManager.getInstance().getAllTrapBases().size()) {
                hashMap.put(i, null);
                continue;
            }
            TrapBase trapBase = TrapManager.getInstance().getAllTrapBases().get(i);
            if (trapBase != null) {
                hashMap.put(i, new GuiSlot(trapBase.generateTrapItem(1)).setName(trapBase.getName()).setLeftClick(() -> guiInventory.getInventoryView().setCursor(trapBase.generateTrapItem(1))).setLeftShiftClick(() -> guiInventory.getInventoryView().setCursor(trapBase.generateTrapItem(64))).setRightClick(() -> GuiMethods.openGuiTrapInfo(player, trapBase)));
                continue;
            }
            hashMap.put(i, new GuiSlot(Material.BARRIER, "Unknown trap"));
        }
        if (TrapManager.getInstance().getAllTrapBases().size() > 18) {
            hashMap.put(32, new GuiSlot(Material.PAPER, "&6Next page").setLeftClick(() -> {
                atomicInteger.getAndIncrement();
                guiInventory.changeItems(false, GuiMethods.getTrapPage(player, atomicInteger));
            }));
        } else {
            hashMap.put(32, null);
        }
        if (atomicInteger.get() > 0) {
            hashMap.put(30, new GuiSlot(Material.PAPER, "&6Previous page").setLeftClick(() -> {
                atomicInteger.getAndDecrement();
                guiInventory.changeItems(false, GuiMethods.getTrapPage(player, atomicInteger));
            }));
        } else {
            hashMap.put(30, null);
        }
        return hashMap;
    }

    static void swapItemsNull(Player player, int n, Material material) {
        GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
        if (guiInventory == null) {
            return;
        }
        ItemStack itemStack = guiInventory.getInventoryView().getCursor();
        ItemStack itemStack2 = guiInventory.getInventoryView().getItem(n);
        if (itemStack2 != null && itemStack2.getType() == material) {
            guiInventory.getInventoryView().setCursor(new ItemStack(Material.AIR));
        } else {
            guiInventory.getInventoryView().setCursor(itemStack2);
        }
        if (itemStack != null && itemStack.getType() == Material.AIR) {
            guiInventory.getInventoryView().setItem(n, new ItemStack(material));
        } else {
            guiInventory.getInventoryView().setItem(n, itemStack);
        }
    }

    static void closeGui(Player player) {
        GuiManager.getInstance().closeInventory(player);
        player.playSound(player.getEyeLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
    }

    static void saveShop(Shop shop, Player player) {
        GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
        if (guiInventory == null) {
            return;
        }
        InventoryView inventoryView = guiInventory.getInventoryView();
        if (inventoryView.getItem(10) == null) {
            Messages.sendMessage(player, "&cShop must sell an item.");
            return;
        }
        try {
            shop.setCost(Double.parseDouble(GuiMethods.getDisplayName(inventoryView, 14)));
        }
        catch (NumberFormatException numberFormatException) {
            Messages.sendMessage(player, "&c'&f" + GuiMethods.getDisplayName(inventoryView, -1) + "&c' is not a valid price.");
            return;
        }
        if (shop instanceof ShopArena) {
            ((ShopArena)shop).setName(GuiMethods.getDisplayName(inventoryView, 12));
            ((ShopArena)shop).setSchematic(GuiMethods.getDisplayName(inventoryView, 10));
        } else if (shop instanceof ShopTrap) {
            ((ShopTrap)shop).setTrapbase(TrapManager.getInstance().getTrapBase((Multimap<Attribute, AttributeModifier>)inventoryView.getItem(10).getItemMeta().getAttributeModifiers()));
        } else if (shop instanceof ShopItem) {
            ((ShopItem)shop).changeItem(Objects.requireNonNull(inventoryView.getItem(10)));
            ((ShopItem)shop).setName(GuiMethods.getDisplayName(inventoryView, 12));
        }
        if (inventoryView.getItem(16).getType().equals((Object)Material.GLASS_PANE)) {
            inventoryView.setItem(16, null);
        }
        shop.changeDisplayItem(inventoryView.getItem(16));
        shop.save();
        GuiMethods.closeGui(player);
        ShopManager.resetInstance();
        ShopManager.getInstance().printInitData();
        player.playSound(player.getEyeLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
    }

    static void editSchematicIndex(Player player, AtomicInteger atomicInteger, boolean bl) {
        GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
        if (guiInventory == null) {
            return;
        }
        atomicInteger.getAndAdd(bl ? 1 : -1);
        if (atomicInteger.get() >= ArenaManager.getInstance().getAllSchematics().size()) {
            atomicInteger.set(0);
        }
        if (atomicInteger.get() < 0) {
            atomicInteger.set(ArenaManager.getInstance().getAllSchematics().size() - 1);
        }
        guiInventory.getInventoryView().setItem(10, ArenaManager.getInstance().getSchematicSelector(atomicInteger.get()));
        player.playSound(player.getEyeLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
    }

    static ItemStack getSchematicIndex(AtomicInteger atomicInteger, String string) {
        atomicInteger.set(ArenaManager.getInstance().getAllSchematics().indexOf(string));
        return ArenaManager.getInstance().getSchematicSelector(atomicInteger.get());
    }

    static void editTrapIndex(Player player, AtomicInteger atomicInteger, boolean bl) {
        GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
        if (guiInventory == null) {
            return;
        }
        atomicInteger.getAndAdd(bl ? 1 : -1);
        if (atomicInteger.get() >= TrapManager.getInstance().getAllTrapBasesName().size()) {
            atomicInteger.set(0);
        }
        if (atomicInteger.get() < 0) {
            atomicInteger.set(TrapManager.getInstance().getAllTrapBasesName().size() - 1);
        }
        guiInventory.getInventoryView().setItem(10, TrapManager.getInstance().getTrapSelector(TrapManager.getInstance().getAllTrapBases().get(atomicInteger.get()).generateTrapItem(1)));
        player.playSound(player.getEyeLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
    }

    static ItemStack getTrapIndex(AtomicInteger atomicInteger, TrapBase trapBase) {
        atomicInteger.set(TrapManager.getInstance().getAllTrapBasesName().indexOf(trapBase.getIndexName()));
        return TrapManager.getInstance().getTrapSelector(TrapManager.getInstance().getAllTrapBases().get(atomicInteger.get()).generateTrapItem(1));
    }

    static void editTopIndex(Player player, AtomicInteger atomicInteger, boolean bl) {
        String string2;
        GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
        if (guiInventory == null) {
            return;
        }
        atomicInteger.getAndAdd(bl ? 1 : -1);
        if (atomicInteger.get() >= ConfigData.getInstance().getGamemodes().size()) {
            atomicInteger.set(0);
        }
        if (atomicInteger.get() < 0) {
            atomicInteger.set(ConfigData.getInstance().getGamemodes().size() - 1);
        }
        ItemStack itemStack = new ItemStack(Material.LECTERN);
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : ConfigData.getInstance().getGamemodes()) {
            if (ConfigData.getInstance().getGamemodes().get(atomicInteger.get()).equals(string2)) {
                arrayList.add(Messages.format("&5&l->  " + ConfigData.getInstance().getGamemodesName(string2)));
                continue;
            }
            arrayList.add(Messages.format("&b" + ConfigData.getInstance().getGamemodesName(string2)));
        }
        arrayList.add(Messages.format("&f&m:::::::::::::::::::::::::::::::::::::::::::::::"));
        if (itemMeta != null) {
            itemMeta.setLore(arrayList);
            itemStack.setItemMeta(itemMeta);
        }
        String string3 = ConfigData.getInstance().getGamemodes().get(atomicInteger.get());
        string2 = MessageData.getMessage("gui.scoreboard.gamemode-name").replace("%GAMEMODE%", ConfigData.getInstance().getGamemodesName(string3));
        guiInventory.changeItem(40, new GuiSlot(ConfigData.getInstance().getGamemodesMaterial(string3), string2));
        guiInventory.changeItem(49, guiInventory.getGuiSlot(49).setLore(arrayList));
        GuiMethods.changeTop(player, ConfigData.getInstance().getGamemodes().get(atomicInteger.get()));
        player.playSound(player.getEyeLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
    }

    static Map<Integer, GuiSlot> getLine(int n, int n2) {
        HashMap<Integer, GuiSlot> hashMap = new HashMap<Integer, GuiSlot>();
        for (int i = n; i <= n2; ++i) {
            hashMap.put(i, new GuiSlot(Material.BLACK_STAINED_GLASS_PANE).setAnimated(9.0, i).addAnimation(Material.BLACK_STAINED_GLASS_PANE, 20).addAnimation(Material.WHITE_STAINED_GLASS_PANE).addAnimation(Material.LIGHT_GRAY_STAINED_GLASS_PANE, 2).addAnimation(Material.GRAY_STAINED_GLASS_PANE, 3));
        }
        return hashMap;
    }

    static void openGuiTrapInfo(final Player player, final TrapBase trapBase) {
        GuiMethods.closeGui(player);
        GuiInventory guiInventory = new GuiInventory((Map<Integer, GuiSlot>)new HashMap<Integer, GuiSlot>(){
            {
                GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
                this.put(0, new GuiSlot(Material.NAME_TAG, "&6Name: &f" + trapBase.getName()).setLore(Arrays.asList("&eThis is the name shown to players.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Name", 9, trapBase.getName() + "", "")));
                this.put(9, new GuiSlot(Material.PAPER, "&f" + trapBase.getName()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Name", 9, trapBase.getName() + "", "")));
                this.put(1, new GuiSlot(Material.ACACIA_SIGN, "&6Lore").setLore(Arrays.asList("&eThis is the lore shown to players.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Lore", 10, trapBase.getLore() + "", "lore")));
                this.put(10, new GuiSlot(Material.PAPER, "&f" + trapBase.getLore()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Lore", 10, trapBase.getLore() + "", "lore")));
                this.put(2, new GuiSlot(Material.CLOCK, "&6Current setup time: &f" + trapBase.getSetupTime()).setLore(Arrays.asList("&eThis value is the amount of time it takes for this trap to become active.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Setup time", 11, trapBase.getSetupTime() + "", "double")));
                this.put(11, new GuiSlot(Material.PAPER, "&f" + trapBase.getSetupTime()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Setup time", 11, trapBase.getSetupTime() + "", "double")));
                this.put(3, new GuiSlot(Material.CROSSBOW, "&6Target range: &f" + trapBase.getTargetRange()).setLore(Arrays.asList("&eThis value is the range in which the trap will attack entities.", "&eSetting the value to -1 will make the trap have no limit.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Target range", 12, trapBase.getTargetRange() + "", "double")));
                this.put(12, new GuiSlot(Material.PAPER, "&f" + trapBase.getTargetRange()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Target range", 12, trapBase.getTargetRange() + "", "double")));
                this.put(4, new GuiSlot(Material.PRISMARINE_CRYSTALS, "&6Target amount: &f" + trapBase.getTargetAmount()).setLore(Arrays.asList("&eThis value is the amount of entities the trap can target at once.", "&eSetting the value to -1 will make the trap target all mobs in his range.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Target amount", 13, trapBase.getTargetAmount() + "", "int")));
                this.put(13, new GuiSlot(Material.PAPER, "&f" + trapBase.getTargetAmount()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Target amount", 13, trapBase.getTargetAmount() + "", "int")));
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("&eThe trap will only attack these entities. Leave empty to target");
                arrayList.add("all entities except players. Players can be added to the list.");
                arrayList.add(" ");
                arrayList.add("Current:");
                trapBase.getTargetEntity().forEach((? super T entityType) -> arrayList.add("&e- " + entityType.name().toLowerCase().replace('_', ' ')));
                arrayList.add(" ");
                arrayList.add("Click to edit");
                this.put(5, new GuiSlot(Material.ZOMBIE_HEAD, "&6Target entities").setLore(arrayList).setAnimated(0.4, 0.0).addAnimation(Material.WITHER_SKELETON_SKULL).addAnimation(Material.CREEPER_HEAD).addAnimation(Material.ZOMBIE_HEAD).addAnimation(Material.PLAYER_HEAD).addAnimation(Material.SKELETON_SKULL).setLeftClick(() -> GuiMethods.openEntityLoreSign(player, 14, true)).setRightClick(() -> GuiMethods.openEntityLoreSign(player, 14, false)));
                this.put(14, new GuiSlot(Material.PAPER, "&6Entities:").setLore(trapBase.getTargetEntity().stream().map(entityType -> entityType.name().toLowerCase().replace('_', ' ')).collect(Collectors.toList())).setLeftClick(() -> GuiMethods.openEntityLoreSign(player, 14, true)).setRightClick(() -> GuiMethods.openEntityLoreSign(player, 14, false)));
                this.put(6, new GuiSlot(Material.CHIPPED_ANVIL, "&6Durability: &f" + trapBase.getMaxDurability()).setLore(Arrays.asList("&eThis value is the maximum durability for this trap. When it reaches 0, the trap breaks. ", "&eSetting this value to -1 will give it infinite durability.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Durability", 15, trapBase.getMaxDurability() + "", "int")));
                this.put(15, new GuiSlot(Material.PAPER, "&f" + trapBase.getMaxDurability()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Durability", 15, trapBase.getMaxDurability() + "", "int")));
                this.put(7, new GuiSlot(Material.BRICK, "&6Display item").setLore(Collections.singletonList("Replace the item below with the item you want to be displayed.")));
                this.put(16, new GuiSlot(trapBase.getDisplayItem()).setLeftClick(() -> GuiMethods.swapItemsNull(player, 16, Material.DEAD_BUSH)));
                this.put(8, new GuiSlot(Material.BRICKS, "&6Display block").setLore(Collections.singletonList("Replace the item below with the item you want to be displayed.")));
                this.put(17, new GuiSlot(trapBase.getTrapBlock()).setLeftClick(() -> GuiMethods.swapItemsNull(player, 17, Material.DIRT)));
                this.put(27, new GuiSlot(Material.GREEN_CONCRETE, "&aSave changes").setLeftClick(() -> this.saveTrapInfo(guiInventory)));
                this.put(30, new GuiSlot(Material.BARRIER, "&cRemove trap").setLeftClick(() -> GuiMethods.openGuiRemoveTrap(player, GuiType.TRAPS, trapBase)));
                this.put(32, new GuiSlot(Material.BLAZE_POWDER, "&6Particle settings").setLore(Arrays.asList("&eParticle: &f" + trapBase.getParticle().name(), "&eMode: &f" + (Object)((Object)trapBase.getMovementMode()), "&eOn attack: &f" + (Object)((Object)trapBase.getParticleOnAttack()), "&eAmount: &f" + trapBase.getParticleAmount())).setLeftClick(() -> GuiMethods.openTrapParticle(player, trapBase)));
                this.put(33, new GuiSlot(Material.IRON_SWORD, "&6Attack settings").setAnimated(1.0, 0.0).addAnimation(Material.IRON_SWORD).addAnimation(Material.EXPERIENCE_BOTTLE).addAnimation(Material.IRON_AXE).addAnimation(Material.HONEY_BOTTLE).setLore(Arrays.asList("&eDamage type: &f" + trapBase.getDamageType().name().toLowerCase(), "&eInterval: &f" + trapBase.getInterval(), "&eSet fire: &f" + trapBase.isSetOnFire())).setLeftClick(() -> {
                    GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
                    GuiMethods.closeGui(player);
                    GuiManager.getInstance().openInventory(player, new GuiInventory(trapBase.getDamageType().equals((Object)DamageType.DAMAGE) ? GuiMethods.getTrapDamageSlots(player, trapBase, guiInventory) : GuiMethods.getTrapPotionSlots(player, trapBase, guiInventory), 36, "Edit values"));
                }));
                this.put(35, new GuiSlot(Material.RED_CONCRETE, "&cCancel").setLeftClick(() -> {
                    GuiMethods.closeGui(player);
                    GuiManager.getInstance().openInventory(player, GuiType.TRAPS, null);
                }));
                for (int i = 18; i <= 26; ++i) {
                    this.put(i, new GuiSlot(Material.BLACK_STAINED_GLASS_PANE).setAnimated(9.0, i).addAnimation(Material.BLACK_STAINED_GLASS_PANE, 20).addAnimation(Material.WHITE_STAINED_GLASS_PANE).addAnimation(Material.LIGHT_GRAY_STAINED_GLASS_PANE, 2).addAnimation(Material.GRAY_STAINED_GLASS_PANE, 3));
                }
            }

            private void saveTrapInfo(GuiInventory guiInventory) {
                if (guiInventory == null) {
                    Messages.sendMessage(player, "exception.administrator");
                    Messages.sendConsoleWarning("No GUI found for this player");
                } else {
                    try {
                        trapBase.setName(GuiMethods.getDisplayName(guiInventory.getInventoryView(), 9).replace('\u00a7', '&'));
                        trapBase.setLore(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory.getInventoryView(), 10)));
                        trapBase.setSetupTime(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory.getInventoryView(), 11)));
                        trapBase.setTargetRange(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory.getInventoryView(), 12)));
                        trapBase.setTargetAmount(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory.getInventoryView(), 13)));
                        trapBase.setTargetEntity(guiInventory.getInventoryView().getItem(14).getItemMeta().getLore());
                        trapBase.setMaxDurability(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory.getInventoryView(), 15)));
                        trapBase.setDisplayItem(GuiMethods.getType(guiInventory.getInventoryView(), 16));
                        trapBase.setTrapBlock(GuiMethods.getType(guiInventory.getInventoryView(), 17));
                    }
                    catch (NullPointerException | NumberFormatException runtimeException) {
                        Messages.sendMessage(player, "exception.administrator");
                        Messages.sendConsoleWarning("An error occurred in a gui: " + runtimeException.getLocalizedMessage());
                        runtimeException.printStackTrace();
                    }
                    trapBase.save();
                    GuiMethods.closeGui(player);
                    this.put(28, new GuiSlot(trapBase.generateTrapItem(1)).setLeftClick(() -> guiInventory.getInventoryView().setCursor(trapBase.generateTrapItem(1))).setLeftShiftClick(() -> guiInventory.getInventoryView().setCursor(trapBase.generateTrapItem(64))));
                }
                GuiManager.getInstance().openInventory(player, GuiType.TRAPS, null);
            }
        }, 36, "Edit trap properties");
        GuiManager.getInstance().openInventory(player, guiInventory);
    }

    static void openTrapParticle(final Player player, final TrapBase trapBase) {
        final GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
        GuiMethods.closeGui(player);
        GuiInventory guiInventory2 = new GuiInventory((Map<Integer, GuiSlot>)new HashMap<Integer, GuiSlot>(){
            {
                this.put(0, new GuiSlot(Material.BLAZE_POWDER, "&6Particle type: &f" + trapBase.getParticle().name().toLowerCase()).setLore(Arrays.asList("&eThis is the type of particles around the trap.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&cParticle", 9, trapBase.getParticle().name().toLowerCase().replace('_', ' '), "particle")));
                this.put(9, new GuiSlot(Material.PAPER, "&f" + trapBase.getParticle().name().toLowerCase()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&cParticle", 9, trapBase.getParticle().name().toLowerCase().replace('_', ' '), "particle")));
                this.put(1, new GuiSlot(Material.CLOCK, "&6Speed: &f" + trapBase.getParticleSpeed()).setLore(Arrays.asList("&eThis value is the speed of each individual particle.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Particle speed", 10, trapBase.getParticleSpeed() + "", "double")));
                this.put(10, new GuiSlot(Material.PAPER, "&f" + trapBase.getParticleSpeed()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Particle speed", 10, trapBase.getParticleSpeed() + "", "double")));
                this.put(2, new GuiSlot(Material.WHITE_DYE, "&6Amount: &f" + trapBase.getParticleAmount()).setLore(Arrays.asList("&eThis value is the amount of particles each game tick.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Particle amount", 11, trapBase.getParticleAmount() + "", "int")));
                this.put(11, new GuiSlot(Material.PAPER, "&f" + trapBase.getParticleAmount()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Particle amount", 11, trapBase.getParticleAmount() + "", "int")));
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("&eThis value is the way particles will move.");
                arrayList.add(" ");
                arrayList.add("Values:");
                for (ParticleType particleType : ParticleType.values()) {
                    arrayList.add("&e- " + particleType.toString().toLowerCase().replace('_', ' '));
                }
                arrayList.add(" ");
                arrayList.add("Click to edit.");
                this.put(4, new GuiSlot(Material.COCOA_BEANS, "&6Movement mode: &f" + (Object)((Object)trapBase.getMovementMode())).setLore(arrayList).setAnimated(4.0, 0.0).addAnimation(Material.COCOA_BEANS).addAnimation(Material.MELON_SEEDS).setLeftClick(() -> GuiMethods.openSign(player, "&6Movement mode", 13, trapBase.getMovementMode().name().toLowerCase().replace('_', ' ') + "", "particleMovement")));
                this.put(13, new GuiSlot(Material.PAPER, "&f" + (Object)((Object)trapBase.getMovementMode())).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Movement mode", 13, trapBase.getMovementMode().name().toLowerCase().replace('_', ' ') + "", "particleMovement")));
                ArrayList arrayList2 = new ArrayList();
                arrayList.add("&eThis value is the way particles will move when attacking.");
                arrayList2.add(" ");
                arrayList2.add("Values:");
                for (ParticleOnAttack particleOnAttack : ParticleOnAttack.values()) {
                    arrayList2.add("&e- " + particleOnAttack.toString().toLowerCase().replace('_', ' '));
                }
                arrayList2.add(" ");
                arrayList2.add("Click to edit.");
                this.put(5, new GuiSlot(Material.IRON_SWORD, "&6Attack particle: &f" + (Object)((Object)trapBase.getParticleOnAttack())).setLore(arrayList2).setAnimated(1.0, 0.0).addAnimation(Material.IRON_SWORD, 2).addAnimation(Material.IRON_AXE).addAnimation(Material.IRON_HOE).addAnimation(Material.IRON_SHOVEL).addAnimation(Material.IRON_PICKAXE).setLeftClick(() -> GuiMethods.openSign(player, "&6Attack particle", 14, trapBase.getParticleOnAttack().name().toLowerCase().replace('_', ' ') + "", "particleAttack")));
                this.put(14, new GuiSlot(Material.PAPER, "&f" + (Object)((Object)trapBase.getParticleOnAttack())).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Attack particle", 14, trapBase.getParticleOnAttack().name().toLowerCase().replace('_', ' ') + "", "particleAttack")));
                this.put(6, new GuiSlot(Material.BOWL, "&6Movement size: &f" + trapBase.getParticleSize()).setLore(Arrays.asList("&eThis value is The size of the movement the particles make.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Movement size", 15, trapBase.getParticleSize() + "", "double")));
                this.put(15, new GuiSlot(Material.PAPER, "&f" + trapBase.getParticleSize()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Movement size", 15, trapBase.getParticleSize() + "", "double")));
                this.put(7, new GuiSlot(Material.FEATHER, "&6Movement speed: &f" + trapBase.getModeSpeed()).setLore(Arrays.asList("&eThis value is The speed of the movement the particles make.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Movement speed", 16, trapBase.getModeSpeed() + "", "double")));
                this.put(16, new GuiSlot(Material.PAPER, "&f" + trapBase.getModeSpeed()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Movement speed", 16, trapBase.getModeSpeed() + "", "double")));
                this.put(27, new GuiSlot(Material.GREEN_CONCRETE, "&aSave changes").setLeftClick(this::saveTrapParticle));
                this.put(35, new GuiSlot(Material.RED_CONCRETE, "&cCancel").setLeftClick(() -> {
                    GuiMethods.closeGui(player);
                    GuiManager.getInstance().openInventory(player, guiInventory);
                }));
                for (int i = 18; i <= 26; ++i) {
                    this.put(i, new GuiSlot(Material.BLACK_STAINED_GLASS_PANE, " ").setAnimated(9.0, i).addAnimation(Material.BLACK_STAINED_GLASS_PANE, 20).addAnimation(Material.WHITE_STAINED_GLASS_PANE).addAnimation(Material.LIGHT_GRAY_STAINED_GLASS_PANE, 2).addAnimation(Material.GRAY_STAINED_GLASS_PANE, 3));
                }
            }

            private void saveTrapParticle() {
                if (guiInventory == null) {
                    Messages.sendMessage(player, "exception.administrator");
                    Messages.sendConsoleWarning("No GUI found for this player");
                } else {
                    try {
                        trapBase.setParticle(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory.getInventoryView(), 9)));
                        trapBase.setParticleSpeed(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory.getInventoryView(), 10)));
                        trapBase.setParticleAmount(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory.getInventoryView(), 11)));
                        trapBase.setMovementMode(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory.getInventoryView(), 13)));
                        trapBase.setParticleOnAttack(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory.getInventoryView(), 14)));
                        trapBase.setParticleSize(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory.getInventoryView(), 15)));
                        trapBase.setModeSpeed(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory.getInventoryView(), 16)));
                    }
                    catch (NullPointerException | NumberFormatException runtimeException) {
                        Messages.sendMessage(player, "exception.administrator");
                        Messages.sendConsoleWarning("An error occurred in a gui: " + runtimeException.getLocalizedMessage());
                    }
                    trapBase.save();
                    GuiMethods.closeGui(player);
                    guiInventory.changeItem(28, new GuiSlot(trapBase.generateTrapItem(1)).setLeftClick(() -> guiInventory.getInventoryView().setCursor(trapBase.generateTrapItem(1))).setLeftShiftClick(() -> guiInventory.getInventoryView().setCursor(trapBase.generateTrapItem(64))));
                }
                GuiManager.getInstance().openInventory(player, guiInventory);
            }
        }, 36, "Edit particle and damage.");
        GuiManager.getInstance().openInventory(player, guiInventory2);
    }

    static HashMap<Integer, GuiSlot> getTrapDamageSlots(final Player player, final TrapBase trapBase, final GuiInventory guiInventory) {
        final GuiInventory guiInventory2 = GuiManager.getInstance().getGuiInventory(player);
        if (guiInventory2 == null) {
            return new HashMap<Integer, GuiSlot>();
        }
        return new HashMap<Integer, GuiSlot>(){
            {
                this.put(0, new GuiSlot(Material.IRON_SWORD, "&6Damage type: &f" + trapBase.getParticle().name().toLowerCase()).setLore(Arrays.asList("&eThis is the mode which the trap uses to attack.", "It can either be damage or a potion effect", " ", "Left shift click to toggle.")).setAnimated(1.0, 0.0).addAnimation(Material.IRON_SWORD).addAnimation(Material.DRAGON_BREATH).setLeftShiftClick(() -> guiInventory2.changeItems(true, GuiMethods.getTrapPotionSlots(player, trapBase, guiInventory))));
                this.put(9, new GuiSlot(Material.IRON_SWORD, "&6Potion").setLeftShiftClick(() -> guiInventory2.changeItems(true, GuiMethods.getTrapDamageSlots(player, trapBase, guiInventory))));
                this.put(2, new GuiSlot(Material.BELL, "&6Attack sound: &f" + trapBase.getSoundOnAttack()).setLore(Arrays.asList("&eThis value is the time in between each attack.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Attack sound", 11, trapBase.getSoundOnAttack().name().toLowerCase().replace('_', ' '), "sound")));
                this.put(11, new GuiSlot(Material.PAPER, "&f" + trapBase.getSoundOnAttack()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Attack sound", 11, trapBase.getSoundOnAttack().name().toLowerCase().replace('_', ' '), "sound")));
                this.put(4, new GuiSlot(Material.CLOCK, "&6Interval: &f" + trapBase.getInterval()).setLore(Arrays.asList("&eThis value is the time in between each attack.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Interval", 13, trapBase.getInterval() + "", "double")));
                this.put(13, new GuiSlot(Material.PAPER, "&f" + trapBase.getInterval()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Interval", 13, trapBase.getInterval() + "", "double")));
                this.put(6, new GuiSlot(Material.REDSTONE, "&6Damage: &f" + trapBase.getDamage()).setLore(Arrays.asList("&eThis value is the amount of damage the trap will deal", "&eeach time it attacks. it is counted in half harts.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Damage", 15, trapBase.getDamage() + "", "int")));
                this.put(15, new GuiSlot(Material.PAPER, "&f" + trapBase.getDamage()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Damage", 15, trapBase.getDamage() + "", "int")));
                this.put(8, new GuiSlot(trapBase.isSetOnFire() ? Material.FIRE_CORAL_FAN : Material.DEAD_FIRE_CORAL_FAN, "&6Set fire: &f" + trapBase.isSetOnFire()).setLore(Arrays.asList("&eWhether this trap will set fire to the attacked mobs.", " ", "Click to toggle.")).setLeftClick(() -> GuiMethods.toggleFireStatus(player, guiInventory2)));
                this.put(27, new GuiSlot(Material.GREEN_CONCRETE, "&aSave changes").setLeftClick(this::saveTrapDamage));
                this.put(35, new GuiSlot(Material.RED_CONCRETE, "&cCancel").setLeftClick(() -> {
                    GuiMethods.closeGui(player);
                    GuiManager.getInstance().openInventory(player, guiInventory);
                }));
                for (int i = 18; i <= 26; ++i) {
                    this.put(i, new GuiSlot(Material.BLACK_STAINED_GLASS_PANE, " ").setAnimated(10.0, i).addAnimation(Material.BLACK_STAINED_GLASS_PANE, 20).addAnimation(Material.WHITE_STAINED_GLASS_PANE).addAnimation(Material.LIGHT_GRAY_STAINED_GLASS_PANE, 2).addAnimation(Material.GRAY_STAINED_GLASS_PANE, 3));
                }
            }

            private void saveTrapDamage() {
                GuiInventory guiInventory3 = GuiManager.getInstance().getGuiInventory(player);
                if (guiInventory3 == null) {
                    Messages.sendMessage(player, "exception.administrator");
                    Messages.sendConsoleWarning("Unable to get GUI for this player");
                } else {
                    try {
                        trapBase.setSoundOnAttack(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory3.getInventoryView(), 11)));
                        trapBase.setInterval(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory3.getInventoryView(), 13)));
                        trapBase.setDamage(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory3.getInventoryView(), 15)));
                        trapBase.setSetOnFire(GuiMethods.getType(guiInventory3.getInventoryView(), 8).equals((Object)Material.FIRE_CORAL_FAN));
                        trapBase.setDamageType("DAMAGE");
                    }
                    catch (NullPointerException | NumberFormatException runtimeException) {
                        Messages.sendMessage(player, "exception.administrator");
                        Messages.sendConsoleWarning("An error occurred in a gui: " + runtimeException.getLocalizedMessage());
                    }
                    trapBase.save();
                    GuiMethods.closeGui(player);
                    guiInventory.changeItem(28, new GuiSlot(trapBase.generateTrapItem(1)).setLeftClick(() -> guiInventory3.getInventoryView().setCursor(trapBase.generateTrapItem(1))).setLeftShiftClick(() -> guiInventory3.getInventoryView().setCursor(trapBase.generateTrapItem(64))));
                }
                GuiManager.getInstance().openInventory(player, guiInventory);
            }
        };
    }

    static HashMap<Integer, GuiSlot> getTrapPotionSlots(final Player player, final TrapBase trapBase, final GuiInventory guiInventory) {
        final GuiInventory guiInventory2 = GuiManager.getInstance().getGuiInventory(player);
        if (guiInventory2 == null) {
            return new HashMap<Integer, GuiSlot>();
        }
        return new HashMap<Integer, GuiSlot>(){
            {
                this.put(0, new GuiSlot(Material.IRON_SWORD, "&6Damage type: &f" + trapBase.getDamageType().name().toLowerCase()).setLore(Arrays.asList("&eThis is the mode which the trap uses to attack.", "It can either be damage or a potion effect", " ", "Left shift click to toggle.")).setAnimated(1.0, 0.0).addAnimation(Material.IRON_SWORD).addAnimation(Material.DRAGON_BREATH).setLeftShiftClick(() -> guiInventory2.changeItems(true, GuiMethods.getTrapDamageSlots(player, trapBase, guiInventory))));
                this.put(9, new GuiSlot(Material.DRAGON_BREATH, "&6Potion").setLeftShiftClick(() -> guiInventory2.changeItems(true, GuiMethods.getTrapDamageSlots(player, trapBase, guiInventory))));
                this.put(2, new GuiSlot(Material.BELL, "&6Attack sound: &f" + trapBase.getSoundOnAttack()).setLore(Arrays.asList("&eThis value is the time in between each attack.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Attack sound", 11, trapBase.getSoundOnAttack().name().toLowerCase().replace('_', ' '), "sound")));
                this.put(11, new GuiSlot(Material.PAPER, "&f" + trapBase.getSoundOnAttack()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Attack sound", 11, trapBase.getSoundOnAttack().name().toLowerCase().replace('_', ' '), "sound")));
                this.put(4, new GuiSlot(Material.CLOCK, "&6Interval: &f" + trapBase.getInterval()).setLore(Arrays.asList("&eThis value is the time in between each attack.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Interval", 13, trapBase.getInterval() + "", "double")));
                this.put(13, new GuiSlot(Material.PAPER, "&f" + trapBase.getInterval()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Interval", 13, trapBase.getInterval() + "", "double")));
                this.put(5, new GuiSlot(Material.POTION, "&6Potion effect: &f" + trapBase.getPotionEffectType().getName().toLowerCase().replace('_', ' ')).setLore(Arrays.asList("&eThis value is the effect type of this trap.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Potion effect", 14, trapBase.getPotionEffectType().getName().toLowerCase().replace('_', ' ') + "", "potion")));
                this.put(14, new GuiSlot(Material.PAPER, "&f" + trapBase.getPotionEffectType().getName().toLowerCase().replace('_', ' ')).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Potion effect", 14, trapBase.getPotionEffectType().getName().toLowerCase().replace('_', ' ') + "", "potion")));
                this.put(6, new GuiSlot(Material.BREWING_STAND, "&6Potion amplifier: &f" + trapBase.getPotionAmplify()).setLore(Arrays.asList("&eThis value is the amplifier the effect will have.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Potion amplifier", 15, trapBase.getPotionAmplify() + "", "int")));
                this.put(15, new GuiSlot(Material.PAPER, "&f" + trapBase.getPotionAmplify()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Potion amplifier", 15, trapBase.getPotionAmplify() + "", "int")));
                this.put(7, new GuiSlot(Material.CLOCK, "&6Potion time: &f" + trapBase.getPotionTime()).setLore(Arrays.asList("&eThis value is the time the effect will last.", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Potion time", 16, trapBase.getPotionTime() + "", "double")));
                this.put(16, new GuiSlot(Material.PAPER, "&f" + trapBase.getPotionTime()).setLore(Arrays.asList("Value will be changed to:", " ", "Click to edit.")).setLeftClick(() -> GuiMethods.openSign(player, "&6Potion time", 16, trapBase.getPotionTime() + "", "double")));
                this.put(8, new GuiSlot(trapBase.isSetOnFire() ? Material.FIRE_CORAL_FAN : Material.DEAD_FIRE_CORAL_FAN, "&6Set fire: &f" + trapBase.isSetOnFire()).setLore(Arrays.asList("&eWhether this trap will set fire to the attacked mobs.", " ", "Click to toggle.")).setLeftClick(() -> GuiMethods.toggleFireStatus(player, guiInventory2)));
                this.put(27, new GuiSlot(Material.GREEN_CONCRETE, "&aSave changes").setLeftClick(this::saveTrapPotions));
                this.put(35, new GuiSlot(Material.RED_CONCRETE, "&cCancel").setLeftClick(() -> {
                    GuiMethods.closeGui(player);
                    GuiManager.getInstance().openInventory(player, guiInventory);
                }));
                for (int i = 18; i <= 26; ++i) {
                    this.put(i, new GuiSlot(Material.BLACK_STAINED_GLASS_PANE, " ").setAnimated(8.0, i).addAnimation(Material.BLACK_STAINED_GLASS_PANE, 20).addAnimation(Material.WHITE_STAINED_GLASS_PANE).addAnimation(Material.LIGHT_GRAY_STAINED_GLASS_PANE, 2).addAnimation(Material.GRAY_STAINED_GLASS_PANE, 3));
                }
            }

            private void saveTrapPotions() {
                try {
                    trapBase.setSoundOnAttack(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory2.getInventoryView(), 11)));
                    trapBase.setInterval(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory2.getInventoryView(), 13)));
                    trapBase.setSetOnFire(GuiMethods.getType(guiInventory2.getInventoryView(), 8).equals((Object)Material.FIRE_CORAL_FAN));
                    trapBase.setPotionEffectType(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory2.getInventoryView(), 15)));
                    trapBase.setPotionAmplify(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory2.getInventoryView(), 15)));
                    trapBase.setPotionTime(ChatColor.stripColor((String)GuiMethods.getDisplayName(guiInventory2.getInventoryView(), 16)));
                    trapBase.setDamageType("POTION_EFFECT");
                }
                catch (NullPointerException | NumberFormatException runtimeException) {
                    Messages.sendMessage(player, "exception.administrator");
                    Messages.sendConsoleWarning("An error occurred in a gui: " + runtimeException.getLocalizedMessage());
                }
                trapBase.save();
                GuiMethods.closeGui(player);
                guiInventory.changeItem(28, new GuiSlot(trapBase.generateTrapItem(1)).setLeftClick(() -> guiInventory2.getInventoryView().setCursor(trapBase.generateTrapItem(1))).setLeftShiftClick(() -> guiInventory2.getInventoryView().setCursor(trapBase.generateTrapItem(64))));
                GuiManager.getInstance().openInventory(player, guiInventory);
            }
        };
    }

    static void openGuiRemoveTrap(final Player player, final GuiType guiType, final @Nullable TrapBase trapBase) {
        GuiMethods.closeGui(player);
        GuiInventory guiInventory = new GuiInventory((Map<Integer, GuiSlot>)new HashMap<Integer, GuiSlot>(){
            {
                this.put(1, new GuiSlot(Material.GREEN_CONCRETE, "&aConfirm").setLore(Collections.singletonList("This action can not be undone.")).setLeftClick(() -> {
                    if (trapBase != null) {
                        TrapManager.getInstance().removeTrapBase(trapBase);
                        Messages.sendMessage(player, "&bSuccessfully removed the trap");
                    } else if (ShopManager.getInstance().removeShop(player)) {
                        Messages.sendMessage(player, "shop.removed");
                        player.playSound(player.getEyeLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    } else {
                        Messages.sendMessage(player, "shop.not-found");
                        player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                    }
                    player.playSound(player.getEyeLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    GuiMethods.closeGui(player);
                }));
                this.put(3, new GuiSlot(Material.RED_CONCRETE_POWDER, "&cCancel").setLeftClick(() -> {
                    GuiMethods.closeGui(player);
                    GuiManager.getInstance().openInventory(player, guiType, null);
                }));
            }
        }, InventoryType.HOPPER, "Remove the " + (trapBase == null ? "shop?" : "trap?"));
        GuiManager.getInstance().openInventory(player, guiInventory);
    }

    static void openGuiTopBackMenu(final Player player) {
        GuiMethods.closeGui(player);
        GuiManager.getInstance().openInventory(player, GuiType.TOP, (Map<Integer, GuiSlot>)new HashMap<Integer, GuiSlot>(){
            {
                this.put(53, new GuiSlot(Material.OAK_FENCE_GATE, "gui.main-menu.back").setLeftClick(() -> {
                    GuiMethods.closeGui(player);
                    GuiManager.getInstance().openInventory(player, GuiType.MAIN_MENU, null);
                }));
            }
        });
    }

    static void openGuiItemShop(final Player player) {
        GuiMethods.closeGui(player);
        GuiManager.getInstance().openInventory(player, GuiType.SHOP_EDIT_ITEM, (Map<Integer, GuiSlot>)new HashMap<Integer, GuiSlot>(){
            {
                this.put(27, new GuiSlot(Material.GREEN_CONCRETE, "&aAdd shop").setLeftClick(() -> {
                    GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
                    if (guiInventory == null) {
                        Messages.sendMessage(player, "exception.administrator");
                        Messages.sendConsoleWarning("Unable to get the inventory of a player to change items");
                    } else {
                        if (guiInventory.getInventoryView().getItem(10) == null) {
                            Messages.sendMessage(player, "&cA shop must sell an item.");
                            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                            return;
                        }
                        try {
                            ShopItem shopItem = (ShopItem)ShopManager.getInstance().addShop(player, guiInventory.getInventoryView().getItem(10), Double.parseDouble(GuiMethods.getDisplayName(guiInventory.getInventoryView(), 14)));
                            shopItem.setName(Objects.requireNonNull(GuiMethods.getDisplayName(guiInventory.getInventoryView(), 12)));
                            shopItem.changeDisplayItem(guiInventory.getInventoryView().getItem(16));
                            shopItem.save();
                            player.playSound(player.getEyeLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
                            GuiMethods.closeGui(player);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Messages.sendMessage(player, "&f" + GuiMethods.getDisplayName(guiInventory.getInventoryView(), 14) + " &cis not a valid price.");
                            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                        }
                    }
                }));
                this.put(31, new GuiSlot());
            }
        });
    }

    static void openGuiTrapShop(final Player player) {
        GuiMethods.closeGui(player);
        GuiManager.getInstance().openInventory(player, GuiType.SHOP_EDIT_TRAP, (Map<Integer, GuiSlot>)new HashMap<Integer, GuiSlot>(){
            {
                this.put(27, new GuiSlot(Material.GREEN_CONCRETE, "&aAdd shop").setLeftClick(() -> {
                    GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
                    if (guiInventory == null) {
                        Messages.sendMessage(player, "exception.administrator");
                        Messages.sendConsoleWarning("Unable to get the inventory of a player to change items");
                    } else {
                        try {
                            ShopTrap shopTrap = (ShopTrap)ShopManager.getInstance().addShop(player, TrapManager.getInstance().getTrapBase((Multimap<Attribute, AttributeModifier>)guiInventory.getInventoryView().getItem(10).getItemMeta().getAttributeModifiers()), Double.parseDouble(GuiMethods.getDisplayName(guiInventory.getInventoryView(), 14)));
                            shopTrap.save();
                            GuiMethods.closeGui(player);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Messages.sendMessage(player, "&f" + GuiMethods.getDisplayName(guiInventory.getInventoryView(), 14) + " &cis not a valid price.");
                            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                        }
                    }
                }));
                this.put(31, new GuiSlot());
            }
        });
    }

    static void openGuiArenaShop(final Player player) {
        GuiMethods.closeGui(player);
        GuiManager.getInstance().openInventory(player, GuiType.SHOP_EDIT_ARENA, (Map<Integer, GuiSlot>)new HashMap<Integer, GuiSlot>(){
            {
                this.put(27, new GuiSlot(Material.GREEN_CONCRETE, "&aAdd shop").setLeftClick(() -> {
                    GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
                    if (guiInventory == null) {
                        Messages.sendMessage(player, "exception.administrator");
                        Messages.sendConsoleWarning("Unable to get the inventory of a player to change items");
                    } else {
                        try {
                            ShopArena shopArena = ShopManager.getInstance().addShop(player, GuiMethods.getDisplayName(guiInventory.getInventoryView(), 10) + "", Double.parseDouble(GuiMethods.getDisplayName(guiInventory.getInventoryView(), 14)));
                            shopArena.setName(GuiMethods.getDisplayName(guiInventory.getInventoryView(), 12));
                            shopArena.changeDisplayItem(guiInventory.getInventoryView().getItem(16));
                            shopArena.save();
                            player.playSound(player.getEyeLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
                            GuiMethods.closeGui(player);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Messages.sendMessage(player, "&f" + GuiMethods.getDisplayName(guiInventory.getInventoryView(), 14) + " &cis not a valid price.");
                            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                        }
                    }
                }));
                this.put(31, new GuiSlot());
            }
        });
    }

    static void openSign(Player player, String string, final int n, String string2, final String string3) {
        GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
        if (guiInventory == null) {
            Messages.sendMessage(player, "exception.administrator");
            Messages.sendConsoleWarning("Old GUI is closed. Report this to the developer!");
            return;
        }
        final GuiSlot guiSlot = guiInventory.getGuiSlot(n);
        final String string4 = ChatColor.getLastColors((String)guiSlot.getName());
        final GuiSign guiSign = string3.equals("lore") ? new GuiSign(Lists.newArrayList((Object[])new String[]{"&f&o", "&f&o", "&f&o", "&a&l\u2191 lore \u2191"})) : new GuiSign(Lists.newArrayList((Object[])new String[]{"", "&a&l\u2191 \u2191 \u2191 \u2191", string, "&eType on first line."})).setLine(0, "\u00a7f\u00a7o" + string2);
        guiSign.response(() -> {
            Object object;
            final String string3 = ChatColor.stripColor((String)guiSign.getLines()[0]);
            if (string3.isEmpty()) {
                player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                GuiManager.getInstance().openInventory(player, guiInventory);
                return;
            }
            try {
                switch (string3) {
                    case "double": {
                        object = Double.parseDouble(string3.toUpperCase().replace(' ', '_'));
                        break;
                    }
                    case "int": {
                        object = Integer.parseInt(string3.toUpperCase().replace(' ', '_'));
                        break;
                    }
                    case "potion": {
                        object = PotionType.valueOf((String)string3.toUpperCase().replace(' ', '_'));
                        break;
                    }
                    case "sound": {
                        object = Sound.valueOf((String)string3.toUpperCase().replace(' ', '_'));
                        break;
                    }
                    case "particle": {
                        object = Particle.valueOf((String)string3.toUpperCase().replace(' ', '_'));
                        break;
                    }
                    case "particleAttack": {
                        object = ParticleOnAttack.valueOf(string3.toUpperCase().replace(' ', '_'));
                        break;
                    }
                    case "particleMovement": {
                        object = ParticleType.valueOf(string3.toUpperCase().replace(' ', '_'));
                        break;
                    }
                    default: {
                        object = null;
                        break;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                Messages.sendMessage(player, "&f" + string3 + " &cis not a valid " + string3 + ".");
                GuiManager.getInstance().openInventory(player, guiInventory);
                return;
            }
            guiInventory.changeItems(false, (Map<Integer, GuiSlot>)new HashMap<Integer, GuiSlot>(){
                {
                    if (string3.equals("double") || string3.equals("int")) {
                        this.put(n, guiSlot.setName(string4 + object + ""));
                    } else if (string3.equals("lore")) {
                        this.put(n, guiSlot.setName(string4 + ChatColor.stripColor((String)guiSign.getLines()[0]) + ChatColor.stripColor((String)guiSign.getLines()[1]) + ChatColor.stripColor((String)guiSign.getLines()[2])));
                    } else {
                        this.put(n, guiSlot.setName(string4 + string3));
                    }
                }
            });
            GuiManager.getInstance().openInventory(player, guiInventory);
        });
        GuiMethods.closeGui(player);
        GuiManager.getInstance().openSign(player, guiSign);
    }

    static void openEntityLoreSign(Player player, int n, boolean bl) {
        GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
        if (guiInventory == null) {
            Messages.sendMessage(player, "exception.administrator");
            Messages.sendConsoleWarning("Old GUI is closed. Report this to the developer!");
            return;
        }
        GuiSlot guiSlot = guiInventory.getGuiSlot(n);
        GuiSign guiSign = new GuiSign(Lists.newArrayList((Object[])new String[]{"", "&a&l\u2191 \u2191 \u2191 \u2191", bl ? "&aAdd target" : "&cRemove target", "&eType on first line."})).setLine(0, "\u00a7f\u00a7o");
        guiSign.response(() -> {
            String string = ChatColor.stripColor((String)guiSign.getLines()[0]);
            if (Arrays.stream(EntityType.values()).anyMatch(entityType -> entityType.name().equalsIgnoreCase(string.replace(' ', '_')))) {
                player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
                GuiManager.getInstance().openInventory(player, guiInventory);
                Messages.sendMessage(player, "&f" + string + "&c is not a valid entity.");
                return;
            }
            if (!string.isEmpty()) {
                if (bl) {
                    guiInventory.changeItem(n, guiSlot.addLore(string + ""));
                } else {
                    guiInventory.changeItem(n, guiSlot.removeLore(string + ""));
                }
            } else {
                player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
            }
            GuiManager.getInstance().openInventory(player, guiInventory);
        });
        GuiMethods.closeGui(player);
        GuiManager.getInstance().openSign(player, guiSign);
    }

    static void changeTop(Player player, final String string) {
        GuiInventory guiInventory = GuiManager.getInstance().getGuiInventory(player);
        if (guiInventory == null) {
            Messages.sendConsoleWarning("Top GUI already closed");
            return;
        }
        player.playSound(player.getEyeLocation(), Sound.BLOCK_STONE_BUTTON_CLICK_ON, 1.0f, 1.0f);
        guiInventory.changeItems(false, (Map<Integer, GuiSlot>)new HashMap<Integer, GuiSlot>(){
            {
                this.put(4, GuiMethods.getTopItem(1, string));
                this.put(12, GuiMethods.getTopItem(2, string));
                this.put(14, GuiMethods.getTopItem(3, string));
                this.put(20, GuiMethods.getTopItem(4, string));
                this.put(22, GuiMethods.getTopItem(5, string));
                this.put(24, GuiMethods.getTopItem(6, string));
                this.put(28, GuiMethods.getTopItem(7, string));
                this.put(30, GuiMethods.getTopItem(8, string));
                this.put(32, GuiMethods.getTopItem(9, string));
                this.put(34, GuiMethods.getTopItem(10, string));
            }
        });
    }

    static GuiSlot getTopItem(int n, String string) {
        if (string.equals("KILLS")) {
            OfflinePlayer offlinePlayer = ScoreManager.getInstance().getTopKiller(n);
            if (offlinePlayer == null) {
                return new GuiSlot(Material.ZOMBIE_HEAD, "gui.scoreboard.empty");
            }
            List<String> list = MessageData.getMessageList("gui.scoreboard.kills-lore");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : list) {
                String string3 = string2.replace("%KILLS%", offlinePlayer.getStatistic(Statistic.MOB_KILLS) + "").replace("%DEATHS%", offlinePlayer.getStatistic(Statistic.DEATHS) + "").replace("%DAMAGE_DEAL%", offlinePlayer.getStatistic(Statistic.DAMAGE_DEALT) + "").replace("%KD_RATE%", offlinePlayer.getStatistic(Statistic.MOB_KILLS) / offlinePlayer.getStatistic(Statistic.DEATHS) + "").replace("%TIME_SINCE_DEATH%", offlinePlayer.getStatistic(Statistic.TIME_SINCE_DEATH) + "").replace("%JUMP%", offlinePlayer.getStatistic(Statistic.JUMP) + "");
                arrayList.add(string3);
            }
            return new GuiSlot().setPlayerHead(offlinePlayer).setLore(arrayList).setName(MessageData.getMessage("gui.scoreboard.player-format").replace("%POSITION%", n + "").replace("%NAME%", Objects.requireNonNull(offlinePlayer.getName())));
        }
        HighScore highScore = ScoreManager.getInstance().getTopGamemode(string, n);
        if (highScore == null) {
            return new GuiSlot(Material.ZOMBIE_HEAD, "gui.scoreboard.empty");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string4 : MessageData.getMessageList("gui.scoreboard.gamemode-lore")) {
            String string5 = string4.replace("%MEMBERS%", highScore.getMembers()).replace("%WAVE%", highScore.getWave() + "");
            arrayList.add(string5);
        }
        if (highScore.getMemberList().size() != 0) {
            return new GuiSlot().setPlayerHead(Bukkit.getOfflinePlayer((UUID)highScore.getMemberList().get(0))).setLore(arrayList).setName(MessageData.getMessage("gui.scoreboard.player-format").replace("%POSITION%", n + "").replace("%NAME%", highScore.getMembers()));
        }
        return new GuiSlot(Material.SKELETON_SKULL).setLore(arrayList).setName(MessageData.getMessage("gui.scoreboard.player-format").replace("%POSITION%", n + "").replace("%NAME%", highScore.getMembers()));
    }
}

