/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.gui;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.gui.GuiManager;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;

public class GuiSign {
    private static final int ACTION_INDEX = 9;
    private static final int SIGN_LINES = 4;
    private static final String NBT_FORMAT = "{\"text\":\"%s\"}";
    private static final String NBT_BLOCK_ID = "minecraft:sign";
    private final List<String> text;
    private String[] lines;
    private Runnable response;
    private Location position;
    private BlockData oldBlock;

    GuiSign(List<String> list) {
        Objects.requireNonNull(list, "text");
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, Messages.format(list.get(i)));
        }
        this.text = list;
    }

    public GuiSign response(Runnable runnable) {
        this.response = runnable;
        return this;
    }

    public GuiSign setLine(int n, String string) {
        this.text.set(n, string);
        return this;
    }

    public String[] getLines() {
        return this.lines;
    }

    public void onRun(String[] stringArray) {
        this.lines = stringArray;
        if (this.response != null) {
            GuiManager.getInstance().addRunnableQue(this.response);
        }
    }

    public void replaceOldBlock(Player player) {
        player.sendBlockChange(this.position, this.oldBlock);
    }

    public void open(Player player) {
        Objects.requireNonNull(player, "player");
        Location location = player.getLocation().clone();
        this.oldBlock = location.add(0.0, -5.0, 0.0).getBlock().getBlockData();
        this.position = location;
        player.sendBlockChange(this.position, Material.OAK_SIGN.createBlockData());
        PacketContainer packetContainer = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.OPEN_SIGN_EDITOR);
        PacketContainer packetContainer2 = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.TILE_ENTITY_DATA);
        packetContainer.getBlockPositionModifier().write(0, (Object)new BlockPosition(this.position.toVector()));
        NbtCompound nbtCompound = (NbtCompound)packetContainer2.getNbtModifier().read(0);
        IntStream.range(0, 4).forEach(n -> nbtCompound.put("Text" + (n + 1), this.text.size() > n ? String.format(NBT_FORMAT, this.text.get(n)) : " "));
        nbtCompound.put("x", this.position.getX());
        nbtCompound.put("y", this.position.getY());
        nbtCompound.put("z", this.position.getZ());
        nbtCompound.put("id", NBT_BLOCK_ID);
        packetContainer2.getBlockPositionModifier().write(0, (Object)new BlockPosition(this.position.toVector()));
        packetContainer2.getIntegers().write(0, (Object)9);
        packetContainer2.getNbtModifier().write(0, (Object)nbtCompound);
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer2);
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }
}

