/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.shops;

import NL.martijnpu.ChunkDefence.Main;
import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.TimeHandler;
import NL.martijnpu.ChunkDefence.data.ConfigData;
import NL.martijnpu.ChunkDefence.data.FileHandler;
import NL.martijnpu.ChunkDefence.data.MessageData;
import NL.martijnpu.ChunkDefence.players.Economy;
import NL.martijnpu.ChunkDefence.players.PlayerDataManager;
import NL.martijnpu.ChunkDefence.shops.FloatingText;
import NL.martijnpu.ChunkDefence.shops.ShopManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public abstract class Shop {
    protected double cost;
    protected final List<FloatingText> textList;
    protected final List<ArmorStand> displayEntities;
    final String path;
    protected Block shopLocation;
    private AreaEffectCloud displayCloud;

    protected Shop(String string) {
        this.path = string;
        this.cost = FileHandler.getInstance().getShopsConfig().getDouble(string + ".cost", 10.0);
        this.displayEntities = new ArrayList<ArmorStand>();
        this.textList = new ArrayList<FloatingText>();
        Location location = FileHandler.getLocationFromString(FileHandler.getInstance().getShopsConfig().getString(string + ".location", ""));
        if (location == null) {
            Messages.sendConsole("Unable to load shop " + string + ". Invalid location");
            throw new IllegalArgumentException();
        }
        this.shopLocation = location.getBlock();
    }

    protected Shop(Block block, double d, String string) {
        this.path = this.getFreePath(string);
        this.cost = d;
        this.displayEntities = new ArrayList<ArmorStand>();
        this.textList = new ArrayList<FloatingText>();
        this.shopLocation = block;
        FileHandler.getInstance().getShopsConfig().set(this.path + ".location", (Object)FileHandler.getStringFromLocation(block.getLocation()));
        FileHandler.getInstance().getShopsConfig().set(this.path + ".messages.1.text", (Object)"%NAME%");
        FileHandler.getInstance().getShopsConfig().set(this.path + ".messages.1.offset", (Object)"0 3 1.2");
        FileHandler.getInstance().getShopsConfig().set(this.path + ".messages.2.text", (Object)"&ePrice: &f%PRICE%");
        FileHandler.getInstance().getShopsConfig().set(this.path + ".messages.2.offset", (Object)"-0.5 1.3 1.8");
        FileHandler.getInstance().saveShopsConfig();
    }

    public abstract void buyItem(Player var1);

    public abstract boolean hasPermission(Player var1);

    public abstract void editShop(Player var1);

    public void setCost(double d) {
        this.cost = d;
    }

    Block getShopLocation() {
        return this.shopLocation;
    }

    public List<FloatingText> getTextList() {
        ArrayList<FloatingText> arrayList = new ArrayList<FloatingText>();
        this.textList.forEach(floatingText -> {
            arrayList.add(floatingText.copy());
            arrayList.add(floatingText.copy());
            arrayList.add(floatingText.copy());
        });
        return arrayList;
    }

    void remove() {
        if (this.displayCloud != null) {
            this.displayCloud.remove();
        }
        this.shopLocation.getRelative(BlockFace.UP).setType(Material.AIR);
        this.displayEntities.forEach(Entity::remove);
        FileHandler.getInstance().getShopsConfig().set(this.path, null);
        FileHandler.getInstance().saveShopsConfig();
    }

    void move(Block block) {
        if (this.displayCloud != null) {
            this.displayCloud.remove();
        }
        this.shopLocation.getRelative(BlockFace.UP).setType(Material.AIR);
        this.displayEntities.forEach(Entity::remove);
        this.shopLocation = block;
        FileHandler.getInstance().getShopsConfig().set(this.path + ".location", (Object)FileHandler.getStringFromLocation(this.shopLocation.getLocation()));
        FileHandler.getInstance().saveShopsConfig();
    }

    protected void setDisplay(String string) {
        this.displayCloud = (AreaEffectCloud)this.shopLocation.getWorld().spawnEntity(this.shopLocation.getLocation().clone().add(0.5, 1.0, 0.5), EntityType.AREA_EFFECT_CLOUD);
        this.displayCloud.setDuration(999999);
        this.displayCloud.setCustomNameVisible(true);
        this.displayCloud.setCustomName(Messages.format(FileHandler.getInstance().getShopsConfig().getString(this.path + ".display.name", string)));
        this.displayCloud.setParticle(Particle.BLOCK_CRACK, (Object)Material.AIR.createBlockData());
        this.displayCloud.setRadius(0.0f);
        this.displayCloud.getPersistentDataContainer().set(Main.getKeyBase(), PersistentDataType.INTEGER, (Object)ShopManager.getRandomEntityID());
    }

    protected boolean canBuy(Player player) {
        if (!this.hasPermission(player)) {
            Messages.sendMessage(player, "shop.buying.no-permission");
            return false;
        }
        long l = TimeHandler.getTime() - PlayerDataManager.getInstance().getUserData((UUID)player.getUniqueId()).lastShopBuy;
        if (l < (long)ConfigData.getInstance().getShopCooldown()) {
            Messages.sendMessage(player, MessageData.getMessage("shop.buying.cooldown").replace("%AMOUNT%", (long)ConfigData.getInstance().getShopCooldown() - l + 1L + ""));
            return false;
        }
        PlayerDataManager.getInstance().getUserData((UUID)player.getUniqueId()).lastShopBuy = TimeHandler.getTime();
        return true;
    }

    public void changeDisplayItem(@Nullable ItemStack itemStack) {
        FileHandler.getInstance().getShopsConfig().set(this.path + ".display.item", (Object)itemStack);
    }

    @Nonnull
    public ItemStack getDisplayItem(@Nullable ItemStack itemStack) {
        ItemStack itemStack2 = FileHandler.getInstance().getShopsConfig().getItemStack(this.path + ".display.item", itemStack);
        if (itemStack2 == null) {
            itemStack2 = new ItemStack(Material.GLASS_PANE);
        }
        return itemStack2;
    }

    public double getCost() {
        return this.cost;
    }

    protected void setItem(@Nullable ItemStack itemStack) {
        Object object;
        ItemStack itemStack2 = this.getDisplayItem(itemStack);
        if (itemStack2.equals((Object)new ItemStack(Material.GLASS_PANE))) {
            itemStack2 = new ItemStack(Material.GLASS);
        }
        ConfigurationSection configurationSection = itemStack2.getType().isBlock() ? FileHandler.getInstance().getShopsConfig().getConfigurationSection("stand.block") : (itemStack2.getType().getMaxDurability() >= 1 ? (((String)(object = itemStack2.getType().name().toLowerCase())).contains("sword") || ((String)object).contains("axe") || ((String)object).contains("hoe") || ((String)object).contains("shovel") || itemStack2.getType().equals((Object)Material.STICK) ? FileHandler.getInstance().getShopsConfig().getConfigurationSection("stand.sword") : (itemStack2.getType().equals((Object)Material.SHIELD) ? FileHandler.getInstance().getShopsConfig().getConfigurationSection("stand.shield") : (itemStack2.getType().equals((Object)Material.BOW) ? FileHandler.getInstance().getShopsConfig().getConfigurationSection("stand.bow") : (itemStack2.getType().equals((Object)Material.TRIDENT) ? FileHandler.getInstance().getShopsConfig().getConfigurationSection("stand.trident") : FileHandler.getInstance().getShopsConfig().getConfigurationSection("stand.armour"))))) : FileHandler.getInstance().getShopsConfig().getConfigurationSection("stand.item"));
        if (configurationSection == null) {
            Messages.sendConsoleWarning("Loading no display items for shop '" + this.path + "'. This is an error.");
            object = this.spawnArmorStand(new Vector(0.5, 0.0, 0.5));
            Objects.requireNonNull(object.getEquipment()).setItemInMainHand(itemStack2);
            object.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
            return;
        }
        for (String string : configurationSection.getKeys(false)) {
            Vector vector = FileHandler.getXYZFromString(configurationSection.getString(string + ".location"));
            Vector vector2 = FileHandler.getXYZFromString(configurationSection.getString(string + ".rotation"));
            if (vector == null) {
                vector = new Vector(0, 90, 0);
            }
            if (vector2 == null) {
                vector2 = new Vector(0, 2, 0);
            }
            ArmorStand armorStand = this.spawnArmorStand(vector);
            armorStand.setSmall(configurationSection.getBoolean(string + ".small", false));
            if (configurationSection.getBoolean(string + ".head", false)) {
                armorStand.setHeadPose(new EulerAngle(vector2.getX(), vector2.getY(), vector2.getZ()));
                Objects.requireNonNull(armorStand.getEquipment()).setHelmet(itemStack2);
                continue;
            }
            Objects.requireNonNull(armorStand.getEquipment()).setItemInMainHand(itemStack2);
            armorStand.setRightArmPose(new EulerAngle(vector2.getX(), vector2.getY(), vector2.getZ()));
        }
    }

    protected boolean hasPermission(Player player, String string, String string2) {
        return player.hasPermission("chunkdefence.shop.*") || player.hasPermission("chunkdefence.shop." + string + ".*") || player.hasPermission("chunkdefence.shop." + string + "." + string2);
    }

    protected boolean handleMoney(Player player) {
        if (player == null) {
            return false;
        }
        if (Economy.getBalance(player) < this.cost) {
            Messages.sendMessage(player, "shop.buying.not-enough");
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            return false;
        }
        if (player.getInventory().firstEmpty() == -1) {
            Messages.sendMessage(player, "shop.buying.no-space");
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            return false;
        }
        Economy.withdrawPlayer(player, this.cost);
        Messages.sendMessage(player, "shop.buying.success");
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        return true;
    }

    public void save() {
        FileHandler.getInstance().getShopsConfig().set(this.path + ".location", (Object)FileHandler.getStringFromLocation(this.shopLocation.getLocation()));
        FileHandler.getInstance().getShopsConfig().set(this.path + ".cost", (Object)this.cost);
        FileHandler.getInstance().saveShopsConfig();
    }

    private ArmorStand spawnArmorStand(Vector vector) {
        Location location = this.shopLocation.getLocation().clone().add(vector);
        ArmorStand armorStand = (ArmorStand)Objects.requireNonNull(location.getWorld()).spawnEntity(location, EntityType.ARMOR_STAND);
        armorStand.setGravity(false);
        armorStand.setArms(true);
        armorStand.setVisible(false);
        armorStand.setCustomNameVisible(false);
        armorStand.getPersistentDataContainer().set(Main.getKeyBase(), PersistentDataType.INTEGER, (Object)ShopManager.getRandomEntityID());
        this.displayEntities.add(armorStand);
        return armorStand;
    }

    protected void loadFloatingText() {
        this.textList.clear();
        ConfigurationSection configurationSection = FileHandler.getInstance().getShopsConfig().getConfigurationSection(this.path + ".messages");
        if (configurationSection == null) {
            this.save();
            return;
        }
        for (String string : configurationSection.getKeys(false)) {
            String string2 = Objects.requireNonNull(configurationSection.getString(string + ".text", "")).replace("%PRICE%", (this.cost % 1.0 == 0.0 ? (double)((int)this.cost) : this.cost) + "").replace("&0", "&7").replace("&8", "&7");
            Vector vector = FileHandler.getXYZFromString(configurationSection.getString(string + ".offset"));
            this.textList.add(new FloatingText(string2, vector != null ? vector : new Vector(0, 0, 2)));
        }
    }

    private String getFreePath(String string) {
        string = string.replaceAll("&[0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx]", "");
        string = "shop." + string + "_";
        int n = 1;
        while (FileHandler.getInstance().getShopsConfig().isSet(string + n)) {
            ++n;
        }
        return string + n;
    }
}

