/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.statistics;

import NL.martijnpu.ChunkDefence.Messages;
import NL.martijnpu.ChunkDefence.arenas.Arena;
import NL.martijnpu.ChunkDefence.data.FileHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;

public class HighScore {
    private String key;
    private Arena liveArena;
    private List<UUID> members;
    private String gamemode;
    private int wave;

    HighScore(String string, String string2) {
        ConfigurationSection configurationSection = FileHandler.getInstance().getScoresConfig().getConfigurationSection("highscores." + string + "." + string2);
        if (configurationSection == null) {
            throw new IllegalArgumentException("highscore for key '" + string2 + "' doesn't exist");
        }
        this.key = string2;
        this.liveArena = null;
        this.members = new ArrayList<UUID>();
        this.gamemode = string;
        this.wave = configurationSection.getInt("wave");
        List list = configurationSection.getStringList("members");
        list.stream().map(UUID::fromString).forEach(this.members::add);
    }

    HighScore(Arena arena) {
        this.key = null;
        this.liveArena = arena;
        this.members = arena.getArenaData().getMembers();
        this.gamemode = arena.getArenaData().getGamemode();
        this.wave = arena.getArenaData().getWave() - 1;
    }

    public List<UUID> getMemberList() {
        return this.members;
    }

    public String getMembers() {
        StringBuilder stringBuilder = new StringBuilder();
        for (UUID uUID : this.getMemberList()) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID);
            stringBuilder.append(offlinePlayer.getName() != null ? offlinePlayer.getName() + ", " : "Unknown, ");
        }
        if (stringBuilder.length() >= 2) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    public int getWave() {
        return this.wave;
    }

    void updateMembers(Arena arena) {
        if (this.liveArena == null) {
            this.liveArena = arena;
        }
        if (arena.getArenaData().getMembers().size() > 0) {
            this.members = arena.getArenaData().getMembers();
            Messages.sendConsoleDebug("Members updated to " + this.getMembers());
        } else {
            Messages.sendConsoleDebug("Tried to update members, size is 0");
        }
    }

    void clearArena(Arena arena) {
        if (this.liveArena == arena) {
            this.liveArena = null;
            Messages.sendConsoleDebug("Removed arena from score");
        }
        Messages.sendConsoleDebug("Checked score to remove live arena");
    }

    boolean updateScore(Arena arena) {
        if (!this.getMemberList().containsAll(arena.getArenaData().getMembers())) {
            return false;
        }
        if (this.liveArena == null) {
            this.liveArena = arena;
            this.members = arena.getArenaData().getMembers();
            this.gamemode = arena.getArenaData().getGamemode();
        }
        if (this.wave <= arena.getArenaData().getWave() - 1) {
            this.wave = arena.getArenaData().getWave() - 1;
        }
        Messages.sendConsoleDebug("Saved highscore for " + this.getMembers());
        this.save();
        return true;
    }

    private String getNewKey() {
        int n = 1;
        while (FileHandler.getInstance().getTrapsConfig().contains("highscores." + this.gamemode + "." + n)) {
            ++n;
        }
        return n + "";
    }

    private void save() {
        if (this.key == null) {
            this.key = this.getNewKey();
        }
        FileHandler.getInstance().getScoresConfig().set("highscores." + this.gamemode + "." + this.key + ".wave", (Object)this.wave);
        FileHandler.getInstance().getScoresConfig().set("highscores." + this.gamemode + "." + this.key + ".members", this.members.stream().map(UUID::toString).collect(Collectors.toList()));
        FileHandler.getInstance().saveScoresConfig();
    }

    public void remove() {
        if (this.key == null) {
            return;
        }
        FileHandler.getInstance().getScoresConfig().set("highscores." + this.gamemode + "." + this.key, null);
        FileHandler.getInstance().saveScoresConfig();
        Messages.sendConsoleDebug("Removed highscore. Trace: " + Arrays.toString(Thread.currentThread().getStackTrace()));
    }
}

