/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.ChunkDefence.traps;

import NL.martijnpu.ChunkDefence.traps.TrapBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public enum ParticleType {
    NONE,
    SPIRAL,
    FLOOR,
    SPREAD,
    SURROUND,
    CYLINDER,
    FIREFLY;


    void spawnParticle(Entity entity, TrapBase trapBase, List<Vector> list) {
        switch (this) {
            case SPREAD: {
                entity.getWorld().spawnParticle(trapBase.getParticle(), entity.getLocation(), trapBase.getParticleAmount(), (double)trapBase.getParticleSize(), (double)trapBase.getParticleSize(), (double)trapBase.getParticleSize(), (double)trapBase.getParticleSpeed());
                break;
            }
            case FLOOR: {
                entity.getWorld().spawnParticle(trapBase.getParticle(), entity.getLocation().clone().add(0.0, -0.2, 0.0), trapBase.getParticleAmount(), (double)trapBase.getParticleSize(), 0.0, (double)trapBase.getParticleSize(), (double)trapBase.getParticleSpeed());
                break;
            }
            default: {
                for (Vector vector : list) {
                    entity.getWorld().spawnParticle(trapBase.getParticle(), entity.getLocation().clone().add(vector), 1, 0.0, 0.0, 0.0, (double)trapBase.getParticleSpeed());
                }
            }
        }
    }

    List<Vector> calculateNextDelta(TrapBase trapBase) {
        ArrayList<Vector> arrayList = new ArrayList<Vector>();
        if (trapBase == null || Objects.requireNonNull(trapBase).getParticleAmount() <= 0) {
            return arrayList;
        }
        switch (this) {
            case SURROUND: {
                for (int i = 0; i < trapBase.getParticleAmount(); ++i) {
                    float[] fArray = this.calcSinCos(trapBase, i, false);
                    if ((double)fArray[0] < -0.3) continue;
                    if (i % 2 == 0) {
                        arrayList.add(new Vector(fArray[1], fArray[0], fArray[2]));
                        continue;
                    }
                    arrayList.add(new Vector(fArray[2], fArray[0], fArray[1]));
                }
                break;
            }
            case SPIRAL: {
                for (int i = 0; i < trapBase.getParticleAmount(); ++i) {
                    float[] fArray = this.calcSinCos(trapBase, i, false);
                    arrayList.add(new Vector(fArray[0], fArray[2], fArray[1]));
                }
                break;
            }
            case CYLINDER: {
                for (int i = 0; i < trapBase.getParticleAmount(); ++i) {
                    float[] fArray = this.calcSinCos(trapBase, i, true);
                    arrayList.add(new Vector((double)fArray[0], (double)fArray[2] - 0.2 / (double)trapBase.getParticleSize(), (double)fArray[1]));
                }
                break;
            }
            case FIREFLY: {
                for (int i = 0; i < trapBase.getParticleAmount(); ++i) {
                    float f = (float)Math.sin(Math.toRadians(trapBase.getParticlePeriod() * 2) + Math.PI * 2 / (double)trapBase.getParticleAmount() * (double)i) * trapBase.getParticleSize();
                    float f2 = (float)Math.sin(Math.toRadians(trapBase.getParticlePeriod() * 3) + Math.PI * 2 / (double)trapBase.getParticleAmount() * (double)i) * trapBase.getParticleSize();
                    float f3 = (float)Math.cos(Math.toRadians(trapBase.getParticlePeriod()) + Math.PI * 2 / (double)trapBase.getParticleAmount() * (double)i) * trapBase.getParticleSize();
                    arrayList.add(new Vector((double)f, (double)f2 + 0.1 / (double)trapBase.getParticleSize(), (double)f3));
                }
                break;
            }
        }
        return arrayList;
    }

    private float[] calcSinCos(TrapBase trapBase, int n, boolean bl) {
        float[] fArray = new float[]{(float)Math.sin(Math.toRadians(trapBase.getParticlePeriod()) + Math.PI * 2 / (double)trapBase.getParticleAmount() * (double)n) * trapBase.getParticleSize(), (float)Math.cos(Math.toRadians(trapBase.getParticlePeriod()) + Math.PI * 2 / (double)trapBase.getParticleAmount() * (double)n) * trapBase.getParticleSize(), !bl ? 0.0f : (float)Math.sin(Math.toRadians(trapBase.getParticlePeriod()) * (double)trapBase.getParticleSize() * 0.5 + (double)trapBase.getParticleSize() * 0.5)};
        return fArray;
    }
}

