/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.NPCNeedsRespawnEvent;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.event.CitizensPreReloadEvent;
import net.citizensnpcs.api.event.CommandSenderCreateNPCEvent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.EntityTargetNPCEvent;
import net.citizensnpcs.api.event.NPCCombustByBlockEvent;
import net.citizensnpcs.api.event.NPCCombustByEntityEvent;
import net.citizensnpcs.api.event.NPCCombustEvent;
import net.citizensnpcs.api.event.NPCDamageByBlockEvent;
import net.citizensnpcs.api.event.NPCDamageByEntityEvent;
import net.citizensnpcs.api.event.NPCDamageEntityEvent;
import net.citizensnpcs.api.event.NPCDamageEvent;
import net.citizensnpcs.api.event.NPCDeathEvent;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCKnockbackEvent;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCLinkToPlayerEvent;
import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.event.NPCSeenByPlayerEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.event.NPCVehicleDamageEvent;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.trait.trait.PlayerFilter;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinUpdateTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.ClickRedirectTrait;
import net.citizensnpcs.trait.CommandTrait;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.ShopTrait;
import net.citizensnpcs.trait.versioned.SnowmanTrait;
import net.citizensnpcs.util.ChunkCoord;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.world.ChunkEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class EventListen
implements Listener {
    private Listener chunkEventListener;
    private SkinUpdateTracker skinUpdateTracker;
    private final ListMultimap<ChunkCoord, NPC> toRespawn = ArrayListMultimap.create((int)64, (int)4);
    private static boolean SUPPORT_STOP_USE_ITEM = true;

    EventListen() {
        this.skinUpdateTracker = new SkinUpdateTracker();
        try {
            Class.forName("org.bukkit.event.world.EntitiesLoadEvent");
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onEntitiesLoad(EntitiesLoadEvent entitiesLoadEvent) {
                    EventListen.this.loadNPCs((ChunkEvent)entitiesLoadEvent);
                }

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onEntitiesUnload(EntitiesUnloadEvent entitiesUnloadEvent) {
                    ArrayList arrayList = Lists.newArrayList(CitizensAPI.getLocationLookup().getNearbyNPCs(entitiesUnloadEvent.getWorld(), new double[]{(double)(entitiesUnloadEvent.getChunk().getX() << 4) - 0.5, 0.0, (double)(entitiesUnloadEvent.getChunk().getZ() << 4) - 0.5}, new double[]{(double)(entitiesUnloadEvent.getChunk().getX() + 1 << 4) + 0.5, 256.0, (double)(entitiesUnloadEvent.getChunk().getZ() + 1 << 4) + 0.5}));
                    for (Entity entity : entitiesUnloadEvent.getEntities()) {
                        NPC nPC = CitizensAPI.getNPCRegistry().getNPC(entity);
                        if (nPC == null || nPC.getEntity() == null || arrayList.contains(nPC)) continue;
                        arrayList.add(nPC);
                    }
                    if (arrayList.isEmpty()) {
                        return;
                    }
                    EventListen.this.unloadNPCs((ChunkEvent)entitiesUnloadEvent, arrayList);
                }
            }, CitizensAPI.getPlugin());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class.forName("org.bukkit.event.entity.EntityTransformEvent");
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onEntityTransform(EntityTransformEvent entityTransformEvent) {
                    NPC nPC = CitizensAPI.getNPCRegistry().getNPC(entityTransformEvent.getEntity());
                    if (nPC == null) {
                        return;
                    }
                    if (nPC.isProtected()) {
                        entityTransformEvent.setCancelled(true);
                    }
                }
            }, CitizensAPI.getPlugin());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            this.registerKnockbackEvent(clazz);
        }
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz2 != null) {
            this.registerPushEvent(clazz2);
        }
    }

    private void checkCreationEvent(CommandSenderCreateNPCEvent commandSenderCreateNPCEvent) {
        int n;
        int n2;
        if (commandSenderCreateNPCEvent.getCreator().hasPermission("citizens.admin.avoid-limits")) {
            return;
        }
        int n3 = Settings.Setting.DEFAULT_NPC_LIMIT.asInt();
        for (n2 = n = Settings.Setting.MAX_NPC_LIMIT_CHECKS.asInt(); n2 >= 0; --n2) {
            if (!commandSenderCreateNPCEvent.getCreator().hasPermission("citizens.npc.limit." + n2)) continue;
            n3 = n2;
            break;
        }
        if (n3 < 0) {
            return;
        }
        n2 = 0;
        for (NPC nPC : CitizensAPI.getNPCRegistry()) {
            if (commandSenderCreateNPCEvent.getNPC().equals(nPC) || !nPC.hasTrait(Owner.class) || !nPC.getTraitNullable(Owner.class).isOwnedBy(commandSenderCreateNPCEvent.getCreator())) continue;
            ++n2;
        }
        int n4 = n2 + 1;
        if (n4 > n3) {
            commandSenderCreateNPCEvent.setCancelled(true);
            commandSenderCreateNPCEvent.setCancelReason(Messaging.tr("citizens.limits.over-npc-limit", n3));
        }
    }

    private Iterable<NPC> getAllNPCs() {
        return Iterables.filter((Iterable)Iterables.concat(CitizensAPI.getNPCRegistries()), (Predicate)Predicates.notNull());
    }

    void loadNPCs(ChunkEvent chunkEvent) {
        ChunkCoord chunkCoord = new ChunkCoord(chunkEvent.getChunk());
        Runnable runnable = () -> this.respawnAllFromCoord(chunkCoord, (Event)chunkEvent);
        if (Messaging.isDebugging() && Settings.Setting.DEBUG_CHUNK_LOADS.asBoolean() && this.toRespawn.containsKey((Object)chunkCoord)) {
            new Exception("CITIZENS CHUNK LOAD DEBUG " + chunkCoord).printStackTrace();
        }
        if (chunkEvent instanceof Cancellable) {
            runnable.run();
        } else {
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), runnable);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkLoad(ChunkLoadEvent chunkLoadEvent) {
        if (this.chunkEventListener != null) {
            return;
        }
        this.loadNPCs((ChunkEvent)chunkLoadEvent);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChunkUnload(ChunkUnloadEvent chunkUnloadEvent) {
        if (this.chunkEventListener != null) {
            return;
        }
        ArrayList arrayList = Lists.newArrayList(CitizensAPI.getLocationLookup().getNearbyNPCs(chunkUnloadEvent.getWorld(), new double[]{(double)(chunkUnloadEvent.getChunk().getX() << 4) - 0.5, 0.0, (double)(chunkUnloadEvent.getChunk().getZ() << 4) - 0.5}, new double[]{(double)(chunkUnloadEvent.getChunk().getX() + 1 << 4) + 0.5, 256.0, (double)(chunkUnloadEvent.getChunk().getZ() + 1 << 4) + 0.5}));
        for (Entity entity : chunkUnloadEvent.getChunk().getEntities()) {
            NPC nPC = CitizensAPI.getNPCRegistry().getNPC(entity);
            if (nPC == null || nPC.getEntity() == null || arrayList.contains(nPC)) continue;
            arrayList.add(nPC);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        this.unloadNPCs((ChunkEvent)chunkUnloadEvent, arrayList);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCitizensReload(CitizensPreReloadEvent citizensPreReloadEvent) {
        this.skinUpdateTracker.reset();
        this.toRespawn.clear();
    }

    @EventHandler(ignoreCancelled=true)
    public void onCommandSenderCreateNPC(CommandSenderCreateNPCEvent commandSenderCreateNPCEvent) {
        this.checkCreationEvent(commandSenderCreateNPCEvent);
    }

    @EventHandler
    public void onEntityBlockForm(EntityBlockFormEvent entityBlockFormEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC(entityBlockFormEvent.getEntity());
        if (nPC == null) {
            return;
        }
        if (nPC.getEntity() instanceof Snowman) {
            boolean bl = nPC.hasTrait(SnowmanTrait.class) ? nPC.getTraitNullable(SnowmanTrait.class).shouldFormSnow() : nPC.useMinecraftAI();
            entityBlockFormEvent.setCancelled(!bl);
        }
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent entityCombustEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC(entityCombustEvent.getEntity());
        if (nPC == null) {
            return;
        }
        entityCombustEvent.setCancelled(nPC.isProtected());
        if (entityCombustEvent instanceof EntityCombustByEntityEvent) {
            Bukkit.getPluginManager().callEvent((Event)new NPCCombustByEntityEvent((EntityCombustByEntityEvent)entityCombustEvent, nPC));
        } else if (entityCombustEvent instanceof EntityCombustByBlockEvent) {
            Bukkit.getPluginManager().callEvent((Event)new NPCCombustByBlockEvent((EntityCombustByBlockEvent)entityCombustEvent, nPC));
        } else {
            Bukkit.getPluginManager().callEvent((Event)new NPCCombustEvent(entityCombustEvent, nPC));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamage(EntityDamageEvent entityDamageEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC(entityDamageEvent.getEntity());
        if (nPC == null) {
            if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
                nPC = CitizensAPI.getNPCRegistry().getNPC(((EntityDamageByEntityEvent)entityDamageEvent).getDamager());
                if (nPC == null) {
                    return;
                }
                entityDamageEvent.setCancelled(nPC.data().get(NPC.Metadata.DAMAGE_OTHERS, Boolean.valueOf(true)) == false);
                NPCDamageEntityEvent nPCDamageEntityEvent = new NPCDamageEntityEvent(nPC, (EntityDamageByEntityEvent)entityDamageEvent);
                Bukkit.getPluginManager().callEvent((Event)nPCDamageEntityEvent);
            }
            return;
        }
        entityDamageEvent.setCancelled(nPC.isProtected());
        if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
            NPCDamageByEntityEvent nPCDamageByEntityEvent = new NPCDamageByEntityEvent(nPC, (EntityDamageByEntityEvent)entityDamageEvent);
            Bukkit.getPluginManager().callEvent((Event)nPCDamageByEntityEvent);
            if (!nPCDamageByEntityEvent.isCancelled() || !(nPCDamageByEntityEvent.getDamager() instanceof Player)) {
                return;
            }
            Player player = (Player)nPCDamageByEntityEvent.getDamager();
            if (nPC.hasTrait(ClickRedirectTrait.class) && (nPC = nPC.getTraitNullable(ClickRedirectTrait.class).getRedirectNPC()) == null) {
                return;
            }
            NPCLeftClickEvent nPCLeftClickEvent = new NPCLeftClickEvent(nPC, player);
            Bukkit.getPluginManager().callEvent((Event)nPCLeftClickEvent);
            if (nPC.hasTrait(CommandTrait.class)) {
                nPC.getTraitNullable(CommandTrait.class).dispatch(player, CommandTrait.Hand.LEFT);
            }
        } else if (entityDamageEvent instanceof EntityDamageByBlockEvent) {
            Bukkit.getPluginManager().callEvent((Event)new NPCDamageByBlockEvent(nPC, (EntityDamageByBlockEvent)entityDamageEvent));
        } else {
            Bukkit.getPluginManager().callEvent((Event)new NPCDamageEvent(nPC, entityDamageEvent));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent entityDeathEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC((Entity)entityDeathEvent.getEntity());
        if (nPC == null) {
            return;
        }
        if (!nPC.data().get(NPC.Metadata.DROPS_ITEMS, Boolean.valueOf(false)).booleanValue()) {
            entityDeathEvent.getDrops().clear();
        }
        Location location = nPC.getStoredLocation();
        Bukkit.getPluginManager().callEvent((Event)new NPCDeathEvent(nPC, entityDeathEvent));
        nPC.despawn(DespawnReason.DEATH);
        int n = nPC.data().get(NPC.Metadata.RESPAWN_DELAY, Integer.valueOf(-1));
        if (n < 0) {
            return;
        }
        int n2 = entityDeathEvent.getEntity() instanceof LivingEntity ? 20 : 2;
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            if (!nPC.isSpawned() && nPC.getOwningRegistry().getByUniqueId(nPC.getUniqueId()) == nPC) {
                nPC.spawn(location, SpawnReason.TIMED_RESPAWN);
            }
        }, (long)(n + n2));
    }

    @EventHandler
    public void onEntityPortal(EntityPortalEvent entityPortalEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC(entityPortalEvent.getEntity());
        if (nPC == null || nPC.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        entityPortalEvent.setCancelled(true);
        nPC.despawn(DespawnReason.PENDING_RESPAWN);
        entityPortalEvent.getTo().getChunk();
        nPC.spawn(entityPortalEvent.getTo(), SpawnReason.RESPAWN);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntitySpawn(CreatureSpawnEvent creatureSpawnEvent) {
        if (creatureSpawnEvent.isCancelled() && CitizensAPI.getNPCRegistry().isNPC((Entity)creatureSpawnEvent.getEntity())) {
            creatureSpawnEvent.setCancelled(false);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityTame(EntityTameEvent entityTameEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC((Entity)entityTameEvent.getEntity());
        if (nPC == null || !nPC.isProtected()) {
            return;
        }
        entityTameEvent.setCancelled(true);
    }

    @EventHandler
    public void onEntityTarget(EntityTargetEvent entityTargetEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC(entityTargetEvent.getTarget());
        if (nPC == null) {
            return;
        }
        entityTargetEvent.setCancelled(nPC.data().get(NPC.Metadata.TARGETABLE, Boolean.valueOf(!nPC.isProtected())) == false);
        Bukkit.getPluginManager().callEvent((Event)new EntityTargetNPCEvent(entityTargetEvent, nPC));
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemDespawn(ItemDespawnEvent itemDespawnEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC((Entity)itemDespawnEvent.getEntity());
        if (nPC == null) {
            return;
        }
        itemDespawnEvent.setCancelled(true);
    }

    @EventHandler
    public void onNavigationBegin(NavigationBeginEvent navigationBeginEvent) {
        this.skinUpdateTracker.onNPCNavigationBegin(navigationBeginEvent.getNPC());
    }

    @EventHandler
    public void onNavigationComplete(NavigationCompleteEvent navigationCompleteEvent) {
        this.skinUpdateTracker.onNPCNavigationComplete(navigationCompleteEvent.getNPC());
    }

    @EventHandler
    public void onNeedsRespawn(NPCNeedsRespawnEvent nPCNeedsRespawnEvent) {
        ChunkCoord chunkCoord = new ChunkCoord(nPCNeedsRespawnEvent.getSpawnLocation());
        if (this.toRespawn.containsEntry((Object)chunkCoord, (Object)nPCNeedsRespawnEvent.getNPC())) {
            return;
        }
        Messaging.debug("Stored", nPCNeedsRespawnEvent.getNPC(), "for respawn from NPCNeedsRespawnEvent");
        this.toRespawn.put((Object)chunkCoord, (Object)nPCNeedsRespawnEvent.getNPC());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNPCDespawn(NPCDespawnEvent nPCDespawnEvent) {
        if (nPCDespawnEvent.getReason() == DespawnReason.PLUGIN || nPCDespawnEvent.getReason() == DespawnReason.REMOVAL || nPCDespawnEvent.getReason() == DespawnReason.RELOAD) {
            Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Preventing further respawns of", (Object)nPCDespawnEvent.getNPC(), new Object[]{"due to DespawnReason." + (Object)((Object)nPCDespawnEvent.getReason())}));
            this.toRespawn.values().remove(nPCDespawnEvent.getNPC());
        } else {
            Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Removing", (Object)nPCDespawnEvent.getNPC(), new Object[]{"from skin tracker due to DespawnReason." + nPCDespawnEvent.getReason().name()}));
        }
        this.skinUpdateTracker.onNPCDespawn(nPCDespawnEvent.getNPC());
    }

    @EventHandler
    public void onNPCKnockback(NPCKnockbackEvent nPCKnockbackEvent) {
        nPCKnockbackEvent.setCancelled(nPCKnockbackEvent.getNPC().isProtected());
        if (nPCKnockbackEvent.getNPC().data().has(NPC.Metadata.KNOCKBACK)) {
            nPCKnockbackEvent.setCancelled(nPCKnockbackEvent.getNPC().data().get(NPC.Metadata.KNOCKBACK, Boolean.valueOf(true)) == false);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onNPCLinkToPlayer(NPCLinkToPlayerEvent nPCLinkToPlayerEvent) {
        Object object;
        NPC nPC = nPCLinkToPlayerEvent.getNPC();
        if (nPC.getEntity() instanceof SkinnableEntity) {
            object = (SkinnableEntity)nPC.getEntity();
            if (object.getSkinTracker().getSkin() != null) {
                object.getSkinTracker().getSkin().apply((SkinnableEntity)object);
            }
            this.onNPCPlayerLinkToPlayer(nPCLinkToPlayerEvent);
        }
        if (nPC.data().has(NPC.Metadata.HOLOGRAM_RENDERER)) {
            object = (HologramTrait.HologramRenderer)nPC.data().get(NPC.Metadata.HOLOGRAM_RENDERER);
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> EventListen.lambda$onNPCLinkToPlayer$4((HologramTrait.HologramRenderer)object, nPC, nPCLinkToPlayerEvent), 2L);
        }
    }

    private void onNPCPlayerLinkToPlayer(NPCLinkToPlayerEvent nPCLinkToPlayerEvent) {
        Entity entity = nPCLinkToPlayerEvent.getNPC().getEntity();
        boolean bl = nPCLinkToPlayerEvent.getNPC().data().get(NPC.Metadata.RESET_YAW_ON_SPAWN, Boolean.valueOf(Settings.Setting.RESET_YAW_ON_SPAWN.asBoolean()));
        boolean bl2 = NMS.sendTabListAdd(nPCLinkToPlayerEvent.getPlayer(), (Player)entity);
        if (!bl2 || !nPCLinkToPlayerEvent.getNPC().shouldRemoveFromTabList()) {
            NMS.sendPositionUpdate(entity, (Collection<Player>)ImmutableList.of((Object)nPCLinkToPlayerEvent.getPlayer()), false, null, null, Float.valueOf(NMS.getHeadYaw(entity)));
            if (bl) {
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> PlayerAnimation.ARM_SWING.play((Player)entity, nPCLinkToPlayerEvent.getPlayer()));
            }
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            if (!entity.isValid() || !nPCLinkToPlayerEvent.getPlayer().isValid()) {
                return;
            }
            NMS.sendTabListRemove(nPCLinkToPlayerEvent.getPlayer(), (Player)entity);
            NMS.sendPositionUpdate(entity, (Collection<Player>)ImmutableList.of((Object)nPCLinkToPlayerEvent.getPlayer()), false, null, null, Float.valueOf(NMS.getHeadYaw(entity)));
            if (bl) {
                PlayerAnimation.ARM_SWING.play((Player)entity, nPCLinkToPlayerEvent.getPlayer());
            }
        }, (long)Settings.Setting.TABLIST_REMOVE_PACKET_DELAY.asTicks());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNPCRemove(NPCRemoveEvent nPCRemoveEvent) {
        this.toRespawn.values().remove(nPCRemoveEvent.getNPC());
    }

    @EventHandler(ignoreCancelled=true)
    public void onNPCSeenByPlayer(NPCSeenByPlayerEvent nPCSeenByPlayerEvent) {
        ClickRedirectTrait clickRedirectTrait;
        NPC nPC = nPCSeenByPlayerEvent.getNPC();
        PlayerFilter playerFilter = nPC.getTraitNullable(PlayerFilter.class);
        if (playerFilter != null) {
            nPCSeenByPlayerEvent.setCancelled(playerFilter.onSeenByPlayer(nPCSeenByPlayerEvent.getPlayer()));
        }
        if ((clickRedirectTrait = nPC.getTraitNullable(ClickRedirectTrait.class)) != null) {
            nPC = clickRedirectTrait.getRedirectNPC();
        }
        if ((playerFilter = nPC.getTraitNullable(PlayerFilter.class)) != null) {
            nPCSeenByPlayerEvent.setCancelled(playerFilter.onSeenByPlayer(nPCSeenByPlayerEvent.getPlayer()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNPCSpawn(NPCSpawnEvent nPCSpawnEvent) {
        this.skinUpdateTracker.onNPCSpawn(nPCSpawnEvent.getNPC());
        Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Removing respawns of", (Object)nPCSpawnEvent.getNPC(), new Object[]{"due to SpawnReason." + (Object)((Object)nPCSpawnEvent.getReason())}));
        this.toRespawn.values().remove(nPCSpawnEvent.getNPC());
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent playerChangedWorldEvent) {
        this.skinUpdateTracker.removePlayer(playerChangedWorldEvent.getPlayer().getUniqueId());
        this.skinUpdateTracker.updatePlayer(playerChangedWorldEvent.getPlayer(), 20L, true);
        if (CitizensAPI.getNPCRegistry().getNPC((Entity)playerChangedWorldEvent.getPlayer()) == null) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            NMS.replaceTracker((Entity)playerChangedWorldEvent.getPlayer());
            NMS.removeFromServerPlayerList(playerChangedWorldEvent.getPlayer());
        }, 1L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCreateNPC(PlayerCreateNPCEvent playerCreateNPCEvent) {
        this.checkCreationEvent(playerCreateNPCEvent);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent playerDeathEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC((Entity)playerDeathEvent.getEntity());
        if (nPC == null) {
            return;
        }
        if (nPC.requiresNameHologram() && playerDeathEvent.getDeathMessage() != null) {
            playerDeathEvent.setDeathMessage(playerDeathEvent.getDeathMessage().replace(playerDeathEvent.getEntity().getName(), nPC.getFullName()));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerFish(PlayerFishEvent playerFishEvent) {
        if (CitizensAPI.getNPCRegistry().isNPC(playerFishEvent.getCaught()) && CitizensAPI.getNPCRegistry().getNPC(playerFishEvent.getCaught()).isProtected()) {
            playerFishEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent playerInteractEntityEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC(playerInteractEntityEvent.getRightClicked());
        if (nPC == null || Util.isOffHand(playerInteractEntityEvent)) {
            return;
        }
        ClickRedirectTrait clickRedirectTrait = nPC.getTraitNullable(ClickRedirectTrait.class);
        if (clickRedirectTrait != null && (nPC = clickRedirectTrait.getRedirectNPC()) == null) {
            return;
        }
        Player player = playerInteractEntityEvent.getPlayer();
        NPCRightClickEvent nPCRightClickEvent = new NPCRightClickEvent(nPC, player);
        if (playerInteractEntityEvent.getPlayer().getItemInHand().getType() == Material.NAME_TAG) {
            nPCRightClickEvent.setCancelled(nPC.isProtected());
        }
        Bukkit.getPluginManager().callEvent((Event)nPCRightClickEvent);
        if (nPCRightClickEvent.isCancelled()) {
            playerInteractEntityEvent.setCancelled(true);
            return;
        }
        if (nPC.hasTrait(CommandTrait.class)) {
            nPC.getTraitNullable(CommandTrait.class).dispatch(player, CommandTrait.Hand.RIGHT);
            nPCRightClickEvent.setDelayedCancellation(true);
        }
        if (nPC.hasTrait(ShopTrait.class)) {
            nPC.getTraitNullable(ShopTrait.class).onRightClick(player);
            nPCRightClickEvent.setDelayedCancellation(true);
        }
        if (nPCRightClickEvent.isDelayedCancellation()) {
            playerInteractEntityEvent.setCancelled(true);
        }
        if (playerInteractEntityEvent.isCancelled() && SUPPORT_STOP_USE_ITEM) {
            try {
                PlayerAnimation.STOP_USE_ITEM.play(player);
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> PlayerAnimation.STOP_USE_ITEM.play(player));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                SUPPORT_STOP_USE_ITEM = false;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
        this.skinUpdateTracker.updatePlayer(playerJoinEvent.getPlayer(), Settings.Setting.INITIAL_PLAYER_JOIN_SKIN_PACKET_DELAY.asTicks(), true);
        CitizensAPI.getLocationLookup().onJoin(playerJoinEvent);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerLeashEntity(PlayerLeashEntityEvent playerLeashEntityEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC(playerLeashEntityEvent.getEntity());
        if (nPC == null) {
            return;
        }
        boolean bl = nPC.isProtected();
        if (nPC.data().get(NPC.Metadata.LEASH_PROTECTED, Boolean.valueOf(bl)).booleanValue()) {
            playerLeashEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent playerMoveEvent) {
        this.skinUpdateTracker.onPlayerMove(playerMoveEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        NPC nPC;
        Editor.leave(playerQuitEvent.getPlayer());
        if (playerQuitEvent.getPlayer().isInsideVehicle() && (nPC = CitizensAPI.getNPCRegistry().getNPC(playerQuitEvent.getPlayer().getVehicle())) != null) {
            playerQuitEvent.getPlayer().leaveVehicle();
        }
        this.skinUpdateTracker.removePlayer(playerQuitEvent.getPlayer().getUniqueId());
        CitizensAPI.getLocationLookup().onQuit(playerQuitEvent);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent playerRespawnEvent) {
        this.skinUpdateTracker.updatePlayer(playerRespawnEvent.getPlayer(), 15L, true);
    }

    @EventHandler
    public void onPlayerShearEntityEvent(PlayerShearEntityEvent playerShearEntityEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC(playerShearEntityEvent.getEntity());
        if (nPC == null) {
            return;
        }
        if (nPC.isProtected()) {
            playerShearEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent playerTeleportEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC((Entity)playerTeleportEvent.getPlayer());
        if (playerTeleportEvent.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN && nPC != null && !nPC.data().has("citizens-force-teleporting") && Settings.Setting.PLAYER_TELEPORT_DELAY.asTicks() > 0) {
            playerTeleportEvent.setCancelled(true);
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                nPC.data().set("citizens-force-teleporting", (Object)true);
                playerTeleportEvent.getPlayer().teleport(playerTeleportEvent.getTo());
                nPC.data().remove("citizens-force-teleporting");
            }, (long)Settings.Setting.PLAYER_TELEPORT_DELAY.asTicks());
        }
        this.skinUpdateTracker.updatePlayer(playerTeleportEvent.getPlayer(), 15L, true);
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent pluginDisableEvent) {
        PluginDescriptionFile pluginDescriptionFile = pluginDisableEvent.getPlugin().getDescription();
        for (String string : Iterables.concat((Iterable)pluginDescriptionFile.getDepend(), (Iterable)pluginDescriptionFile.getSoftDepend())) {
            if (!string.equalsIgnoreCase("citizens") || !CitizensAPI.hasImplementation()) continue;
            ((Citizens)CitizensAPI.getPlugin()).onDependentPluginDisable();
            break;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPotionSplashEvent(PotionSplashEvent potionSplashEvent) {
        for (LivingEntity livingEntity : potionSplashEvent.getAffectedEntities()) {
            NPC nPC = CitizensAPI.getNPCRegistry().getNPC((Entity)livingEntity);
            if (nPC == null || !nPC.isProtected()) continue;
            potionSplashEvent.setIntensity(livingEntity, 0.0);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectileHit(final ProjectileHitEvent projectileHitEvent) {
        if (!(projectileHitEvent.getEntity() instanceof FishHook)) {
            return;
        }
        NMS.removeHookIfNecessary((FishHook)projectileHitEvent.getEntity());
        new BukkitRunnable(){
            int n = 0;

            public void run() {
                if (this.n++ > 5 || !CitizensAPI.hasImplementation()) {
                    this.cancel();
                    return;
                }
                NMS.removeHookIfNecessary((FishHook)projectileHitEvent.getEntity());
            }
        }.runTaskTimer(CitizensAPI.getPlugin(), 0L, 1L);
    }

    @EventHandler
    public void onVehicleDamage(VehicleDamageEvent vehicleDamageEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC((Entity)vehicleDamageEvent.getVehicle());
        if (nPC == null) {
            return;
        }
        vehicleDamageEvent.setCancelled(nPC.isProtected());
        NPCVehicleDamageEvent nPCVehicleDamageEvent = new NPCVehicleDamageEvent(nPC, vehicleDamageEvent);
        Bukkit.getPluginManager().callEvent((Event)nPCVehicleDamageEvent);
        if (!nPCVehicleDamageEvent.isCancelled() || !(nPCVehicleDamageEvent.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)nPCVehicleDamageEvent.getDamager();
        NPCLeftClickEvent nPCLeftClickEvent = new NPCLeftClickEvent(nPC, player);
        Bukkit.getPluginManager().callEvent((Event)nPCLeftClickEvent);
        if (nPC.hasTrait(CommandTrait.class)) {
            nPC.getTraitNullable(CommandTrait.class).dispatch(player, CommandTrait.Hand.LEFT);
        }
    }

    @EventHandler
    public void onVehicleDestroy(VehicleDestroyEvent vehicleDestroyEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC((Entity)vehicleDestroyEvent.getVehicle());
        if (nPC == null) {
            return;
        }
        vehicleDestroyEvent.setCancelled(nPC.isProtected());
    }

    @EventHandler(ignoreCancelled=true)
    public void onVehicleEnter(VehicleEnterEvent vehicleEnterEvent) {
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC((Entity)vehicleEnterEvent.getVehicle());
        NPC nPC2 = CitizensAPI.getNPCRegistry().getNPC(vehicleEnterEvent.getEntered());
        if (nPC == null) {
            if (nPC2 != null && nPC2.isProtected() && (vehicleEnterEvent.getVehicle().getType().name().contains("BOAT") || vehicleEnterEvent.getVehicle() instanceof Minecart)) {
                vehicleEnterEvent.setCancelled(true);
            }
            return;
        }
        if (nPC2 != null || !(nPC instanceof Vehicle)) {
            return;
        }
        if (!nPC.hasTrait(Controllable.class) || !nPC.getTraitNullable(Controllable.class).isEnabled()) {
            vehicleEnterEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onWorldLoad(WorldLoadEvent worldLoadEvent) {
        for (ChunkCoord chunkCoord : this.toRespawn.keySet()) {
            if (!chunkCoord.worldUUID.equals(worldLoadEvent.getWorld().getUID()) || !worldLoadEvent.getWorld().isChunkLoaded(chunkCoord.x, chunkCoord.z)) continue;
            this.respawnAllFromCoord(chunkCoord, (Event)worldLoadEvent);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent worldUnloadEvent) {
        for (NPC nPC : this.getAllNPCs()) {
            if (nPC == null || !nPC.isSpawned() || !nPC.getEntity().getWorld().equals((Object)worldUnloadEvent.getWorld())) continue;
            boolean bl = nPC.despawn(DespawnReason.WORLD_UNLOAD);
            if (worldUnloadEvent.isCancelled() || !bl) {
                for (ChunkCoord chunkCoord : this.toRespawn.keySet()) {
                    if (!worldUnloadEvent.getWorld().getUID().equals(chunkCoord.worldUUID)) continue;
                    this.respawnAllFromCoord(chunkCoord, (Event)worldUnloadEvent);
                }
                worldUnloadEvent.setCancelled(true);
                return;
            }
            if (!nPC.isSpawned()) continue;
            this.toRespawn.put((Object)new ChunkCoord(nPC.getEntity().getLocation()), (Object)nPC);
            Messaging.debug("Despawned", nPC, "due to world unload at", worldUnloadEvent.getWorld().getName());
        }
        CitizensAPI.getLocationLookup().onWorldUnload(worldUnloadEvent);
    }

    private void registerKnockbackEvent(Class<?> clazz) {
        try {
            HandlerList handlerList = (HandlerList)clazz.getMethod("getHandlerList", new Class[0]).invoke(null, new Object[0]);
            Method method = clazz.getMethod("getEntity", new Class[0]);
            Method method2 = clazz.getMethod("getHitBy", new Class[0]);
            Method method3 = clazz.getMethod("getKnockbackStrength", new Class[0]);
            Method method4 = clazz.getMethod("getAcceleration", new Class[0]);
            handlerList.register(new RegisteredListener(new Listener(){}, (listener, event) -> {
                try {
                    if (event.getClass() != clazz) {
                        return;
                    }
                    Entity entity = (Entity)method.invoke((Object)event, new Object[0]);
                    if (!(entity instanceof NPCHolder)) {
                        return;
                    }
                    NPC nPC = ((NPCHolder)entity).getNPC();
                    Entity entity2 = (Entity)method2.invoke((Object)event, new Object[0]);
                    float f = ((Float)method3.invoke((Object)event, new Object[0])).floatValue();
                    Vector vector = (Vector)method4.invoke((Object)event, new Object[0]);
                    NPCKnockbackEvent nPCKnockbackEvent = new NPCKnockbackEvent(nPC, f, vector, entity2);
                    Bukkit.getPluginManager().callEvent((Event)nPCKnockbackEvent);
                    ((Cancellable)event).setCancelled(nPCKnockbackEvent.isCancelled());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }, EventPriority.NORMAL, CitizensAPI.getPlugin(), true));
        }
        catch (Throwable throwable) {
            Messaging.severe("Error registering knockback event forwarder");
            throwable.printStackTrace();
        }
    }

    private void registerPushEvent(Class<?> clazz) {
        try {
            HandlerList handlerList = (HandlerList)clazz.getMethod("getHandlerList", new Class[0]).invoke(null, new Object[0]);
            Method method = clazz.getMethod("getEntity", new Class[0]);
            Method method2 = clazz.getMethod("getPushedBy", new Class[0]);
            Method method3 = clazz.getMethod("getAcceleration", new Class[0]);
            handlerList.register(new RegisteredListener(new Listener(){}, (listener, event) -> {
                if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0 || event.getClass() != clazz) {
                    return;
                }
                try {
                    Entity entity = (Entity)method.invoke((Object)event, new Object[0]);
                    if (!(entity instanceof NPCHolder)) {
                        return;
                    }
                    NPC nPC = ((NPCHolder)entity).getNPC();
                    Entity entity2 = (Entity)method2.invoke((Object)event, new Object[0]);
                    Vector vector = (Vector)method3.invoke((Object)event, new Object[0]);
                    NPCPushEvent nPCPushEvent = new NPCPushEvent(nPC, vector, entity2);
                    if (entity2 == null && !nPC.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!nPC.isProtected())).booleanValue()) {
                        nPCPushEvent.setCancelled(true);
                    }
                    Bukkit.getPluginManager().callEvent((Event)nPCPushEvent);
                    ((Cancellable)event).setCancelled(nPCPushEvent.isCancelled());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }, EventPriority.NORMAL, CitizensAPI.getPlugin(), true));
        }
        catch (Throwable throwable) {
            Messaging.severe("Error registering push event forwarder");
            throwable.printStackTrace();
        }
    }

    private void respawnAllFromCoord(ChunkCoord chunkCoord, Event event) {
        ArrayList arrayList = Lists.newArrayList((Iterable)this.toRespawn.get((Object)chunkCoord));
        if (arrayList.size() > 0) {
            Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Respawning all NPCs at", (Object)chunkCoord, new Object[]{"due to", event, "at", chunkCoord}));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            NPC nPC = (NPC)arrayList.get(i);
            if (nPC.getOwningRegistry().getById(nPC.getId()) != nPC) {
                Messaging.idebug(() -> "Prevented deregistered NPC from respawning " + nPC);
                continue;
            }
            if (nPC.isSpawned()) {
                Messaging.idebug(() -> "Can't respawn NPC " + nPC + ": already spawned");
                continue;
            }
            boolean bl = this.spawn(nPC);
            if (!bl) {
                arrayList.remove(i--);
                Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Couldn't respawn", (Object)nPC, new Object[]{"during", event, "at", chunkCoord}));
                continue;
            }
            Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Spawned", (Object)nPC, new Object[]{"during", event, "at", chunkCoord}));
        }
        for (NPC nPC : arrayList) {
            this.toRespawn.remove((Object)chunkCoord, (Object)nPC);
        }
    }

    private boolean spawn(NPC nPC) {
        Location location = nPC.getOrAddTrait(CurrentLocation.class).getLocation();
        if (location == null) {
            Messaging.idebug(() -> "Couldn't find a spawn location for despawned NPC " + nPC);
            return false;
        }
        return nPC.spawn(location, SpawnReason.CHUNK_LOAD);
    }

    private void unloadNPCs(ChunkEvent chunkEvent, List<NPC> list) {
        ChunkCoord chunkCoord = new ChunkCoord(chunkEvent.getChunk());
        boolean bl = false;
        for (NPC nPC : list) {
            if (this.toRespawn.containsValue((Object)nPC)) continue;
            if (!nPC.despawn(DespawnReason.CHUNK_UNLOAD)) {
                if (!(chunkEvent instanceof Cancellable)) {
                    Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Reloading chunk because", (Object)nPC, new Object[]{"couldn't despawn"}));
                    bl = true;
                    this.toRespawn.put((Object)chunkCoord, (Object)nPC);
                    continue;
                }
                ((Cancellable)chunkEvent).setCancelled(true);
                Messaging.idebug(() -> "Cancelled chunk unload at " + chunkCoord);
                this.respawnAllFromCoord(chunkCoord, (Event)chunkEvent);
                return;
            }
            this.toRespawn.put((Object)chunkCoord, (Object)nPC);
            Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Despawned", (Object)nPC, new Object[]{"due to chunk unload at", chunkCoord}));
        }
        if (Messaging.isDebugging() && Settings.Setting.DEBUG_CHUNK_LOADS.asBoolean()) {
            new Exception("CITIZENS CHUNK UNLOAD DEBUG " + chunkCoord).printStackTrace();
        }
        if (bl) {
            Messaging.idebug(() -> Joiner.on((char)' ').join((Object)"Loading chunk in 10 ticks due to forced chunk load at", (Object)chunkCoord, new Object[0]));
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                if (!chunkEvent.getChunk().isLoaded()) {
                    chunkEvent.getChunk().load();
                }
            }, 10L);
        }
    }

    private static /* synthetic */ void lambda$onNPCLinkToPlayer$4(HologramTrait.HologramRenderer hologramRenderer, NPC nPC, NPCLinkToPlayerEvent nPCLinkToPlayerEvent) {
        hologramRenderer.onSeenByPlayer(nPC, nPCLinkToPlayerEvent.getPlayer());
    }
}

