/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api;

import ch.ethz.globis.phtree.PhTreeF;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class LocationLookup
extends BukkitRunnable {
    private final Map<String, PerPlayerMetadata<?>> metadata = Maps.newHashMap();
    private Future<Map<UUID, PhTreeF<NPC>>> npcFuture = null;
    private Map<UUID, PhTreeF<NPC>> npcWorlds = Maps.newHashMap();
    private Future<Map<UUID, PhTreeF<Player>>> playerFuture = null;
    private final NPCRegistry sourceRegistry;
    private Map<UUID, PhTreeF<Player>> worlds = Maps.newHashMap();
    private static boolean SUPPORTS_ENTITY_CANSEE = true;

    public LocationLookup() {
        this(CitizensAPI.getNPCRegistry());
    }

    public LocationLookup(NPCRegistry nPCRegistry) {
        this.sourceRegistry = nPCRegistry;
    }

    public PerPlayerMetadata<?> getMetadata(String string) {
        return this.metadata.get(string);
    }

    public Iterable<NPC> getNearbyNPCs(Location location, double d) {
        PhTreeF<NPC> phTreeF = this.npcWorlds.get(location.getWorld().getUID());
        if (phTreeF == null) {
            return Collections.emptyList();
        }
        return () -> phTreeF.rangeQuery(d, new double[]{location.getX(), location.getY(), location.getZ()});
    }

    public Iterable<NPC> getNearbyNPCs(NPC nPC) {
        return this.getNearbyNPCs(nPC.getStoredLocation(), nPC.data().get(NPC.Metadata.TRACKING_RANGE, Integer.valueOf(64)).intValue());
    }

    public Iterable<NPC> getNearbyNPCs(World world, double[] dArray, double[] dArray2) {
        PhTreeF<NPC> phTreeF = this.npcWorlds.get(world.getUID());
        if (phTreeF == null) {
            return Collections.emptyList();
        }
        return () -> phTreeF.query(dArray, dArray2);
    }

    public Iterable<Player> getNearbyPlayers(Location location, double d) {
        PhTreeF<Player> phTreeF = this.worlds.get(location.getWorld().getUID());
        if (phTreeF == null) {
            return Collections.emptyList();
        }
        return () -> phTreeF.rangeQuery(d, new double[]{location.getX(), location.getY(), location.getZ()});
    }

    public Iterable<Player> getNearbyPlayers(NPC nPC) {
        return this.getNearbyPlayers(nPC.getStoredLocation(), nPC.data().get(NPC.Metadata.TRACKING_RANGE, Integer.valueOf(64)).intValue());
    }

    public Iterable<Player> getNearbyPlayers(World world, double[] dArray, double[] dArray2) {
        PhTreeF<Player> phTreeF = this.worlds.get(world.getUID());
        if (phTreeF == null) {
            return Collections.emptyList();
        }
        return () -> phTreeF.query(dArray, dArray2);
    }

    public Iterable<Player> getNearbyVisiblePlayers(Entity entity, double d) {
        return this.getNearbyVisiblePlayers(entity, entity.getLocation(), d);
    }

    public Iterable<Player> getNearbyVisiblePlayers(Entity entity, double[] dArray, double[] dArray2) {
        return this.filterToVisiblePlayers(entity, this.getNearbyPlayers(entity.getWorld(), dArray, dArray2));
    }

    public Iterable<Player> filterToVisiblePlayers(Entity entity, Iterable<Player> iterable) {
        Player player = entity instanceof Player ? (Player)entity : null;
        return Iterables.filter(iterable, player2 -> {
            boolean bl = true;
            if (SUPPORTS_ENTITY_CANSEE) {
                try {
                    bl = player2.canSee(entity);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    SUPPORTS_ENTITY_CANSEE = false;
                    if (player != null) {
                        bl = player2.canSee(player);
                    }
                }
            } else if (player != null) {
                bl = player2.canSee(player);
            }
            return player2.getWorld() == entity.getWorld() && bl && !player2.hasPotionEffect(PotionEffectType.INVISIBILITY) && player2.getGameMode() != GameMode.SPECTATOR;
        });
    }

    public Iterable<Player> getNearbyVisiblePlayers(Entity entity, Location location, double d) {
        return this.filterToVisiblePlayers(entity, this.getNearbyPlayers(location, d));
    }

    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            this.updateWorld(playerJoinEvent.getPlayer().getWorld());
            for (PerPlayerMetadata<?> perPlayerMetadata : this.metadata.values()) {
                if (((PerPlayerMetadata)perPlayerMetadata).onJoin == null) continue;
                ((PerPlayerMetadata)perPlayerMetadata).onJoin.accept(perPlayerMetadata, playerJoinEvent);
            }
        });
    }

    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            this.updateWorld(playerQuitEvent.getPlayer().getWorld());
            for (PerPlayerMetadata<?> perPlayerMetadata : this.metadata.values()) {
                ((PerPlayerMetadata)perPlayerMetadata).sent.remove(playerQuitEvent.getPlayer().getUniqueId());
            }
        });
    }

    public void onWorldUnload(WorldUnloadEvent worldUnloadEvent) {
        PhTreeF<NPC> phTreeF;
        PhTreeF<Player> phTreeF2 = this.worlds.remove(worldUnloadEvent.getWorld().getUID());
        if (phTreeF2 != null) {
            phTreeF2.clear();
        }
        if ((phTreeF = this.npcWorlds.remove(worldUnloadEvent.getWorld().getUID())) != null) {
            phTreeF.clear();
        }
    }

    public <T> PerPlayerMetadata<T> registerMetadata(String string2, BiConsumer<PerPlayerMetadata<T>, PlayerJoinEvent> biConsumer) {
        return this.metadata.computeIfAbsent(string2, string -> new PerPlayerMetadata(biConsumer));
    }

    public void run() {
        Collection collection;
        Location location;
        HashMap hashMap;
        if (this.npcFuture != null && this.npcFuture.isDone()) {
            try {
                this.npcWorlds = this.npcFuture.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
            }
            this.npcFuture = null;
        }
        if (this.npcFuture == null) {
            hashMap = Maps.newHashMap();
            location = new Location(null, 0.0, 0.0, 0.0);
            for (NPC nPC : this.sourceRegistry) {
                if (!nPC.isSpawned()) continue;
                nPC.getEntity().getLocation(location);
                collection = hashMap.computeIfAbsent(nPC.getEntity().getWorld().getUID(), uUID -> Lists.newArrayList());
                collection.add(new TreeFactory.Node<NPC>(new double[]{location.getX(), location.getY(), location.getZ()}, nPC));
            }
            this.npcFuture = ForkJoinPool.commonPool().submit((Callable)new TreeFactory(hashMap));
        }
        if (this.playerFuture != null && this.playerFuture.isDone()) {
            try {
                this.worlds = this.playerFuture.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
            }
            this.playerFuture = null;
        }
        if (this.playerFuture == null) {
            hashMap = Maps.newHashMap();
            location = new Location(null, 0.0, 0.0, 0.0);
            for (NPC nPC : Bukkit.getServer().getWorlds()) {
                collection = Collections2.filter((Collection)nPC.getPlayers(), player -> !player.hasMetadata("NPC"));
                if (collection.isEmpty()) continue;
                hashMap.put(nPC.getUID(), Collections2.transform((Collection)collection, player -> {
                    player.getLocation(location);
                    return new TreeFactory.Node<Player>(new double[]{location.getX(), location.getY(), location.getZ()}, (Player)player);
                }));
            }
            this.playerFuture = ForkJoinPool.commonPool().submit((Callable)new TreeFactory(hashMap));
        }
    }

    private void updateWorld(World world) {
        Collection collection = Collections2.filter((Collection)world.getPlayers(), player -> !player.hasMetadata("NPC"));
        if (collection.isEmpty()) {
            this.worlds.remove(world.getUID());
            return;
        }
        PhTreeF phTreeF = this.worlds.computeIfAbsent(world.getUID(), uUID -> PhTreeF.create((int)3));
        phTreeF.clear();
        Location location = new Location(null, 0.0, 0.0, 0.0);
        for (Player player2 : collection) {
            player2.getLocation(location);
            phTreeF.put(new double[]{location.getX(), location.getY(), location.getZ()}, (Object)player2);
        }
    }

    public static class PerPlayerMetadata<T> {
        private final BiConsumer<PerPlayerMetadata<T>, PlayerJoinEvent> onJoin;
        private final Map<UUID, Map<String, T>> sent = Maps.newHashMap();

        public PerPlayerMetadata(BiConsumer<PerPlayerMetadata<T>, PlayerJoinEvent> biConsumer) {
            this.onJoin = biConsumer;
        }

        public T getMarker(UUID uUID, String string) {
            return (T)this.sent.getOrDefault(uUID, Collections.emptyMap()).get(string);
        }

        public boolean has(UUID uUID, String string) {
            return this.sent.getOrDefault(uUID, Collections.emptyMap()).containsKey(string);
        }

        public boolean remove(UUID uUID, String string) {
            return this.sent.getOrDefault(uUID, Collections.emptyMap()).remove(string) != null;
        }

        public void removeAllValues(String string) {
            for (Map<String, T> map : this.sent.values()) {
                map.remove(string);
            }
        }

        public void set(UUID uUID2, String string, T t) {
            if (t instanceof Location || t instanceof World) {
                throw new IllegalArgumentException("Invalid marker");
            }
            this.sent.computeIfAbsent(uUID2, uUID -> Maps.newHashMap()).put(string, t);
        }
    }

    private static final class TreeFactory<K, V>
    implements Callable<Map<K, PhTreeF<V>>> {
        private final Map<K, Collection<Node<V>>> source;

        public TreeFactory(Map<K, Collection<Node<V>>> map) {
            this.source = map;
        }

        @Override
        public Map<K, PhTreeF<V>> call() {
            HashMap hashMap = Maps.newHashMap();
            for (K k : this.source.keySet()) {
                PhTreeF phTreeF = PhTreeF.create((int)3);
                for (Node<V> node : this.source.get(k)) {
                    phTreeF.put(node.loc, node.t);
                }
                hashMap.put(k, phTreeF);
            }
            return hashMap;
        }

        public static class Node<T> {
            public double[] loc;
            public T t;

            public Node(double[] dArray, T t) {
                this.loc = dArray;
                this.t = t;
            }
        }
    }

    public static abstract class AsyncPhTreeLoader<K, V>
    implements Runnable {
        private Future<Map<K, PhTreeF<V>>> future;
        protected Map<K, PhTreeF<V>> mapping = Maps.newHashMap();

        protected abstract Map<K, Collection<TreeFactory.Node<V>>> generateLoaderMap();

        public Iterable<V> getNearby(K k, double d, double[] dArray) {
            PhTreeF phTreeF = this.mapping.get(k);
            if (phTreeF == null) {
                return Collections.emptyList();
            }
            return () -> phTreeF.rangeQuery(d, dArray);
        }

        public Iterable<V> getNearby(K k, double[] dArray, double[] dArray2) {
            PhTreeF phTreeF = this.mapping.get(k);
            if (phTreeF == null) {
                return Collections.emptyList();
            }
            return () -> phTreeF.query(dArray, dArray2);
        }

        @Override
        public void run() {
            if (this.future != null && this.future.isDone()) {
                try {
                    this.mapping = this.future.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    exception.printStackTrace();
                }
                this.future = null;
            }
            if (this.future == null) {
                this.future = ForkJoinPool.commonPool().submit(new TreeFactory<K, V>(this.generateLoaderMap()));
            }
        }
    }
}

