/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai;

import java.util.Objects;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalController;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.ForwardingBehaviorGoalAdapter;

public class SimpleGoalEntry
implements GoalController.GoalEntry {
    final Goal goal;
    final int priority;

    public SimpleGoalEntry(Goal goal, int n) {
        this.goal = goal;
        this.priority = n;
    }

    @Override
    public int compareTo(GoalController.GoalEntry goalEntry) {
        return goalEntry.getPriority() > this.priority ? 1 : (goalEntry.getPriority() < this.priority ? -1 : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SimpleGoalEntry simpleGoalEntry = (SimpleGoalEntry)object;
        if (!Objects.equals(this.goal, simpleGoalEntry.goal)) {
            return false;
        }
        return this.priority == simpleGoalEntry.priority;
    }

    @Override
    public Behavior getBehavior() {
        return this.goal instanceof Behavior ? (Behavior)((Object)this.goal) : (this.goal instanceof ForwardingBehaviorGoalAdapter ? ((ForwardingBehaviorGoalAdapter)this.goal).getWrapped() : null);
    }

    @Override
    public Goal getGoal() {
        return this.goal;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public int hashCode() {
        int n = 31;
        return 31 * (31 + (this.goal == null ? 0 : this.goal.hashCode())) + this.priority;
    }
}

