/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai;

import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.player.PlayerTeleportEvent;

public class TeleportStuckAction
implements StuckAction {
    public static TeleportStuckAction INSTANCE = new TeleportStuckAction();
    private static final int MAX_ITERATIONS = 10;

    private TeleportStuckAction() {
    }

    @Override
    public boolean run(NPC nPC, Navigator navigator) {
        if (!nPC.isSpawned()) {
            return false;
        }
        Location location = navigator.getTargetAsLocation();
        if (location == null || location.getWorld() != nPC.getEntity().getWorld()) {
            return true;
        }
        Block block = location.getBlock().getRelative(BlockFace.DOWN);
        int n = 0;
        while (!MinecraftBlockExaminer.canStandOn(block)) {
            if (n++ >= 10) {
                block = location.getBlock().getRelative(BlockFace.DOWN);
                break;
            }
            block = block.getRelative(BlockFace.UP);
        }
        nPC.teleport(block.getRelative(BlockFace.UP).getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
        return false;
    }

    public String toString() {
        return "TeleportStuckAction";
    }
}

