/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.flocking;

import com.google.common.collect.Collections2;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.ai.flocking.FlockBehavior;
import net.citizensnpcs.api.ai.flocking.NPCFlock;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.util.Vector;

public class Flocker
implements Runnable {
    private final List<FlockBehavior> behaviors;
    private final NPCFlock flock;
    private double maxForce = 1.5;
    private final NPC npc;
    public static double HIGH_INFLUENCE = 0.05;
    public static double LOW_INFLUENCE = 0.005;

    public Flocker(NPC nPC, NPCFlock nPCFlock, FlockBehavior ... flockBehaviorArray) {
        this.npc = nPC;
        this.flock = nPCFlock;
        this.behaviors = Arrays.asList(flockBehaviorArray);
    }

    @Override
    public void run() {
        Collection collection = Collections2.filter(this.flock.getNearby(this.npc), NPC::isSpawned);
        if (collection.isEmpty()) {
            return;
        }
        Vector vector = new Vector(0, 0, 0);
        for (FlockBehavior flockBehavior : this.behaviors) {
            vector.add(flockBehavior.getVector(this.npc, collection));
        }
        vector = Flocker.clip(this.maxForce, vector);
        this.npc.getEntity().setVelocity(this.npc.getEntity().getVelocity().add(vector));
    }

    public void setMaxForce(double d) {
        if (d == 0.0) {
            throw new IllegalArgumentException();
        }
        this.maxForce = d;
    }

    private static Vector clip(double d, Vector vector) {
        if (vector.length() > d) {
            return vector.normalize().multiply(d);
        }
        return vector;
    }
}

