/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.util.Vector;

public class MinecraftBlockExaminer
implements BlockExaminer {
    private static final Set<Material> CLIMBABLE = EnumSet.of(Material.LADDER, Material.VINE);
    private static final Set<Material> LIQUIDS = EnumSet.of(Material.WATER, Material.LAVA);
    private static final Set<Material> NOT_JUMPABLE = EnumSet.of(Material.SPRUCE_FENCE, Material.BIRCH_FENCE, Material.JUNGLE_FENCE, Material.ACACIA_FENCE, Material.DARK_OAK_FENCE);
    private static boolean SUPPORT_WATERLOGGED = true;
    private static final Set<Material> UNWALKABLE = EnumSet.of(Material.AIR, Material.CACTUS);
    private static Material WEB;

    @Override
    public float getCost(BlockSource blockSource, PathPoint pathPoint) {
        Vector vector = pathPoint.getVector();
        Material material = blockSource.getMaterialAt(vector.getBlockX(), vector.getBlockY() + 1, vector.getBlockZ());
        Material material2 = blockSource.getMaterialAt(vector.getBlockX(), vector.getBlockY() - 1, vector.getBlockZ());
        Material material3 = blockSource.getMaterialAt(vector);
        if (material == WEB || material3 == WEB || material2 == Material.SOUL_SAND || material2 == Material.ICE) {
            return 2.0f;
        }
        if (MinecraftBlockExaminer.isLiquidOrInLiquid(blockSource.getWorld().getBlockAt(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ()))) {
            if (material3 == Material.LAVA) {
                return 4.0f;
            }
            return 2.0f;
        }
        return 0.0f;
    }

    private boolean isClimbable(Material material) {
        return CLIMBABLE.contains(material);
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource blockSource, PathPoint pathPoint) {
        boolean bl;
        Vector vector = pathPoint.getVector();
        if (!SpigotUtil.checkYSafe(vector.getBlockY(), blockSource.getWorld())) {
            return BlockExaminer.PassableState.UNPASSABLE;
        }
        Block block = blockSource.getBlockAt(vector.getBlockX(), vector.getBlockY() + 1, vector.getBlockZ());
        Material material = blockSource.getMaterialAt(vector.getBlockX(), vector.getBlockY() - 1, vector.getBlockZ());
        Block block2 = blockSource.getBlockAt(vector);
        boolean bl2 = bl = MinecraftBlockExaminer.canStandOn(material) || MinecraftBlockExaminer.isLiquid(block2.getType(), material) || this.isClimbable(material);
        if (!bl) {
            return BlockExaminer.PassableState.UNPASSABLE;
        }
        if (this.isClimbable(block2.getType()) && (this.isClimbable(block.getType()) || this.isClimbable(material))) {
            pathPoint.addCallback(new LadderClimber());
        } else if (!MinecraftBlockExaminer.canStandIn(block) || !MinecraftBlockExaminer.canStandIn(block2)) {
            return BlockExaminer.PassableState.UNPASSABLE;
        }
        if (!MinecraftBlockExaminer.canJumpOn(material)) {
            if (pathPoint.getParentPoint() == null) {
                return BlockExaminer.PassableState.UNPASSABLE;
            }
            Vector vector2 = pathPoint.getParentPoint().getVector();
            if ((vector2.getX() != vector.getX() || vector2.getZ() != vector.getZ()) && vector.clone().subtract(pathPoint.getParentPoint().getVector()).getY() == 1.0) {
                return BlockExaminer.PassableState.UNPASSABLE;
            }
        }
        return BlockExaminer.PassableState.PASSABLE;
    }

    private static boolean canJumpOn(Material material) {
        return !NOT_JUMPABLE.contains(material);
    }

    public static boolean canStandIn(Block ... blockArray) {
        boolean bl = true;
        for (Block block : blockArray) {
            Slab slab;
            bl &= !block.getType().isSolid();
            if (!SpigotUtil.isUsing1_13API()) continue;
            if (block.getBlockData() instanceof Slab) {
                slab = (Slab)block.getBlockData();
                if (slab.getType() == Slab.Type.BOTTOM) continue;
                bl = false;
                continue;
            }
            if (!(block.getBlockData() instanceof TrapDoor)) continue;
            slab = (TrapDoor)block.getBlockData();
            bl &= slab.isOpen();
        }
        return bl;
    }

    public static boolean canStandIn(Material ... materialArray) {
        boolean bl = true;
        for (Material material : materialArray) {
            bl &= !material.isSolid();
        }
        return bl;
    }

    public static boolean canStandOn(Block block) {
        Block block2 = block.getRelative(BlockFace.UP);
        boolean bl = MinecraftBlockExaminer.canStandOn(block.getType());
        if (SpigotUtil.isUsing1_13API() && block.getBlockData() instanceof TrapDoor) {
            TrapDoor trapDoor = (TrapDoor)block.getBlockData();
            bl = !trapDoor.isOpen();
        }
        return bl && MinecraftBlockExaminer.canStandIn(block2, block2.getRelative(BlockFace.UP));
    }

    public static boolean canStandOn(Material material) {
        return !UNWALKABLE.contains(material) && material.isSolid();
    }

    public static Location findRandomValidLocation(Location location, int n, int n2) {
        return MinecraftBlockExaminer.findRandomValidLocation(location, n, n2, null, new Random());
    }

    public static Location findRandomValidLocation(Location location, int n, int n2, Function<Block, Boolean> function) {
        return MinecraftBlockExaminer.findRandomValidLocation(location, n, n2, function, new Random());
    }

    public static Location findRandomValidLocation(Location location, int n, int n2, Function<Block, Boolean> function, Random random) {
        for (int i = 0; i < 10; ++i) {
            Block block;
            int n3 = location.getBlockX() + random.nextInt(2 * n + 1) - n;
            int n4 = location.getBlockY() + random.nextInt(2 * n2 + 1) - n2;
            int n5 = location.getBlockZ() + random.nextInt(2 * n + 1) - n;
            if (!location.getWorld().isChunkLoaded(n3 >> 4, n5 >> 4) || !MinecraftBlockExaminer.canStandOn(block = location.getWorld().getBlockAt(n3, n4, n5)) || function != null && !function.apply(block).booleanValue()) continue;
            return block.getLocation().add(0.0, 1.0, 0.0);
        }
        return null;
    }

    public static Location findValidLocation(Location location, int n) {
        return MinecraftBlockExaminer.findValidLocation(location, n, n);
    }

    public static Location findValidLocation(Location location, int n, int n2) {
        return MinecraftBlockExaminer.findValidLocation(location, n, n2, block -> true);
    }

    public static Location findValidLocation(Location location, int n, int n2, Function<Block, Boolean> function) {
        Block block = location.getBlock();
        if (function.apply(block).booleanValue() && MinecraftBlockExaminer.canStandOn(block.getRelative(BlockFace.DOWN))) {
            return location;
        }
        for (int i = -n2; i <= n2; ++i) {
            for (int j = -n; j <= n; ++j) {
                for (int k = -n; k <= n; ++k) {
                    Block block2;
                    if (!block.getWorld().isChunkLoaded(block.getX() + j >> 4, block.getZ() + k >> 4) || !function.apply(block2 = block.getRelative(j, i, k)).booleanValue() || !MinecraftBlockExaminer.canStandOn(block2.getRelative(BlockFace.DOWN))) continue;
                    return block2.getLocation();
                }
            }
        }
        return location;
    }

    public static Location findValidLocationAbove(Location location, int n) {
        Block block = location.getBlock();
        if (MinecraftBlockExaminer.canStandOn(block.getRelative(BlockFace.DOWN))) {
            return location;
        }
        for (int i = 0; i <= n; ++i) {
            Block block2 = block.getRelative(0, i, 0);
            if (!MinecraftBlockExaminer.canStandOn(block2.getRelative(BlockFace.DOWN))) continue;
            return block2.getLocation();
        }
        return location;
    }

    public static boolean isDoor(Material material) {
        return material.name().contains("DOOR") && !material.name().contains("TRAPDOOR");
    }

    public static boolean isGate(Material material) {
        return material.name().contains("GATE") && !material.name().contains("GATEWAY");
    }

    public static boolean isLiquid(Material ... materialArray) {
        for (Material material : materialArray) {
            if (!LIQUIDS.contains(material)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLiquidOrInLiquid(Block block) {
        if (MinecraftBlockExaminer.isLiquid(block.getType())) {
            return true;
        }
        if (!SUPPORT_WATERLOGGED) {
            return false;
        }
        try {
            BlockData blockData = block.getBlockData();
            return blockData instanceof Waterlogged && ((Waterlogged)blockData).isWaterlogged();
        }
        catch (Throwable throwable) {
            SUPPORT_WATERLOGGED = false;
            return false;
        }
    }

    static {
        Material material = WEB = SpigotUtil.isUsing1_13API() ? Material.COBWEB : Material.valueOf((String)"WEB");
        if (!SpigotUtil.isUsing1_13API()) {
            LIQUIDS.add(Material.valueOf((String)"STATIONARY_LAVA"));
            LIQUIDS.add(Material.valueOf((String)"STATIONARY_WATER"));
            UNWALKABLE.add(Material.valueOf((String)"STATIONARY_LAVA"));
            NOT_JUMPABLE.addAll(Lists.newArrayList((Object[])new Material[]{Material.valueOf((String)"FENCE"), Material.valueOf((String)"IRON_FENCE"), Material.valueOf((String)"NETHER_FENCE"), Material.valueOf((String)"COBBLE_WALL")}));
        } else {
            try {
                UNWALKABLE.add(Material.valueOf((String)"CAMPFIRE"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                CLIMBABLE.add(Material.valueOf((String)"SCAFFOLDING"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            NOT_JUMPABLE.addAll(Lists.newArrayList((Object[])new Material[]{Material.valueOf((String)"OAK_FENCE"), Material.valueOf((String)"NETHER_BRICK_FENCE"), Material.valueOf((String)"COBBLESTONE_WALL")}));
            try {
                NOT_JUMPABLE.add(Material.valueOf((String)"MANGROVE_FENCE"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                NOT_JUMPABLE.add(Material.valueOf((String)"CHERRY_FENCE"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private class LadderClimber
    implements PathPoint.PathCallback {
        boolean added = false;

        private LadderClimber() {
        }

        @Override
        public void run(final NPC nPC, Block block, final List<Block> list, final int n) {
            if (this.added || nPC.data().get("running-ladder", Boolean.valueOf(false)).booleanValue()) {
                this.added = true;
                return;
            }
            nPC.getNavigator().getLocalParameters().addRunCallback(new Runnable(){
                Location dummy = new Location(null, 0.0, 0.0, 0.0);
                boolean sneakingForScaffolding;

                private boolean isScaffolding(Material material) {
                    return material.name().contains("SCAFFOLDING");
                }

                @Override
                public void run() {
                    if (n + 1 >= list.size()) {
                        return;
                    }
                    Location location = nPC.getEntity().getLocation(this.dummy);
                    Material material = location.getBlock().getType();
                    Block block = (Block)list.get(n + 1);
                    Block block2 = (Block)list.get(n);
                    if (MinecraftBlockExaminer.this.isClimbable(material) || MinecraftBlockExaminer.this.isClimbable(location.getBlock().getRelative(BlockFace.DOWN).getType()) || this.isScaffolding(block.getType())) {
                        if (block.getY() > block2.getY()) {
                            nPC.getEntity().setVelocity(nPC.getEntity().getVelocity().setY(0.3));
                            if (this.sneakingForScaffolding) {
                                this.sneakingForScaffolding = false;
                                nPC.setSneaking(false);
                            }
                        } else if (this.isScaffolding(material) || this.isScaffolding(block.getType())) {
                            if (location.distance(block.getLocation().add(0.5, 1.0, 0.5)) < 0.4) {
                                this.sneakingForScaffolding = true;
                                nPC.setSneaking(true);
                            }
                        } else if (block.getY() < block2.getY()) {
                            nPC.getEntity().setVelocity(nPC.getEntity().getVelocity().setY(-0.2));
                        }
                    } else if (this.sneakingForScaffolding) {
                        this.sneakingForScaffolding = false;
                        nPC.setSneaking(false);
                    }
                }
            });
            nPC.getNavigator().getLocalParameters().addSingleUseCallback(cancelReason -> {
                nPC.data().set("running-ladder", (Object)false);
                nPC.setSneaking(false);
            });
            this.added = true;
        }
    }
}

