/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.command;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.citizensnpcs.api.command.exception.CommandException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.joml.Quaternionf;

public class CommandContext {
    protected String[] args;
    protected final Set<Character> flags = new HashSet<Character>();
    private Location location = null;
    private final String[] rawArgs;
    private final CommandSender sender;
    protected final Map<String, String> valueFlags = Maps.newHashMap();
    private static final Pattern FLAG = Pattern.compile("^-[a-zA-Z]+$");
    private static final Splitter LOCATION_SPLITTER = Splitter.on((Pattern)Pattern.compile("[,:]")).omitEmptyStrings();
    private static final Pattern VALUE_FLAG = Pattern.compile("^--[a-zA-Z0-9-]+$");

    public CommandContext(boolean bl, CommandSender commandSender, String[] stringArray) {
        int n;
        int n2;
        this.sender = commandSender;
        this.rawArgs = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.rawArgs, 0, stringArray.length);
        block0: for (n2 = 1; n2 < stringArray.length; ++n2) {
            stringArray[n2] = stringArray[n2].trim();
            if (stringArray[n2].length() == 0) continue;
            if (stringArray[n2].charAt(0) == '{') {
                String string = stringArray[n2];
                for (n = n2 + 1; n < stringArray.length && CharMatcher.is((char)'{').countIn((CharSequence)string) - CharMatcher.is((char)'}').countIn((CharSequence)string) != 0; ++n) {
                    string = string + " " + stringArray[n];
                    stringArray[n] = "";
                }
                stringArray[n2] = string;
                continue;
            }
            if (stringArray[n2].charAt(0) != '\'' && stringArray[n2].charAt(0) != '\"' && stringArray[n2].charAt(0) != '`') continue;
            char c = stringArray[n2].charAt(0);
            String string = stringArray[n2].substring(1);
            if (string.length() > 0 && string.charAt(string.length() - 1) == c) {
                stringArray[n2] = string.substring(0, string.length() - 1);
                continue;
            }
            for (int i = n2 + 1; i < stringArray.length; ++i) {
                if (stringArray[i].isEmpty()) continue;
                String string2 = stringArray[i].trim();
                string = string + " " + string2;
                if (string2.charAt(string2.length() - 1) != c) continue;
                stringArray[n2] = string.substring(0, string.length() - 1);
                for (int j = n2 + 1; j <= i; ++j) {
                    stringArray[j] = "";
                }
                continue block0;
            }
        }
        for (n2 = 1; n2 < stringArray.length; ++n2) {
            int n3 = stringArray[n2].length();
            if (n3 == 0) continue;
            if (n2 + 1 < stringArray.length && n3 > 2 && VALUE_FLAG.matcher(stringArray[n2]).matches()) {
                n = n2 + 1;
                while (stringArray[n].length() == 0) {
                    if (++n < stringArray.length) continue;
                    n = -1;
                    break;
                }
                if (n == -1) continue;
                this.valueFlags.put(stringArray[n2].toLowerCase().substring(2), stringArray[n]);
                if (!bl) continue;
                stringArray[n2] = "";
                stringArray[n] = "";
                continue;
            }
            if (!FLAG.matcher(stringArray[n2]).matches()) continue;
            for (n = 1; n < stringArray[n2].length(); ++n) {
                this.flags.add(Character.valueOf(stringArray[n2].charAt(n)));
            }
            stringArray[n2] = "";
        }
        ArrayList arrayList = Lists.newArrayList();
        for (String string : stringArray) {
            if ((string = string.trim()) == null || string.isEmpty()) continue;
            arrayList.add(string.trim());
        }
        this.args = arrayList.toArray(new String[arrayList.size()]);
    }

    public CommandContext(CommandSender commandSender, String[] stringArray) {
        this(true, commandSender, stringArray);
    }

    public CommandContext(String[] stringArray) {
        this(null, stringArray);
    }

    public int argsLength() {
        return this.args.length - 1;
    }

    public String getCommand() {
        return this.args[0];
    }

    public double getDouble(int n) {
        return Double.parseDouble(this.args[n + 1]);
    }

    public double getDouble(int n, double d) {
        return n + 1 < this.args.length ? Double.parseDouble(this.args[n + 1]) : d;
    }

    public String getFlag(String string) {
        return this.valueFlags.get(string);
    }

    public String getFlag(String string, String string2) {
        String string3 = this.valueFlags.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public double getFlagDouble(String string) {
        return Double.parseDouble(this.valueFlags.get(string));
    }

    public double getFlagDouble(String string, double d) {
        String string2 = this.valueFlags.get(string);
        if (string2 == null) {
            return d;
        }
        return Double.parseDouble(string2);
    }

    public int getFlagInteger(String string) {
        return Integer.parseInt(this.valueFlags.get(string));
    }

    public int getFlagInteger(String string, int n) {
        String string2 = this.valueFlags.get(string);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    public Set<Character> getFlags() {
        return this.flags;
    }

    public int getFlagTicks(String string) {
        return this.parseTicks(this.valueFlags.get(string));
    }

    public int getFlagTicks(String string, int n) {
        String string2 = this.valueFlags.get(string);
        if (string2 == null) {
            return n;
        }
        return this.parseTicks(string2);
    }

    public int getInteger(int n) {
        return Integer.parseInt(this.args[n + 1]);
    }

    public int getInteger(int n, int n2) {
        if (n + 1 < this.args.length) {
            try {
                return Integer.parseInt(this.args[n + 1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public String getJoinedStrings(int n) {
        return this.getJoinedStrings(n, ' ');
    }

    public String getJoinedStrings(int n, char c) {
        StringBuilder stringBuilder = new StringBuilder(this.args[++n]);
        for (int i = n + 1; i < this.args.length; ++i) {
            stringBuilder.append(c).append(this.args[i]);
        }
        return stringBuilder.toString().trim();
    }

    public String[] getPaddedSlice(int n, int n2) {
        String[] stringArray = new String[this.args.length - n + n2];
        System.arraycopy(this.args, n, stringArray, n2, this.args.length - n);
        return stringArray;
    }

    public String getRawCommand() {
        return Joiner.on((char)' ').join((Object[])this.rawArgs);
    }

    public Location getSenderLocation() {
        if (this.location != null) {
            return this.location;
        }
        Location location = null;
        if (this.sender instanceof Player) {
            location = ((Player)this.sender).getLocation();
        } else if (this.sender instanceof BlockCommandSender) {
            location = ((BlockCommandSender)this.sender).getBlock().getLocation();
        }
        if (this.hasValueFlag("location")) {
            this.location = CommandContext.parseLocation(location, this.getFlag("location"));
            return this.location;
        }
        this.location = location;
        return this.location;
    }

    public Location getSenderTargetBlockLocation() {
        if (this.location != null) {
            return this.location;
        }
        Location location = null;
        if (this.sender instanceof Player) {
            location = ((Player)this.sender).getTargetBlock((Set)null, 50).getLocation();
        } else if (this.sender instanceof BlockCommandSender) {
            location = ((BlockCommandSender)this.sender).getBlock().getLocation();
        }
        if (this.hasValueFlag("location")) {
            this.location = CommandContext.parseLocation(location, this.getFlag("location"));
            return this.location;
        }
        this.location = location;
        return this.location;
    }

    public String[] getSlice(int n) {
        String[] stringArray = new String[this.args.length - n - 1];
        System.arraycopy(this.args, n + 1, stringArray, 0, this.args.length - n - 1);
        return stringArray;
    }

    public String getString(int n) {
        return this.args[n + 1];
    }

    public String getString(int n, String string) {
        return n + 1 < this.args.length ? this.args[n + 1] : string;
    }

    public int getTicks(int n) {
        return this.parseTicks(this.args[n + 1]);
    }

    public Map<String, String> getValueFlags() {
        return this.valueFlags;
    }

    public boolean hasAnyFlags() {
        return this.valueFlags.size() > 0 || this.flags.size() > 0;
    }

    public boolean hasAnyValueFlag(String ... stringArray) {
        for (String string : stringArray) {
            if (!this.hasValueFlag(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFlag(char c) {
        return this.flags.contains(Character.valueOf(c));
    }

    public boolean hasValueFlag(String string) {
        return this.valueFlags.containsKey(string);
    }

    public int length() {
        return this.args.length;
    }

    public boolean matches(String string) {
        return this.args[0].equalsIgnoreCase(string);
    }

    public EulerAngle parseEulerAngle(String string) {
        ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.transform((Iterable)Splitter.on((char)',').split((CharSequence)string), Double::parseDouble));
        return new EulerAngle(((Double)arrayList.get(0)).doubleValue(), ((Double)arrayList.get(1)).doubleValue(), ((Double)arrayList.get(2)).doubleValue());
    }

    public int parseTicks(String string) {
        char c = Character.toLowerCase((string = string.trim()).charAt(string.length() - 1));
        if (Character.isDigit(c)) {
            return Integer.parseInt(string);
        }
        int n = 1;
        if (c == 's') {
            n = 20;
        }
        if (c == 'm') {
            n = 1200;
        }
        if (c == 'h') {
            n = 72000;
        }
        if (c == 'd') {
            n = 1728000;
        }
        return (int)Math.ceil(Double.parseDouble(string.substring(0, string.length() - 1)) * (double)n);
    }

    public static ItemStack parseItemStack(String string) {
        List list = LOCATION_SPLITTER.splitToList((CharSequence)string);
        Material material = Material.matchMaterial((String)((String)list.get(0)));
        int n = list.size() > 1 ? Integer.parseInt((String)list.get(1)) : 1;
        return new ItemStack(material, n);
    }

    public static Location parseLocation(Location location, String string) {
        boolean bl = string.startsWith("l@");
        String[] stringArray = (String[])Iterables.toArray((Iterable)LOCATION_SPLITTER.split((CharSequence)string.replaceFirst("l@", "")), String.class);
        if (stringArray.length > 0) {
            String string2 = location != null ? location.getWorld().getName() : "";
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            float f = 0.0f;
            float f2 = 0.0f;
            switch (stringArray.length) {
                case 6: {
                    if (bl) {
                        string2 = stringArray[5].replaceFirst("w@", "");
                    } else {
                        f2 = Float.parseFloat(stringArray[5]);
                    }
                }
                case 5: {
                    if (bl) {
                        f2 = Float.parseFloat(stringArray[4]);
                    } else {
                        f = Float.parseFloat(stringArray[4]);
                    }
                }
                case 4: {
                    if (bl && stringArray.length > 4) {
                        f = Float.parseFloat(stringArray[3]);
                    } else {
                        string2 = stringArray[3].replaceFirst("w@", "");
                    }
                }
                case 3: {
                    d = Double.parseDouble(stringArray[0]);
                    d2 = Double.parseDouble(stringArray[1]);
                    d3 = Double.parseDouble(stringArray[2]);
                    break;
                }
                default: {
                    throw new CommandException("citizens.commands.npc.create.invalid-location");
                }
            }
            World world = Bukkit.getWorld((String)string2);
            if (world == null) {
                throw new CommandException("citizens.commands.npc.create.invalid-location");
            }
            return new Location(world, d, d2, d3, f, f2);
        }
        Player player = Bukkit.getPlayerExact((String)string);
        if (player == null) {
            throw new CommandException("citizens.commands.npc.create.no-player-for-spawn");
        }
        return player.getLocation();
    }

    public static Quaternionf parseQuaternion(String string) {
        String[] stringArray = string.split(",");
        return new Quaternionf(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]));
    }

    public static Vector parseVector(String string) {
        String[] stringArray = string.split(",");
        return new Vector(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]));
    }
}

