/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.command;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import net.citizensnpcs.api.util.Messaging;

public class Injector {
    private final Class<?>[] argClasses;
    private final List<Object> args;
    private static MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    public Injector(Object ... objectArray) {
        this.args = Arrays.asList(objectArray);
        this.argClasses = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.argClasses[i] = objectArray[i].getClass();
        }
    }

    public Object getInstance(Class<?> clazz) {
        try {
            return LOOKUP.findConstructor(clazz, MethodType.methodType(Void.TYPE, this.argClasses)).invokeWithArguments(this.args);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            try {
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                Messaging.severe("Error initializing commands class " + clazz + ": ");
                exception.printStackTrace();
                return null;
            }
        }
        catch (Throwable throwable) {
            Messaging.severe("Error initializing commands class " + clazz + ": ");
            throwable.printStackTrace();
            return null;
        }
    }
}

