/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.command;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.CommandAnnotationProcessor;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.RequirementMissingException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;

public class RequirementsProcessor
implements CommandAnnotationProcessor {
    @Override
    public Class<? extends Annotation> getAnnotationClass() {
        return Requirements.class;
    }

    @Override
    public void process(CommandSender commandSender, CommandContext commandContext, Annotation annotation, Object[] objectArray) {
        Requirements requirements = (Requirements)annotation;
        NPC nPC = objectArray.length >= 3 && objectArray[2] instanceof NPC ? (NPC)objectArray[2] : null;
        boolean bl = (commandContext.hasValueFlag("uuid") || commandContext.hasValueFlag("id")) && commandSender.hasPermission("npc.select");
        String string = Messaging.tr("citizens.commands.requirements.must-have-selected", new Object[0]);
        if (bl) {
            nPC = commandContext.hasValueFlag("uuid") ? CitizensAPI.getNPCRegistry().getByUniqueIdGlobal(UUID.fromString(commandContext.getFlag("uuid"))) : CitizensAPI.getNPCRegistry().getById(commandContext.getFlagInteger("id"));
            if (objectArray.length >= 3) {
                objectArray[2] = nPC;
            }
            if (nPC == null) {
                string = string + ' ' + Messaging.tr("citizens.commands.id-not-found", commandContext.getFlag("id", commandContext.getFlag("uuid")));
            }
        }
        if (requirements.selected() && nPC == null) {
            throw new RequirementMissingException(string);
        }
        if (requirements.ownership() && nPC != null && !commandSender.hasPermission("citizens.admin") && !nPC.getOrAddTrait(Owner.class).isOwnedBy(commandSender)) {
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.must-be-owner", new Object[0]));
        }
        if (nPC == null) {
            return;
        }
        for (Class<? extends Trait> clazz : requirements.traits()) {
            if (nPC.hasTrait(clazz)) continue;
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.missing-required-trait", clazz.getSimpleName()));
        }
        Object object = Sets.newEnumSet(Arrays.asList(requirements.types()), EntityType.class);
        if (object.contains(EntityType.UNKNOWN)) {
            object = EnumSet.allOf(EntityType.class);
        }
        object.removeAll(Sets.newHashSet((Object[])requirements.excludedTypes()));
        EntityType entityType = nPC.getOrAddTrait(MobType.class).getType();
        if (!object.contains(entityType)) {
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.disallowed-mobtype", entityType.name().toLowerCase().replace('_', ' ')));
        }
        if (requirements.livingEntity() && !entityType.isAlive()) {
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.living-entity", objectArray));
        }
    }
}

