/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.hpastar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.hpastar.HPAGraphEdge;

public class HPAGraphNode {
    final List<List<HPAGraphEdge>> edges = new ArrayList<List<HPAGraphEdge>>();
    final int x;
    final int y;
    final int z;

    public HPAGraphNode(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    public void connect(int n, HPAGraphNode hPAGraphNode, HPAGraphEdge.EdgeType edgeType, float f) {
        while (n >= this.edges.size()) {
            this.edges.add(new ArrayList());
        }
        while (n >= hPAGraphNode.edges.size()) {
            hPAGraphNode.edges.add(new ArrayList());
        }
        this.edges.get(n).add(new HPAGraphEdge(this, hPAGraphNode, edgeType, f));
        hPAGraphNode.edges.get(n).add(new HPAGraphEdge(hPAGraphNode, this, edgeType, f));
    }

    public double distance(HPAGraphNode hPAGraphNode) {
        return Math.sqrt(Math.pow(this.x - hPAGraphNode.x, 2.0) + Math.pow(this.y - hPAGraphNode.y, 2.0) + Math.pow(this.z - hPAGraphNode.z, 2.0));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HPAGraphNode hPAGraphNode = (HPAGraphNode)object;
        return this.x == hPAGraphNode.x && this.y == hPAGraphNode.y && this.z == hPAGraphNode.z;
    }

    public List<HPAGraphEdge> getEdges(int n) {
        if (n >= this.edges.size()) {
            return Collections.emptyList();
        }
        return this.edges.get(n);
    }

    public int hashCode() {
        return 31 * (31 * (31 + this.x) + this.y) + this.z;
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.z;
    }
}

