/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import java.util.UUID;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Storage;
import org.bukkit.entity.EntityType;

public class SimpleNPCDataStore
implements NPCDataStore {
    private final Storage root;
    private static final String LOAD_NAME_NOT_FOUND = "citizens.notifications.npc-name-not-found";
    private static final String LOAD_UNKNOWN_NPC_TYPE = "citizens.notifications.unknown-npc-type";

    public SimpleNPCDataStore(Storage storage) {
        this.root = storage;
    }

    @Override
    public void clearData(NPC nPC) {
        this.root.getKey("npc").removeKey(Integer.toString(nPC.getId()));
    }

    @Override
    public int createUniqueNPCId(NPCRegistry nPCRegistry) {
        DataKey dataKey = this.root.getKey("");
        int n = dataKey.getInt("last-created-npc-id", -1);
        if (n == -1 || nPCRegistry.getById(n + 1) != null) {
            int n2 = Integer.MIN_VALUE;
            for (NPC nPC : nPCRegistry) {
                if (nPC.getId() <= n2) continue;
                n2 = nPC.getId();
            }
            n = n2 == Integer.MIN_VALUE ? 0 : n2 + 1;
        } else {
            ++n;
        }
        dataKey.setInt("last-created-npc-id", n);
        return n;
    }

    @Override
    public void loadInto(NPCRegistry nPCRegistry) {
        for (DataKey dataKey : this.root.getKey("npc").getIntegerSubKeys()) {
            int n = Integer.parseInt(dataKey.name());
            if (!dataKey.keyExists("name")) {
                Messaging.logTr(LOAD_NAME_NOT_FOUND, n);
                continue;
            }
            String string = dataKey.getString("traits.type", "PLAYER");
            EntityType entityType = SimpleNPCDataStore.matchEntityType(string);
            if (entityType == null) {
                Messaging.logTr(LOAD_UNKNOWN_NPC_TYPE, string);
                continue;
            }
            NPC nPC = nPCRegistry.createNPC(entityType, !dataKey.getString("uuid").isEmpty() ? UUID.fromString(dataKey.getString("uuid")) : UUID.randomUUID(), n, dataKey.getString("name"));
            nPC.load(dataKey);
        }
    }

    @Override
    public void reloadFromSource() {
        this.root.load();
    }

    @Override
    public void saveToDisk() {
        new Thread(() -> this.root.save()).start();
    }

    @Override
    public void saveToDiskImmediate() {
        this.root.save();
    }

    @Override
    public void store(NPC nPC) {
        nPC.save(this.root.getKey("npc." + nPC.getId()));
    }

    @Override
    public void storeAll(NPCRegistry nPCRegistry) {
        for (NPC nPC : nPCRegistry) {
            this.store(nPC);
        }
    }

    public static NPCDataStore create(Storage storage) {
        return new SimpleNPCDataStore(storage);
    }

    private static EntityType matchEntityType(String string) {
        EntityType entityType;
        try {
            entityType = EntityType.valueOf((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            entityType = EntityType.fromName((String)string);
        }
        if (entityType != null) {
            return entityType;
        }
        return (EntityType)SimpleNPCDataStore.matchEnum((Enum[])EntityType.values(), (String)string);
    }

    private static <T extends Enum<?>> T matchEnum(T[] TArray, String string) {
        T t = null;
        for (T t2 : TArray) {
            String string2 = ((Enum)t2).name();
            if (!string2.matches(string) && !string2.equalsIgnoreCase(string) && !string2.replace("_", "").equalsIgnoreCase(string) && !string2.replace('_', '-').equalsIgnoreCase(string) && !string2.replace('_', ' ').equalsIgnoreCase(string) && !string2.startsWith(string)) continue;
            t = t2;
            break;
        }
        return t;
    }
}

