/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc.templates;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.templates.CommandEventAction;
import net.citizensnpcs.api.npc.templates.CommandListExecutor;
import net.citizensnpcs.api.npc.templates.TemplateWorkspace;
import net.citizensnpcs.api.npc.templates.YamlReplacementAction;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.NamespacedKey;

public class Template {
    private final List<Consumer<NPC>> actions = Lists.newArrayList();
    private final NamespacedKey key;

    private Template(NamespacedKey namespacedKey) {
        this.key = namespacedKey;
    }

    private void addAction(Consumer<NPC> consumer) {
        this.actions.add(consumer);
    }

    public void apply(NPC nPC) {
        boolean bl = nPC.isSpawned();
        if (bl) {
            nPC.despawn(DespawnReason.PENDING_RESPAWN);
        }
        for (Consumer<NPC> consumer : this.actions) {
            consumer.accept(nPC);
        }
        if (bl) {
            nPC.spawn(nPC.getStoredLocation());
        }
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public static Template load(TemplateWorkspace templateWorkspace, NamespacedKey namespacedKey, DataKey dataKey) {
        Template template = new Template(namespacedKey);
        if (dataKey.keyExists("yaml_replace")) {
            template.addAction((Consumer)((Object)PersistenceLoader.load(YamlReplacementAction.class, dataKey.getRelative("yaml_replace"))));
        }
        if (dataKey.keyExists("commands")) {
            Template.loadCommands(template, templateWorkspace, dataKey.getRelative("commands"));
        }
        return template;
    }

    private static void loadCommands(Template template, TemplateWorkspace templateWorkspace, DataKey dataKey) {
        for (DataKey dataKey2 : dataKey.getSubKeys()) {
            if (!dataKey2.name().equals("on_spawn")) continue;
            template.addAction(new CommandEventAction(NPCSpawnEvent.class, new CommandListExecutor((List)dataKey.getRaw(""))));
        }
    }
}

