/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc.templates;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.DelegatePersistence;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.MemoryDataKey;

public class YamlReplacementAction
implements Consumer<NPC> {
    private final boolean override;
    private final Map<String, Object> replacements;

    @DelegatePersistence(value=YRAPersister.class)
    private YamlReplacementAction(boolean bl, Map<String, Object> map) {
        this.replacements = map;
        this.override = bl;
    }

    @Override
    public void accept(NPC nPC) {
        MemoryDataKey memoryDataKey = new MemoryDataKey();
        nPC.save(memoryDataKey);
        ArrayList arrayList = Lists.newArrayList((Object[])new Node[]{new Node("", this.replacements)});
        for (int i = 0; i < arrayList.size(); ++i) {
            Node node = (Node)arrayList.get(i);
            for (Map.Entry<String, Object> entry : node.map.entrySet()) {
                String string;
                String string2 = string = node.headKey.isEmpty() ? entry.getKey() : node.headKey + '.' + entry.getKey();
                if (entry.getValue() instanceof Map) {
                    arrayList.add(new Node(string, (Map)entry.getValue()));
                    continue;
                }
                boolean bl = memoryDataKey.keyExists(string) || this.override;
                if (!bl || string.equals("uuid")) continue;
                memoryDataKey.setRaw(string, entry.getValue());
            }
        }
        nPC.load(memoryDataKey);
    }

    private static class Node {
        String headKey;
        Map<String, Object> map;

        private Node(String string, Map<String, Object> map) {
            this.headKey = string;
            this.map = map;
        }
    }

    private static class YRAPersister
    implements Persister<YamlReplacementAction> {
        @Override
        public YamlReplacementAction create(DataKey dataKey) {
            return new YamlReplacementAction(dataKey.getBoolean("override"), dataKey.getRelative("replacements").getValuesDeep());
        }

        @Override
        public void save(YamlReplacementAction yamlReplacementAction, DataKey dataKey) {
            dataKey.setBoolean("override", yamlReplacementAction.override);
            dataKey.setRaw("replacements", yamlReplacementAction.replacements);
        }
    }
}

