/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.persistence;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.util.DataKey;

public class PersisterRegistry<T>
implements Persister<T> {
    private final Map<String, WeakReference<Class<? extends T>>> registry = Maps.newHashMap();

    PersisterRegistry() {
    }

    @Override
    public T create(DataKey dataKey) {
        String string = dataKey.getString("type");
        WeakReference<Class<T>> weakReference = this.registry.get(string);
        if (weakReference == null) {
            throw new IllegalStateException("missing registration for type " + string);
        }
        return (T)PersistenceLoader.load((Class)weakReference.get(), dataKey);
    }

    public void register(String string, Class<? extends T> clazz) {
        this.registry.put(string, new WeakReference<Class<? extends T>>(clazz));
    }

    public Iterable<Class<? extends T>> registeredTypes() {
        return Iterables.transform(this.registry.values(), Reference::get);
    }

    @Override
    public void save(T t, DataKey dataKey) {
        PersistenceLoader.save(t, dataKey);
        Class<?> clazz = t.getClass();
        for (Map.Entry<String, WeakReference<Class<T>>> entry : this.registry.entrySet()) {
            if (clazz != entry.getValue().get()) continue;
            dataKey.setString("type", entry.getKey());
            return;
        }
        throw new IllegalStateException("missing registration for instance " + t);
    }
}

