/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.ItemStorage;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

@TraitName(value="equipment")
public class Equipment
extends Trait {
    private final ItemStack[] equipment = new ItemStack[6];
    private static boolean SUPPORT_OFFHAND = true;

    public Equipment() {
        super("equipment");
    }

    private ItemStack clone(ItemStack itemStack) {
        return itemStack == null || itemStack.getType() == Material.AIR ? null : itemStack.clone();
    }

    public ItemStack get(EquipmentSlot equipmentSlot) {
        return this.get(equipmentSlot.getIndex());
    }

    public ItemStack get(int n) {
        if (this.npc.getEntity() instanceof Enderman && n != 0) {
            throw new IllegalArgumentException("Slot must be 0 for enderman");
        }
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Slot must be between 0 and 5");
        }
        return this.equipment[n];
    }

    public ItemStack[] getEquipment() {
        return this.equipment;
    }

    public Map<EquipmentSlot, ItemStack> getEquipmentBySlot() {
        EnumMap enumMap = Maps.newEnumMap(EquipmentSlot.class);
        enumMap.put(EquipmentSlot.HAND, this.equipment[0]);
        enumMap.put(EquipmentSlot.HELMET, this.equipment[1]);
        enumMap.put(EquipmentSlot.CHESTPLATE, this.equipment[2]);
        enumMap.put(EquipmentSlot.LEGGINGS, this.equipment[3]);
        enumMap.put(EquipmentSlot.BOOTS, this.equipment[4]);
        enumMap.put(EquipmentSlot.OFF_HAND, this.equipment[5]);
        return enumMap;
    }

    private EntityEquipment getEquipmentFromEntity(Entity entity) {
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).getEquipment();
        }
        throw new IllegalStateException("Unsupported entity equipment");
    }

    @Override
    public void load(DataKey dataKey) {
        if (dataKey.keyExists("hand")) {
            this.equipment[0] = ItemStorage.loadItemStack(dataKey.getRelative("hand"));
        }
        if (dataKey.keyExists("helmet")) {
            this.equipment[1] = ItemStorage.loadItemStack(dataKey.getRelative("helmet"));
        }
        if (dataKey.keyExists("chestplate")) {
            this.equipment[2] = ItemStorage.loadItemStack(dataKey.getRelative("chestplate"));
        }
        if (dataKey.keyExists("leggings")) {
            this.equipment[3] = ItemStorage.loadItemStack(dataKey.getRelative("leggings"));
        }
        if (dataKey.keyExists("boots")) {
            this.equipment[4] = ItemStorage.loadItemStack(dataKey.getRelative("boots"));
        }
        if (dataKey.keyExists("offhand")) {
            this.equipment[5] = ItemStorage.loadItemStack(dataKey.getRelative("offhand"));
        }
    }

    @Override
    public void onAttach() {
        this.npc.scheduleUpdate(NPC.NPCUpdate.PACKET);
        this.run();
    }

    @Override
    public void onSpawn() {
        if (!(this.npc.getEntity() instanceof LivingEntity) && !(this.npc.getEntity() instanceof ArmorStand)) {
            return;
        }
        if (this.npc.getEntity() instanceof Enderman) {
            Enderman enderman = (Enderman)this.npc.getEntity();
            if (this.equipment[0] != null) {
                if (SpigotUtil.isUsing1_13API()) {
                    enderman.setCarriedBlock(this.equipment[0].getType().createBlockData());
                } else {
                    enderman.setCarriedMaterial(this.equipment[0].getData());
                }
            }
        } else {
            EntityEquipment entityEquipment = this.getEquipmentFromEntity(this.npc.getEntity());
            if (this.equipment[0] != null) {
                entityEquipment.setItemInHand(this.equipment[0]);
            }
            entityEquipment.setHelmet(this.equipment[1]);
            entityEquipment.setChestplate(this.equipment[2]);
            entityEquipment.setLeggings(this.equipment[3]);
            entityEquipment.setBoots(this.equipment[4]);
            try {
                entityEquipment.setItemInOffHand(this.equipment[5]);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        if (this.npc.getEntity() instanceof Player) {
            ((Player)this.npc.getEntity()).updateInventory();
        }
    }

    @Override
    public void run() {
        if (!(this.npc.getEntity() instanceof LivingEntity) || !this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        if (this.npc.getEntity() instanceof Enderman) {
            Enderman enderman = (Enderman)this.npc.getEntity();
            if (this.equipment[0] != null) {
                this.equipment[0] = SpigotUtil.isUsing1_13API() ? new ItemStack(enderman.getCarriedBlock().getMaterial(), 1) : enderman.getCarriedMaterial().toItemStack(1);
            }
        } else {
            EntityEquipment entityEquipment = this.getEquipmentFromEntity(this.npc.getEntity());
            this.equipment[0] = this.clone(entityEquipment.getItemInHand());
            this.equipment[1] = this.clone(entityEquipment.getHelmet());
            this.equipment[2] = this.clone(entityEquipment.getChestplate());
            this.equipment[3] = this.clone(entityEquipment.getLeggings());
            this.equipment[4] = this.clone(entityEquipment.getBoots());
            if (SUPPORT_OFFHAND) {
                try {
                    this.equipment[5] = this.clone(entityEquipment.getItemInOffHand());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    SUPPORT_OFFHAND = false;
                }
            }
        }
    }

    @Override
    public void save(DataKey dataKey) {
        this.saveOrRemove(dataKey.getRelative("hand"), this.equipment[0]);
        this.saveOrRemove(dataKey.getRelative("helmet"), this.equipment[1]);
        this.saveOrRemove(dataKey.getRelative("chestplate"), this.equipment[2]);
        this.saveOrRemove(dataKey.getRelative("leggings"), this.equipment[3]);
        this.saveOrRemove(dataKey.getRelative("boots"), this.equipment[4]);
        this.saveOrRemove(dataKey.getRelative("offhand"), this.equipment[5]);
    }

    private void saveOrRemove(DataKey dataKey, ItemStack itemStack) {
        if (itemStack != null) {
            ItemStorage.saveItem(dataKey, itemStack);
        } else if (dataKey.keyExists("")) {
            dataKey.removeKey("");
        }
    }

    public void set(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        this.set(equipmentSlot.getIndex(), itemStack);
    }

    public void set(int n, ItemStack itemStack) {
        if (itemStack != null) {
            itemStack = itemStack.getType() == Material.AIR ? null : itemStack.clone();
        }
        this.equipment[n] = itemStack;
        if (n == 0) {
            this.npc.getOrAddTrait(Inventory.class).setItemInHand(itemStack);
        }
        if (!(this.npc.getEntity() instanceof LivingEntity) && !(this.npc.getEntity() instanceof ArmorStand)) {
            return;
        }
        if (this.npc.getEntity() instanceof Enderman) {
            if (n != 0) {
                throw new UnsupportedOperationException("Slot can only be 0 for enderman");
            }
            if (SpigotUtil.isUsing1_13API()) {
                ((Enderman)this.npc.getEntity()).setCarriedBlock(itemStack.getType().createBlockData());
            } else {
                ((Enderman)this.npc.getEntity()).setCarriedMaterial(itemStack.getData());
            }
        } else {
            EntityEquipment entityEquipment = this.getEquipmentFromEntity(this.npc.getEntity());
            switch (n) {
                case 0: {
                    entityEquipment.setItemInHand(itemStack);
                    break;
                }
                case 1: {
                    entityEquipment.setHelmet(itemStack);
                    break;
                }
                case 2: {
                    entityEquipment.setChestplate(itemStack);
                    break;
                }
                case 3: {
                    entityEquipment.setLeggings(itemStack);
                    break;
                }
                case 4: {
                    entityEquipment.setBoots(itemStack);
                    break;
                }
                case 5: {
                    if (!SUPPORT_OFFHAND) break;
                    try {
                        entityEquipment.setItemInOffHand(itemStack);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        SUPPORT_OFFHAND = false;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Slot must be between 0 and 5");
                }
            }
        }
        if (this.npc.getEntity() instanceof Player) {
            ((Player)this.npc.getEntity()).updateInventory();
        }
    }

    public String toString() {
        return "{hand=" + this.equipment[0] + ",helmet=" + this.equipment[1] + ",chestplate=" + this.equipment[2] + ",leggings=" + this.equipment[3] + ",boots=" + this.equipment[4] + ",offhand=" + this.equipment[5] + "}";
    }

    public static enum EquipmentSlot {
        BOOTS(4),
        CHESTPLATE(2),
        HAND(0),
        HELMET(1),
        LEGGINGS(3),
        OFF_HAND(5);

        private final int index;

        private EquipmentSlot(int n2) {
            this.index = n2;
        }

        int getIndex() {
            return this.index;
        }
    }
}

