/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.CitizensDisableEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class Placeholders
implements Listener {
    private static final Pattern PLACEHOLDER_MATCHER = Pattern.compile("<(id|npc|owner|random_player|random_world_player|random_npc|random_npc_id|nearest_npc_id|nearest_player|world)>");
    private static boolean PLACEHOLDERAPI_ENABLED = true;
    private static final List<PlaceholderProvider> PLACEHOLDERS = Lists.newArrayList();
    private static final Pattern PLAYER_PLACEHOLDER_MATCHER = Pattern.compile("(<player>|<p>|%player%|<player_uuid>|<random_player>|<random_world_player>|<random_npc>|<random_npc_id>|<nearest_npc_id>|<nearest_player>|<world>)");
    private static final Collection<String> PLAYER_UUID_VARIABLES = ImmutableSet.of((Object)"<player_uuid>");
    private static final Collection<String> PLAYER_VARIABLES = ImmutableSet.of((Object)"<player>", (Object)"<p>", (Object)"%player%");

    public static boolean containsPlaceholders(String string) {
        try {
            if (PLACEHOLDERAPI_ENABLED && PlaceholderAPI.containsPlaceholders((String)string)) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return PLAYER_PLACEHOLDER_MATCHER.matcher(string).find();
    }

    private static OfflinePlayer getPlayer(BlockCommandSender blockCommandSender) {
        return CitizensAPI.getNMSHelper().getPlayer(blockCommandSender);
    }

    private static String getWorldReplacement(Location location, String string, Entity entity) {
        if (string.charAt(0) != '<') {
            string = '<' + string + '>';
        }
        switch (string) {
            case "<random_player>": 
            case "<random_world_player>": {
                Collection collection = string.equals("<random_player>") ? Bukkit.getServer().getOnlinePlayers() : location.getWorld().getPlayers();
                Player player = (Player)Iterables.get((Iterable)collection, (int)new Random().nextInt(collection.size()), null);
                if (player == null) break;
                return player.getName();
            }
            case "<random_npc>": 
            case "<random_npc_id>": {
                ArrayList arrayList = Lists.newArrayList((Iterable)CitizensAPI.getNPCRegistry());
                if (arrayList.size() <= 0) break;
                NPC nPC3 = (NPC)arrayList.get(new Random().nextInt(arrayList.size()));
                return string.equals("<random_npc>") ? nPC3.getFullName() : Integer.toString(nPC3.getId());
            }
            case "<nearest_npc_id>": {
                Optional<NPC> optional = location.getWorld().getNearbyEntities(location, 25.0, 25.0, 25.0).stream().map(CitizensAPI.getNPCRegistry()::getNPC).filter(nPC -> nPC != null && nPC.getEntity() != entity).min((nPC, nPC2) -> Double.compare(nPC.getEntity().getLocation().distanceSquared(location), nPC2.getEntity().getLocation().distanceSquared(location)));
                if (!optional.isPresent()) break;
                return Integer.toString(optional.get().getId());
            }
            case "<nearest_player>": {
                double d = Double.MAX_VALUE;
                Player player = null;
                for (Player player2 : CitizensAPI.getLocationLookup().getNearbyPlayers(location, 25.0)) {
                    double d2;
                    if (player2 == entity || CitizensAPI.getNPCRegistry().isNPC((Entity)player2) || (d2 = player2.getLocation().distanceSquared(location)) > d) continue;
                    d = d2;
                    player = player2;
                }
                if (player == null) break;
                return player.getName();
            }
            case "<world>": {
                return location.getWorld().getName();
            }
        }
        return "";
    }

    @EventHandler
    private static void onCitizensDisable(CitizensDisableEvent citizensDisableEvent) {
        PLACEHOLDERS.clear();
    }

    public static void registerNPCPlaceholder(Pattern pattern, PlaceholderFunction placeholderFunction) {
        if (pattern.pattern().charAt(0) != '<') {
            pattern = Pattern.compile('<' + pattern.pattern() + '>', pattern.flags());
        }
        PLACEHOLDERS.add(new PlaceholderProvider(pattern, placeholderFunction));
    }

    public static String replace(String string, CommandSender commandSender, NPC nPC) {
        return Placeholders.replace(string, commandSender, nPC, false);
    }

    private static String replace(String string, CommandSender commandSender, NPC nPC, boolean bl) {
        string = Placeholders.replace(string, (OfflinePlayer)(commandSender instanceof OfflinePlayer ? (OfflinePlayer)commandSender : (commandSender instanceof BlockCommandSender ? Placeholders.getPlayer((BlockCommandSender)commandSender) : null)));
        if (nPC == null || string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = PLACEHOLDER_MATCHER.matcher(string);
        while (matcher.find()) {
            String object2;
            Object object = "";
            switch (object2 = matcher.group(1)) {
                case "uuid": {
                    object = nPC.getUniqueId().toString();
                    break;
                }
                case "id": {
                    object = Integer.toString(nPC.getId());
                    break;
                }
                case "npc": {
                    object = bl ? string : nPC.getFullName();
                    break;
                }
                case "owner": {
                    object = nPC.getOrAddTrait(Owner.class).getOwner();
                    break;
                }
                default: {
                    object = Placeholders.getWorldReplacement(nPC.getEntity().getLocation(), object2, nPC.getEntity());
                }
            }
            matcher.appendReplacement(stringBuffer, "");
            stringBuffer.append((String)object);
        }
        matcher.appendTail(stringBuffer);
        for (PlaceholderProvider placeholderProvider : PLACEHOLDERS) {
            matcher = placeholderProvider.regex.matcher(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String string2 = matcher.group().substring(1, matcher.group().length() - 1);
                matcher.appendReplacement(stringBuffer, "");
                stringBuffer.append(placeholderProvider.func.apply(nPC, commandSender, string2));
            }
            matcher.appendTail(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, OfflinePlayer offlinePlayer) {
        if (offlinePlayer == null || !offlinePlayer.isOnline() && !offlinePlayer.hasPlayedBefore()) {
            return Placeholders.setPlaceholderAPIPlaceholders(string, offlinePlayer);
        }
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = PLAYER_PLACEHOLDER_MATCHER.matcher(string);
        while (matcher.find()) {
            String string2 = "";
            String string3 = matcher.group(1);
            string2 = PLAYER_VARIABLES.contains(string3) ? offlinePlayer.getName() : (PLAYER_UUID_VARIABLES.contains(string3) ? offlinePlayer.getUniqueId().toString() : (offlinePlayer.getPlayer() != null ? Placeholders.getWorldReplacement(offlinePlayer.getPlayer().getLocation(), string3, (Entity)offlinePlayer.getPlayer()) : string3));
            matcher.appendReplacement(stringBuffer, "");
            stringBuffer.append(string2);
        }
        matcher.appendTail(stringBuffer);
        string = stringBuffer.toString();
        return Placeholders.setPlaceholderAPIPlaceholders(string, offlinePlayer);
    }

    public static String replaceName(String string, CommandSender commandSender, NPC nPC) {
        return Placeholders.replace(string, commandSender, nPC, true);
    }

    private static String setPlaceholderAPIPlaceholders(String string, OfflinePlayer offlinePlayer) {
        if (!PLACEHOLDERAPI_ENABLED) {
            return string;
        }
        try {
            return PlaceholderAPI.setPlaceholders((OfflinePlayer)offlinePlayer, (String)string);
        }
        catch (Throwable throwable) {
            PLACEHOLDERAPI_ENABLED = false;
            return string;
        }
    }

    private static class PlaceholderProvider {
        PlaceholderFunction func;
        Pattern regex;

        PlaceholderProvider(Pattern pattern, PlaceholderFunction placeholderFunction) {
            this.regex = pattern;
            this.func = placeholderFunction;
        }
    }

    public static interface PlaceholderFunction {
        public String apply(NPC var1, CommandSender var2, String var3);
    }
}

