/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.editor.CopierEditor;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.editor.EquipmentEditor;
import net.citizensnpcs.trait.text.Text;
import net.citizensnpcs.trait.waypoint.Waypoints;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Requirements(selected=true, ownership=true)
public class EditorCommands {
    @Command(aliases={"npc"}, usage="copier", desc="", modifiers={"copier"}, min=1, max=1, permission="citizens.npc.edit.copier")
    public void copier(CommandContext commandContext, Player player, NPC nPC) {
        Editor.enterOrLeave(player, new CopierEditor(player, nPC));
    }

    @Command(aliases={"npc"}, usage="equip", desc="", modifiers={"equip"}, min=1, max=1, permission="citizens.npc.edit.equip")
    public void equip(CommandContext commandContext, Player player, NPC nPC) {
        if (!nPC.isSpawned()) {
            throw new CommandException("NPC must be spawned");
        }
        Editor.enterOrLeave(player, new EquipmentEditor(player, nPC));
    }

    @Command(aliases={"npc"}, usage="path", desc="", modifiers={"path"}, min=1, flags="*", permission="citizens.npc.edit.path")
    @Requirements(selected=true, ownership=true)
    public void path(CommandContext commandContext, Player player, NPC nPC) {
        Editor editor = nPC.getOrAddTrait(Waypoints.class).getEditor((CommandSender)player, commandContext);
        if (editor == null) {
            return;
        }
        if (player.isConversing() && commandContext.argsLength() > 1) {
            player.acceptConversationInput(commandContext.getJoinedStrings(1));
            return;
        }
        Editor.enterOrLeave(player, editor);
    }

    @Command(aliases={"npc"}, usage="text", desc="", modifiers={"text"}, min=1, permission="citizens.npc.edit.text")
    public void text(CommandContext commandContext, Player player, NPC nPC) {
        if (player.isConversing() && Editor.hasEditor(player) && commandContext.argsLength() > 1) {
            player.acceptConversationInput(commandContext.getJoinedStrings(1));
            return;
        }
        Editor.enterOrLeave(player, nPC.getOrAddTrait(Text.class).getEditor(player));
    }
}

