/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.command.exception.ServerCommandException;
import net.citizensnpcs.api.command.exception.UnhandledCommandException;
import net.citizensnpcs.api.command.exception.WrappedCommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.NumericPrompt;
import org.bukkit.conversations.Prompt;

public class NPCCommandSelector
extends NumericPrompt {
    private final Callback callback;
    private final List<NPC> choices;

    public NPCCommandSelector(Callback callback, List<NPC> list) {
        this.callback = callback;
        this.choices = list;
    }

    protected Prompt acceptValidatedInput(ConversationContext conversationContext, Number number) {
        NPC nPC2;
        boolean bl = false;
        for (NPC nPC2 : this.choices) {
            if (number.intValue() != nPC2.getId()) continue;
            bl = true;
            break;
        }
        CommandSender commandSender = (CommandSender)conversationContext.getForWhom();
        if (!bl) {
            Messaging.sendErrorTr(commandSender, "citizens.conversations.selection.invalid-choice", number);
            return this;
        }
        nPC2 = CitizensAPI.getNPCRegistry().getById(number.intValue());
        try {
            this.callback.run(nPC2);
        }
        catch (ServerCommandException serverCommandException) {
            Messaging.sendTr(commandSender, "citizens.commands.requirements.must-be-ingame", new Object[0]);
        }
        catch (CommandUsageException commandUsageException) {
            Messaging.sendError(commandSender, commandUsageException.getMessage());
            Messaging.sendError(commandSender, commandUsageException.getUsage());
        }
        catch (UnhandledCommandException unhandledCommandException) {
            unhandledCommandException.printStackTrace();
        }
        catch (WrappedCommandException wrappedCommandException) {
            wrappedCommandException.getCause().printStackTrace();
        }
        catch (CommandException commandException) {
            Messaging.sendError(commandSender, Messaging.tryTranslate(commandException.getMessage()));
        }
        catch (NumberFormatException numberFormatException) {
            Messaging.sendErrorTr(commandSender, "citizens.commands.invalid-number", new Object[0]);
        }
        return null;
    }

    public String getPromptText(ConversationContext conversationContext) {
        String string = Messaging.tr("citizens.editors.selection.start-prompt", new Object[0]);
        for (NPC nPC : this.choices) {
            string = string + "<br>    - " + nPC.getId();
        }
        Messaging.send((CommandSender)conversationContext.getForWhom(), string);
        return "";
    }

    public static void start(Callback callback, Conversable conversable, List<NPC> list) {
        Conversation conversation = new ConversationFactory(CitizensAPI.getPlugin()).withLocalEcho(false).withEscapeSequence("exit").withModality(false).withFirstPrompt((Prompt)new NPCCommandSelector(callback, list)).buildConversation(conversable);
        conversation.begin();
    }

    public static void startWithCallback(Callback callback, NPCRegistry nPCRegistry, CommandSender commandSender, CommandContext commandContext, String string) {
        try {
            UUID uUID = UUID.fromString(string);
            callback.run(nPCRegistry.getByUniqueIdGlobal(uUID));
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Integer n = Ints.tryParse((String)string);
            if (n != null) {
                callback.run(nPCRegistry.getById(n));
                return;
            }
            String string2 = commandContext.getString(1);
            ArrayList arrayList = Lists.newArrayList();
            double d = -1.0;
            if (commandContext.hasValueFlag("range")) {
                d = Math.abs(commandContext.getFlagDouble("range"));
            }
            for (NPC nPC : nPCRegistry) {
                if (!nPC.getName().equalsIgnoreCase(string2) || d > 0.0 && nPC.isSpawned() && !Util.locationWithinRange(commandContext.getSenderLocation(), nPC.getEntity().getLocation(), d)) continue;
                arrayList.add(nPC);
            }
            if (arrayList.size() == 1) {
                callback.run((NPC)arrayList.get(0));
            } else if (arrayList.size() > 1) {
                NPCCommandSelector.start(callback, (Conversable)commandSender, arrayList);
            }
            return;
        }
    }

    public static interface Callback {
        public void run(NPC var1) throws CommandException;
    }
}

