/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_16_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_16_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.AxisAlignedBB;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.DamageSource;
import net.minecraft.server.v1_16_R3.EntityBoat;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityMinecartAbstract;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EntityZombieVillager;
import net.minecraft.server.v1_16_R3.EnumPistonReaction;
import net.minecraft.server.v1_16_R3.FluidType;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.SoundEffect;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftVillagerZombie;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.util.Vector;

public class ZombieVillagerController
extends MobEntityController {
    public ZombieVillagerController() {
        super(EntityZombieVillagerNPC.class);
    }

    public ZombieVillager getBukkitEntity() {
        return (ZombieVillager)super.getBukkitEntity();
    }

    public static class EntityZombieVillagerNPC
    extends EntityZombieVillager
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityZombieVillagerNPC(EntityTypes<? extends EntityZombieVillager> entityTypes, World world) {
            this(entityTypes, world, null);
        }

        public EntityZombieVillagerNPC(EntityTypes<? extends EntityZombieVillager> entityTypes, World world, NPC nPC) {
            super(entityTypes, world);
            this.npc = (CitizensNPC)nPC;
        }

        public void a(AxisAlignedBB axisAlignedBB) {
            super.a(NMSBoundingBox.makeBB(this.npc, axisAlignedBB));
        }

        protected void a(double d, boolean bl, IBlockData iBlockData, BlockPosition blockPosition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d, bl, iBlockData, blockPosition);
            }
        }

        public void a(float f, double d, double d2) {
            NMS.callKnockbackEvent(this.npc, f, d, d2, nPCKnockbackEvent -> super.a((float)nPCKnockbackEvent.getStrength(), nPCKnockbackEvent.getKnockbackVector().getX(), nPCKnockbackEvent.getKnockbackVector().getZ()));
        }

        public boolean a(Tag<FluidType> tag, double d) {
            if (this.npc == null) {
                return super.a(tag, d);
            }
            Vec3D vec3D = this.getMot().add(0.0, 0.0, 0.0);
            boolean bl = super.a(tag, d);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(vec3D);
            }
            return bl;
        }

        public boolean b(float f, float f2) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.b(f, f2);
            }
            return false;
        }

        public int bP() {
            return NMS.getFallDistance(this.npc, super.bP());
        }

        public void checkDespawn() {
            if (this.npc == null) {
                super.checkDespawn();
            }
        }

        public void collide(net.minecraft.server.v1_16_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.d(nBTTagCompound) : false;
        }

        public float dJ() {
            return NMS.getJumpPower(this.npc, super.dJ());
        }

        public void g(Vec3D vec3D) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.g(vec3D);
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3D);
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_16_R3.Entity)this, (CraftEntity)new ZombieVillagerNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction getPushReaction() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.IGNORE : super.getPushReaction();
        }

        public SoundEffect getSoundAmbient() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundAmbient(), NPC.Metadata.AMBIENT_SOUND);
        }

        public SoundEffect getSoundDeath() {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundDeath(), NPC.Metadata.DEATH_SOUND);
        }

        public SoundEffect getSoundHurt(DamageSource damageSource) {
            return NMSImpl.getSoundEffect(this.npc, super.getSoundHurt(damageSource), NPC.Metadata.HURT_SOUND);
        }

        public void i(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public boolean isClimbing() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.isClimbing();
            }
            return false;
        }

        public boolean isLeashed() {
            return NMSImpl.isLeashed(this.npc, () -> super.isLeashed(), (EntityInsentient)this);
        }

        public void mobTick() {
            super.mobTick();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                this.npc.update();
            }
        }

        protected boolean n(net.minecraft.server.v1_16_R3.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.n(entity);
        }
    }

    public static class ZombieVillagerNPC
    extends CraftVillagerZombie
    implements ForwardingNPCHolder {
        public ZombieVillagerNPC(EntityZombieVillagerNPC entityZombieVillagerNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityZombieVillager)entityZombieVillagerNPC);
        }
    }
}

