/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_16_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_16_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.AxisAlignedBB;
import net.minecraft.server.v1_16_R3.EntityEvokerFangs;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumHand;
import net.minecraft.server.v1_16_R3.EnumInteractionResult;
import net.minecraft.server.v1_16_R3.EnumPistonReaction;
import net.minecraft.server.v1_16_R3.FluidType;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEvokerFangs;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.util.Vector;

public class EvokerFangsController
extends MobEntityController {
    public EvokerFangsController() {
        super(EntityEvokerFangsNPC.class);
    }

    public EvokerFangs getBukkitEntity() {
        return (EvokerFangs)super.getBukkitEntity();
    }

    public static class EntityEvokerFangsNPC
    extends EntityEvokerFangs
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEvokerFangsNPC(EntityTypes<? extends EntityEvokerFangs> entityTypes, World world) {
            this(entityTypes, world, null);
        }

        public EntityEvokerFangsNPC(EntityTypes<? extends EntityEvokerFangs> entityTypes, World world, NPC nPC) {
            super(entityTypes, world);
            this.npc = (CitizensNPC)nPC;
        }

        public void a(AxisAlignedBB axisAlignedBB) {
            super.a(NMSBoundingBox.makeBB(this.npc, axisAlignedBB));
        }

        public EnumInteractionResult a(EntityHuman entityHuman, Vec3D vec3D, EnumHand enumHand) {
            if (this.npc == null) {
                return super.a(entityHuman, vec3D, enumHand);
            }
            PlayerInteractEntityEvent playerInteractEntityEvent = new PlayerInteractEntityEvent((Player)entityHuman.getBukkitEntity(), (Entity)this.getBukkitEntity());
            Bukkit.getPluginManager().callEvent((Event)playerInteractEntityEvent);
            return playerInteractEntityEvent.isCancelled() ? EnumInteractionResult.FAIL : EnumInteractionResult.SUCCESS;
        }

        public boolean a(Tag<FluidType> tag, double d) {
            if (this.npc == null) {
                return super.a(tag, d);
            }
            Vec3D vec3D = this.getMot().add(0.0, 0.0, 0.0);
            boolean bl = super.a(tag, d);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(vec3D);
            }
            return bl;
        }

        public void collide(net.minecraft.server.v1_16_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.d(nBTTagCompound) : false;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_16_R3.Entity)this, (CraftEntity)new EvokerFangsNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction getPushReaction() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.IGNORE : super.getPushReaction();
        }

        public void i(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void tick() {
            super.tick();
            if (this.npc != null) {
                this.npc.update();
            }
        }
    }

    public static class EvokerFangsNPC
    extends CraftEvokerFangs
    implements ForwardingNPCHolder {
        public EvokerFangsNPC(EntityEvokerFangsNPC entityEvokerFangsNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityEvokerFangs)entityEvokerFangsNPC);
        }
    }
}

