/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_16_R3.entity.nonliving;

import com.mojang.authlib.GameProfile;
import java.lang.invoke.MethodHandle;
import java.util.UUID;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_16_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_16_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_16_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_16_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_16_R3.AxisAlignedBB;
import net.minecraft.server.v1_16_R3.EntityFishingHook;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.EnumPistonReaction;
import net.minecraft.server.v1_16_R3.FluidType;
import net.minecraft.server.v1_16_R3.IMaterial;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.Items;
import net.minecraft.server.v1_16_R3.MinecraftServer;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.PlayerInteractManager;
import net.minecraft.server.v1_16_R3.Tag;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftFishHook;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.util.Vector;

public class FishingHookController
extends MobEntityController {
    public FishingHookController() {
        super(EntityFishingHookNPC.class);
    }

    public FishHook getBukkitEntity() {
        return (FishHook)super.getBukkitEntity();
    }

    public static class EntityFishingHookNPC
    extends EntityFishingHook
    implements NPCHolder {
        private final CitizensNPC npc;
        private static MethodHandle G = NMS.getSetter(EntityFishingHook.class, "g");

        public EntityFishingHookNPC(EntityTypes<? extends EntityFishingHook> entityTypes, World world) {
            this(entityTypes, world, null);
        }

        public EntityFishingHookNPC(EntityTypes<? extends EntityFishingHook> entityTypes, World world, NPC nPC) {
            super((EntityHuman)new EntityPlayer((MinecraftServer)world.getServer().getServer(), (WorldServer)world, new GameProfile(UUID.randomUUID(), "dummyfishhook"), new PlayerInteractManager((WorldServer)world)){}, world, 0, 0);
            this.npc = (CitizensNPC)nPC;
        }

        public void a(AxisAlignedBB axisAlignedBB) {
            super.a(NMSBoundingBox.makeBB(this.npc, axisAlignedBB));
        }

        public boolean a(Tag<FluidType> tag, double d) {
            if (this.npc == null) {
                return super.a(tag, d);
            }
            Vec3D vec3D = this.getMot().add(0.0, 0.0, 0.0);
            boolean bl = super.a(tag, d);
            if (!this.npc.isPushableByFluids()) {
                this.setMot(vec3D);
            }
            return bl;
        }

        public void collide(net.minecraft.server.v1_16_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.d(nBTTagCompound) : false;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.server.v1_16_R3.Entity)this, (CraftEntity)new FishingHookNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction getPushReaction() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.IGNORE : super.getPushReaction();
        }

        public double h(net.minecraft.server.v1_16_R3.Entity entity) {
            if (entity == this.getShooter()) {
                return 0.0;
            }
            return super.h(entity);
        }

        public void i(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void tick() {
            if (this.npc != null) {
                ((EntityHuman)this.getShooter()).setHealth(20.0f);
                this.getShooter().dead = false;
                ((EntityHuman)this.getShooter()).inventory.items.set(((EntityHuman)this.getShooter()).inventory.itemInHandIndex, (Object)new ItemStack((IMaterial)Items.FISHING_ROD, 1));
                try {
                    G.invoke(this, 0);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                this.npc.update();
            } else {
                super.tick();
            }
        }
    }

    public static class FishingHookNPC
    extends CraftFishHook
    implements ForwardingNPCHolder {
        public FishingHookNPC(EntityFishingHookNPC entityFishingHookNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityFishingHook)entityFishingHookNPC);
        }
    }
}

