/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_20_R4.entity.MobEntityController;
import net.citizensnpcs.nms.v1_20_R4.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_20_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftBlockDisplay;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;

public class BlockDisplayController
extends MobEntityController {
    public BlockDisplayController() {
        super(EntityBlockDisplayNPC.class);
    }

    @Override
    protected Entity createEntity(Location location, NPC nPC) {
        EntityBlockDisplayNPC entityBlockDisplayNPC = new EntityBlockDisplayNPC((EntityTypes<? extends Display.BlockDisplay>)EntityTypes.j, (World)((CraftWorld)location.getWorld()).getHandle(), nPC);
        if (nPC != null) {
            ((BlockDisplay)entityBlockDisplayNPC.getBukkitEntity()).setBlock(nPC.getItemProvider().get().getType().createBlockData());
        }
        return entityBlockDisplayNPC.getBukkitEntity();
    }

    public BlockDisplay getBukkitEntity() {
        return (BlockDisplay)super.getBukkitEntity();
    }

    public static class EntityBlockDisplayNPC
    extends Display.BlockDisplay
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityBlockDisplayNPC(EntityTypes<? extends Display.BlockDisplay> entityTypes, World world) {
            this(entityTypes, world, null);
        }

        public EntityBlockDisplayNPC(EntityTypes<? extends Display.BlockDisplay> entityTypes, World world, NPC nPC) {
            super(entityTypes, world);
            this.npc = (CitizensNPC)nPC;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new BlockDisplayNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction k_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.k_();
        }

        public boolean bA() {
            return this.npc == null ? super.bA() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AxisAlignedBB as() {
            return NMSBoundingBox.makeBB(this.npc, super.as());
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.e(nBTTagCompound) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldServer, Vec3D vec3D) {
            if (this.npc == null) {
                return super.teleportTo(worldServer, vec3D);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldServer, vec3D);
        }

        public void l() {
            super.l();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public boolean a(TagKey<FluidType> tagKey, double d) {
            if (this.npc == null) {
                return super.a(tagKey, d);
            }
            Vec3D vec3D = this.ds().b(0.0, 0.0, 0.0);
            boolean bl = super.a(tagKey, d);
            if (!this.npc.isPushableByFluids()) {
                this.h(vec3D);
            }
            return bl;
        }
    }

    public static class BlockDisplayNPC
    extends CraftBlockDisplay
    implements ForwardingNPCHolder {
        public BlockDisplayNPC(EntityBlockDisplayNPC entityBlockDisplayNPC) {
            super((CraftServer)Bukkit.getServer(), (Display.BlockDisplay)entityBlockDisplayNPC);
        }
    }
}

