/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_20_R4.entity.MobEntityController;
import net.citizensnpcs.nms.v1_20_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftItemFrame;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;

public class ItemFrameController
extends MobEntityController {
    public ItemFrameController() {
        super(EntityItemFrameNPC.class);
    }

    @Override
    protected Entity createEntity(Location location, NPC nPC) {
        Entity entity = super.createEntity(location, nPC);
        EntityItemFrame entityItemFrame = (EntityItemFrame)((CraftEntity)entity).getHandle();
        entityItemFrame.a(EnumDirection.f);
        entityItemFrame.c = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        return entity;
    }

    public ItemFrame getBukkitEntity() {
        return (ItemFrame)super.getBukkitEntity();
    }

    public static class EntityItemFrameNPC
    extends EntityItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityItemFrameNPC(EntityTypes<? extends EntityItemFrame> entityTypes, World world) {
            this(entityTypes, world, null);
        }

        public EntityItemFrameNPC(EntityTypes<? extends EntityItemFrame> entityTypes, World world, NPC nPC) {
            super(entityTypes, world);
            this.npc = (CitizensNPC)nPC;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new ItemFrameNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction k_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.k_();
        }

        public boolean bA() {
            return this.npc == null ? super.bA() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AxisAlignedBB as() {
            return NMSBoundingBox.makeBB(this.npc, super.as());
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.e(nBTTagCompound) : false;
        }

        public boolean z() {
            return this.npc == null || !this.npc.isProtected() ? super.z() : true;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldServer, Vec3D vec3D) {
            if (this.npc == null) {
                return super.teleportTo(worldServer, vec3D);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldServer, vec3D);
        }

        public void l() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.l();
            }
        }

        public boolean a(TagKey<FluidType> tagKey, double d) {
            if (this.npc == null) {
                return super.a(tagKey, d);
            }
            Vec3D vec3D = this.ds().b(0.0, 0.0, 0.0);
            boolean bl = super.a(tagKey, d);
            if (!this.npc.isPushableByFluids()) {
                this.h(vec3D);
            }
            return bl;
        }
    }

    public static class ItemFrameNPC
    extends CraftItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public ItemFrameNPC(EntityItemFrameNPC entityItemFrameNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityItemFrame)entityItemFrameNPC);
            this.npc = entityItemFrameNPC.npc;
            this.setItem(this.npc.getItemProvider().get());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

